/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.memory;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Properties;
import org.drools.core.event.KieBaseEventSupport;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.jpa.processinstance.JPAWorkItemManagerFactory;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.memory.SerializableResult;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryLeakTest {
    private static final Logger logger = LoggerFactory.getLogger(MemoryLeakTest.class);
    private static HashMap<String, Object> testContext;
    private Environment env = null;
    private static final String PROCESS_NAME = "RuleTaskWithProcessInstance";

    @BeforeClass
    public static void beforeClass() {
        testContext = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
    }

    @AfterClass
    public static void afterClass() {
        PersistenceUtil.cleanUp(testContext);
    }

    @Before
    public void before() {
        this.env = PersistenceUtil.createEnvironment(testContext);
    }

    @Test
    public void findEventSupportRegisteredInstancesTest() {
        KieBase kbase = this.createKnowledgeBase();
        for (int i = 0; i < 3; ++i) {
            this.createKnowledgeSessionStartProcessEtc(kbase);
        }
        KieBaseEventSupport eventSupport = (KieBaseEventSupport)this.getValueOfField("eventSupport", KnowledgeBaseImpl.class, kbase);
        Assert.assertEquals((String)"Event listeners should have been detached", (long)0L, (long)eventSupport.getEventListeners().size());
    }

    private KieBase createKnowledgeBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"memory/BPMN2-RuleTaskWithInsertProcessInstance.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"memory/ProcessInstanceRule.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError err : kbuilder.getErrors()) {
                StringBuilder lines = new StringBuilder("");
                if (err.getLines().length > 0) {
                    lines.append(err.getLines()[0]);
                    for (int i = 1; i < err.getLines().length; ++i) {
                        lines.append(", " + err.getLines()[i]);
                    }
                }
                logger.warn(err.getMessage() + " (" + lines.toString() + ")");
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKnowledgeSessionStartProcessEtc(KieBase kbase) {
        logger.info("session count=" + kbase.getKieSessions().size());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)this.getKnowledgeSessionConfiguration(), (Environment)this.env);
        this.addEventListenersToSession(ksession);
        logger.info("session count=" + kbase.getKieSessions().size());
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        try {
            HashMap<String, String[]> processParams = new HashMap<String, String[]>();
            String[] fireballVarHolder = new String[1];
            processParams.put("fireball", fireballVarHolder);
            ProcessInstance processInstance = ksession.createProcessInstance(PROCESS_NAME, processParams);
            ksession.insert((Object)processInstance);
            ksession.startProcessInstance(processInstance.getId());
            ksession.fireAllRules();
            String[] procVar = (String[])((WorkflowProcessInstance)processInstance).getVariable("fireball");
            Assert.assertEquals((String)"Rule task did NOT fire or complete.", (Object)"boom!", (Object)procVar[0]);
            HashMap<String, SerializableResult> results = new HashMap<String, SerializableResult>();
            results.put("chaerg", new SerializableResult("zhrini", 302L, "F", "A", "T"));
            ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), results);
            Assert.assertNull((Object)ksession.getProcessInstance(processInstance.getId()));
        }
        finally {
            ksession.dispose();
        }
    }

    private KieSessionConfiguration getKnowledgeSessionConfiguration() {
        Properties ksessionProperties = new Properties();
        ksessionProperties.put("drools.commandService", PersistableRunner.class.getName());
        ksessionProperties.put("drools.processInstanceManagerFactory", "org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory");
        ksessionProperties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        ksessionProperties.put("drools.processSignalManagerFactory", "org.jbpm.persistence.processinstance.JPASignalManagerFactory");
        return KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)ksessionProperties);
    }

    private void addEventListenersToSession(StatefulKnowledgeSession session) {
        session.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                logger.info(">>> Firing All the Rules after process started! " + event);
                ((StatefulKnowledgeSession)event.getKieRuntime()).fireAllRules();
            }
        });
    }

    private Object getValueOfField(String fieldname, Class<?> sourceClass, Object source) {
        String sourceClassName = sourceClass.getName();
        Field field = null;
        try {
            field = sourceClass.getDeclaredField(fieldname);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        Assert.assertNotNull((String)("." + fieldname + " field is null!?!"), (Object)field);
        Object fieldValue = null;
        try {
            fieldValue = field.get(source);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        return fieldValue;
    }
}

