/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class SLAComplianceTest
extends JbpmBpmn2TestCase {
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public SLAComplianceTest(boolean persistence) throws Exception {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        SLAComplianceTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.abortProcessInstances(this.ksession);
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testSLAonProcessViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessMet() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)2L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        Collection active = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskMet() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        if (this.sessionPersistence) {
            Assert.assertEquals((long)1L, (long)slaCompliance);
        } else {
            Assert.assertEquals((long)2L, (long)slaCompliance);
        }
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assert.assertEquals((long)2L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"SLA should not violated by timer", (boolean)slaViolated);
        ksession.signalEvent("slaViolation", null, processInstance.getId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"SLA should not violated by timer", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        ksession.signalEvent("slaViolation:" + userTaskNode.getId(), null, processInstance.getId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedWithExpression() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAExpr.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "3s");
        ProcessInstance processInstance = ksession.startProcess("UserTask", parameters);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedNoTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"SLA should not violated by timer", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)1L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    private int getSLAComplianceForProcessInstance(ProcessInstance processInstance) {
        int slaCompliance = -1;
        if (this.sessionPersistence) {
            ProcessInstanceLog log = this.logService.findProcessInstance(processInstance.getId());
            if (log != null) {
                slaCompliance = log.getSlaCompliance();
            }
        } else {
            slaCompliance = ((org.jbpm.process.instance.ProcessInstance)processInstance).getSlaCompliance();
        }
        return slaCompliance;
    }

    private int getSLAComplianceForNodeInstance(long processInstanceId, org.jbpm.workflow.instance.NodeInstance nodeInstance, int logType) {
        int slaCompliance = -1;
        if (this.sessionPersistence) {
            List logs = this.logService.findNodeInstances(processInstanceId);
            if (logs != null) {
                for (NodeInstanceLog log : logs) {
                    if (log.getType() != logType || !log.getNodeInstanceId().equals(String.valueOf(nodeInstance.getId()))) continue;
                    slaCompliance = log.getSlaCompliance();
                    break;
                }
            }
        } else {
            slaCompliance = nodeInstance.getSlaCompliance();
        }
        return slaCompliance;
    }
}

