/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.bpmn2.concurrency.MultipleProcessesPerThreadTest;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmarshallingOverdueTimersTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(MultipleProcessesPerThreadTest.class);
    private HashMap<String, Object> context;
    private static long seconds = 2L;
    private static String timeUnit = "s";
    private static String bpmn2FileName = "BPMN2-TimerInterrupted.bpmn2";
    private static boolean debug = true;

    @Before
    public void setup() {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    private static KieBase loadKnowledgeBase(String bpmn2FileName) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)bpmn2FileName, UnmarshallingOverdueTimersTest.class), ResourceType.BPMN2);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private KieSession createStatefulKnowledgeSession(KieBase kbase) {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    private static long knowledgeSessionDispose(KieSession ksession) {
        long ksessionId = ksession.getIdentifier();
        logger.debug("disposing of ksesssion");
        ksession.dispose();
        return ksessionId;
    }

    private KieSession reloadStatefulKnowledgeSession(String bpmn2FileName, int ksessionId) {
        KieBase kbase = UnmarshallingOverdueTimersTest.loadKnowledgeBase(bpmn2FileName);
        logger.debug("reloading ksession {}", (Object)ksessionId);
        Environment env = null;
        env = PersistenceUtil.createEnvironment(this.context);
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KieBase)kbase, null, (Environment)env);
    }

    @Test(timeout=10000L)
    public void startDisposeAndReloadTimerProcess() throws Exception {
        ProcessInstance processInstance;
        KieSession ksession;
        String shellVar;
        String shellVarVal;
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        if (debug && (shellVarVal = System.getenv(shellVar = "TEST")) != null) {
            debug = false;
        }
        String sessionPropName = "KSESSION_ID";
        String sessionPropVal = System.getenv(sessionPropName);
        String processPropName = "PROCESS_ID";
        String processPropVal = System.getenv(sessionPropName);
        if (sessionPropVal == null || debug) {
            KieBase kbase = UnmarshallingOverdueTimersTest.loadKnowledgeBase(bpmn2FileName);
            ksession = this.createStatefulKnowledgeSession(kbase);
            ksession.addEventListener((ProcessEventListener)countDownListener);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("time", seconds + timeUnit);
            Calendar cal = GregorianCalendar.getInstance();
            processInstance = ksession.startProcess("interruptedTimer", params);
            long processId = processInstance.getId();
            if (debug) {
                processPropVal = Long.toString(processId);
            } else {
                logger.info("export {}={}", (Object)processPropName, (Object)processId);
            }
            KieSessionConfiguration config = ksession.getSessionConfiguration();
            long ksessionId = UnmarshallingOverdueTimersTest.knowledgeSessionDispose(ksession);
            if (debug) {
                sessionPropVal = Long.toString(ksessionId);
            } else {
                logger.info("export {}={}", (Object)sessionPropName, (Object)ksessionId);
            }
            if (!debug) {
                cal.add(13, (int)seconds);
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
                logger.info("Please wait at least {} [{}]", (Object)(seconds + timeUnit), (Object)sdf.format(cal.getTime()));
            }
        }
        if (sessionPropVal != null || debug) {
            int ksessionId = Integer.parseInt(sessionPropVal);
            ksession = this.reloadStatefulKnowledgeSession(bpmn2FileName, ksessionId);
            ksession.addEventListener((ProcessEventListener)countDownListener);
            long processInstanceId = Integer.parseInt(processPropVal);
            logger.debug("! waiting 5 seconds for timer to fire");
            countDownListener.waitTillCompleted();
            processInstance = ksession.getProcessInstance(processInstanceId);
            if (processInstance != null) {
                Assert.assertTrue((String)"Process has not terminated.", (processInstance.getState() == 2 ? 1 : 0) != 0);
            }
        }
    }
}

