/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml.elements;

import org.jbpm.bpmn2.xml.elements.DataAssociationFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DataAssociationFactoryTest {
    private Node node;
    private Node from;
    private Node to;
    private NamedNodeMap attrs;

    @Before
    public void setup() {
        this.node = (Node)Mockito.mock(Node.class);
        this.attrs = (NamedNodeMap)Mockito.mock(NamedNodeMap.class);
        this.from = (Node)Mockito.mock(Node.class);
        this.to = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.from.getTextContent()).thenReturn((Object)".");
        Mockito.when((Object)this.to.getTextContent()).thenReturn((Object)".");
        Mockito.when((Object)this.from.getAttributes()).thenReturn((Object)this.attrs);
        Mockito.when((Object)this.to.getAttributes()).thenReturn((Object)this.attrs);
    }

    @Test
    public void testGetDialect() {
        Assert.assertEquals((Object)"XPath", (Object)DataAssociationFactory.getDialect((Node)this.node, (Node)this.to, (Node)this.from));
        Node attr = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.attrs.getNamedItem("language")).thenReturn((Object)attr);
        Mockito.when((Object)attr.getNodeValue()).thenReturn((Object)"http://www.mvel.org/2.0");
        Assert.assertEquals((Object)"mvel", (Object)DataAssociationFactory.getDialect((Node)this.node, (Node)this.to, (Node)this.from));
        Mockito.when((Object)attr.getNodeValue()).thenReturn((Object)"java");
        Assert.assertEquals((Object)"java", (Object)DataAssociationFactory.getDialect((Node)this.node, (Node)this.to, (Node)this.from));
        Mockito.when((Object)attr.getNodeValue()).thenReturn((Object)"javas");
        Assert.assertEquals((Object)"XPath", (Object)DataAssociationFactory.getDialect((Node)this.node, (Node)this.to, (Node)this.from));
        Mockito.when((Object)attr.getNodeValue()).thenReturn((Object)"javascript");
        Assert.assertEquals((Object)"JavaScript", (Object)DataAssociationFactory.getDialect((Node)this.node, (Node)this.to, (Node)this.from));
    }

    @Test
    public void testGetDialectFromDefinition() {
        Node parentNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.node.getParentNode()).thenReturn((Object)parentNode);
        Mockito.when((Object)this.node.getAttributes()).thenReturn((Object)((NamedNodeMap)Mockito.mock(NamedNodeMap.class)));
        Mockito.when((Object)parentNode.getAttributes()).thenReturn((Object)this.attrs);
        Mockito.when((Object)parentNode.getLocalName()).thenReturn((Object)"Definitions");
        Node attr = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)attr.getNodeValue()).thenReturn((Object)"http://www.mvel.org/2.0");
        Mockito.when((Object)this.attrs.getNamedItem("expressionLanguage")).thenReturn((Object)attr);
        Assert.assertEquals((Object)"XPath", (Object)DataAssociationFactory.getDialect((Node)this.node, (Node)this.from, (Node)this.to));
        System.setProperty("org.kie.jbpm.bpmn2.useDefinitionLanguage", "true");
        try {
            Assert.assertEquals((Object)"mvel", (Object)DataAssociationFactory.getDialect((Node)this.node, (Node)this.from, (Node)this.to));
        }
        finally {
            System.clearProperty("org.kie.jbpm.bpmn2.useDefinitionLanguage");
        }
    }
}

