/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.drools.core.event.DefaultProcessEventListener;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.DataStore;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@RunWith(value=Parameterized.class)
public class DataTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(DataTest.class);
    private StatefulKnowledgeSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public DataTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        DataTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testImport() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-Import.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Import");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataObject() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataObject.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataStore() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataStore.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation");
        Definitions def = (Definitions)processInstance.getProcess().getMetaData().get("Definitions");
        Assert.assertNotNull((Object)def.getDataStores());
        Assert.assertTrue((def.getDataStores().size() == 1 ? 1 : 0) != 0);
        DataStore dataStore = (DataStore)def.getDataStores().get(0);
        Assert.assertEquals((Object)"employee", (Object)dataStore.getId());
        Assert.assertEquals((Object)"employeeStore", (Object)dataStore.getName());
        Assert.assertEquals((Object)String.class.getCanonicalName(), (Object)((ObjectDataType)dataStore.getType()).getClassName());
    }

    @Test
    public void testAssociation() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-Association.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation");
        List associations = (List)processInstance.getProcess().getMetaData().get("BPMN.Associations");
        Assert.assertNotNull((Object)associations);
        Assert.assertTrue((associations.size() == 1 ? 1 : 0) != 0);
        Association assoc = (Association)associations.get(0);
        Assert.assertEquals((Object)"_1234", (Object)assoc.getId());
        Assert.assertEquals((Object)"_1", (Object)assoc.getSourceRef());
        Assert.assertEquals((Object)"_2", (Object)assoc.getTargetRef());
    }

    @Test
    public void testEvaluationProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEvaluationProcess2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEvaluationProcess3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess3.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john2");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testXpathExpression() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-XpathExpression.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<instanceMetadata><user approved=\"false\" /></instanceMetadata>".getBytes()));
        HashMap<String, Document> params = new HashMap<String, Document>();
        params.put("instanceMetadata", document);
        ProcessInstance processInstance = this.ksession.startProcess("XPathProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataInputAssociations() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello world", (Object)workItem.getParameter("coId"));
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataInputAssociationsWithStringObject() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-string-object.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceMetadata", "hello");
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataInputAssociationsWithPojoPartial() throws Exception {
        this.internalTestDataInputAssociationWithPojo("BPMN2-DataInputAssociations-Pojo.bpmn2");
    }

    @Test
    public void testDataInputAssociationsWithPojoWithoutSource() throws Exception {
        this.internalTestDataInputAssociationWithPojo("BPMN2-DataInputAssociationsWithoutSource.bpmn2");
    }

    @Test
    public void testDataInputAssociationsWithPojoComplete() throws Exception {
        this.internalTestDataInputAssociationWithPojo("BPMN2-DataInputAssociations-Pojo-Complete.bpmn2");
    }

    private void internalTestDataInputAssociationWithPojo(String bpmnFile) throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper(bpmnFile);
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"Sevilla", (Object)workItem.getParameter("coId"));
            }
        });
        this.ksession.startProcess("process", Collections.singletonMap("instanceMetadata", new Person("Javierito", new Address("Sevilla", "Spain"))));
    }

    @Test
    public void testDataInputAssociationsWithPojoNull() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-Pojo-Complete.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertNull((Object)workItem.getParameter("coId"));
            }
        });
        this.ksession.startProcess("process", Collections.singletonMap("instanceMetadata", new Person("Javierito", null)));
    }

    @Test
    @Ignore
    public void testDataInputAssociationsWithLazyLoading() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-lazy-creating.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Object coIdParamObj = workItem.getParameter("coId");
                Assert.assertEquals((Object)"mydoc", (Object)((Element)coIdParamObj).getNodeName());
                Assert.assertEquals((Object)"mynode", (Object)((Element)workItem.getParameter("coId")).getFirstChild().getNodeName());
                Assert.assertEquals((Object)"user", (Object)((Element)workItem.getParameter("coId")).getFirstChild().getFirstChild().getNodeName());
                Assert.assertEquals((Object)"hello world", (Object)((Element)workItem.getParameter("coId")).getFirstChild().getFirstChild().getAttributes().getNamedItem("hello").getNodeValue());
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataInputAssociationsWithString() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-string.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    @Test
    public void testDataInputAssociationsWithStringWithoutQuotes() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-string-no-quotes.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    @Test
    public void testDataInputAssociationsWithXMLLiteral() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-xml-literal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"id", (Object)((Node)workItem.getParameter("coId")).getNodeName());
                Assert.assertEquals((Object)"some text", (Object)((Node)workItem.getParameter("coId")).getFirstChild().getTextContent());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    @Test
    @Ignore
    public void testDataInputAssociationsWithTwoAssigns() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-two-assigns.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"foo", (Object)((Element)workItem.getParameter("Comment")).getNodeName());
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataOutputAssociationsforHumanTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-HumanTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                DocumentBuilder builder;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                HashMap<String, Element> results = new HashMap<String, Element>();
                Document processMetadaDoc = builder.newDocument();
                Element processMetadata = processMetadaDoc.createElement("previoustasksowner");
                processMetadaDoc.appendChild(processMetadata);
                processMetadata.setAttribute("primaryname", "my_result");
                results.put("output", processMetadata);
                mgr.completeWorkItem(workItem.getId(), results);
            }
        });
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataOutputAssociations() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
                    HashMap<String, Node> params = new HashMap<String, Node>();
                    params.put("output", document.getFirstChild());
                    mgr.completeWorkItem(workItem.getId(), params);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    @Test
    public void testDataOutputAssociationsWithPojo() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-Pojo.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)DataTest.this.ksession.getProcessInstance(workItem.getProcessInstanceId());
                Person person = (Person)processInstance.getVariable("instanceMetadata");
                Assert.assertNotNull((Object)person);
                Assert.assertEquals((Object)"Napoleon", (Object)person.getName());
                Assert.assertEquals((Object)"Paris", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"France", (Object)person.getAddress().getCountry());
                mgr.completeWorkItem(workItem.getId(), Collections.singletonMap("output", new Person("Javierito", new Address("Sevilla", "Spain"))));
                person = (Person)processInstance.getVariable("instanceMetadata");
                Assert.assertEquals((Object)"Napoleon", (Object)person.getName());
                Assert.assertEquals((Object)"Sevilla", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"Spain", (Object)person.getAddress().getCountry());
            }
        });
        this.ksession.startProcess("process", Collections.singletonMap("instanceMetadata", new Person("Napoleon", new Address("Paris", "France"))));
    }

    @Test
    public void testDataInputAssociationsStunnerWithPojo() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociationStunner.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)DataTest.this.ksession.getProcessInstance(workItem.getProcessInstanceId());
                Person person = (Person)processInstance.getVariable("instanceMetadata");
                Assert.assertNotNull((Object)person);
                Assert.assertEquals((Object)"Napoleon", (Object)person.getName());
                Assert.assertEquals((Object)"Paris", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"France", (Object)person.getAddress().getCountry());
                mgr.completeWorkItem(workItem.getId(), Collections.emptyMap());
                Address address = (Address)workItem.getParameter("output");
                Assert.assertEquals((Object)"Paris", (Object)address.getCity());
                Assert.assertEquals((Object)"France", (Object)address.getCountry());
            }
        });
        this.ksession.startProcess("process", Collections.singletonMap("instanceMetadata", new Person("Napoleon", new Address("Paris", "France"))));
    }

    @Test
    public void testDataOutputAssociationsStunnerWithPojo() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociationStunner.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        CounterProcessEventListener listener = new CounterProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)DataTest.this.ksession.getProcessInstance(workItem.getProcessInstanceId());
                Person person = (Person)processInstance.getVariable("instanceMetadata");
                Assert.assertNotNull((Object)person);
                Assert.assertEquals((Object)"Napoleon", (Object)person.getName());
                Assert.assertEquals((Object)"Paris", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"France", (Object)person.getAddress().getCountry());
                mgr.completeWorkItem(workItem.getId(), Collections.singletonMap("output", new Address("Sevilla", "Spain")));
                person = (Person)processInstance.getVariable("instanceMetadata");
                Assert.assertEquals((Object)"Napoleon", (Object)person.getName());
                Assert.assertEquals((Object)"Sevilla", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"Spain", (Object)person.getAddress().getCountry());
            }
        });
        this.ksession.startProcess("process", Collections.singletonMap("instanceMetadata", new Person("Napoleon", new Address("Paris", "France"))));
        Assert.assertEquals((long)2L, (long)listener.getCounter());
    }

    @Test
    public void testDataOutputAssociationsWithPojoEmptyFrom() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-Pojo-EmptyFrom.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)DataTest.this.ksession.getProcessInstance(workItem.getProcessInstanceId());
                Person person = (Person)processInstance.getVariable("instanceMetadata");
                Assert.assertNotNull((Object)person);
                Assert.assertEquals((Object)"Napoleon", (Object)person.getName());
                Assert.assertEquals((Object)"Paris", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"France", (Object)person.getAddress().getCountry());
                mgr.completeWorkItem(workItem.getId(), Collections.singletonMap("instanceAddress", new Address("Sevilla", "Spain")));
                person = (Person)processInstance.getVariable("instanceMetadata");
                Assert.assertEquals((Object)"Napoleon", (Object)person.getName());
                Assert.assertEquals((Object)"Sevilla", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"Spain", (Object)person.getAddress().getCountry());
            }
        });
        this.ksession.startProcess("process", Collections.singletonMap("instanceMetadata", new Person("Napoleon", new Address("Paris", "France"))));
    }

    @Test
    public void testDataOutputAssociationsWithPojoList() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-PojoList.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        CounterProcessEventListener listener = new CounterProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)DataTest.this.ksession.getProcessInstance(workItem.getProcessInstanceId());
                List persons = (List)processInstance.getVariable("instanceMetadata");
                Assert.assertNotNull((Object)persons);
                Person person = (Person)persons.get(0);
                Assert.assertEquals((Object)"Javierito", (Object)person.getName());
                Assert.assertEquals((Object)"Paris", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"France", (Object)person.getAddress().getCountry());
                mgr.completeWorkItem(workItem.getId(), Collections.singletonMap("output", Arrays.asList(new Person("Javierito", new Address("Paris", "France")), new Person("Napoleon", new Address("Sevilla", "Spain")))));
                persons = (List)processInstance.getVariable("instanceMetadata");
                Assert.assertNotNull((Object)persons);
                person = (Person)persons.get(0);
                Assert.assertEquals((Object)"Javierito", (Object)person.getName());
                Assert.assertEquals((Object)"Sevilla", (Object)person.getAddress().getCity());
                Assert.assertEquals((Object)"Spain", (Object)person.getAddress().getCountry());
            }
        });
        this.ksession.startProcess("process", Collections.singletonMap("instanceMetadata", Arrays.asList(new Person("Javierito", new Address("Paris", "France")), new Person("Napoleon", new Address("Madrid", "Spain")))));
        Assert.assertEquals((long)2L, (long)listener.getCounter());
    }

    @Test
    public void testDataOutputAssociationsWithPojoMap() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-Map.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)DataTest.this.ksession.getProcessInstance(workItem.getProcessInstanceId());
                Map person = (Map)processInstance.getVariable("instanceMetadata");
                Assert.assertNotNull((Object)person);
                Assert.assertEquals((Object)"Javierito", person.get("name"));
                Address address = (Address)person.get("address");
                Assert.assertEquals((Object)"Paris", (Object)address.getCity());
                Assert.assertEquals((Object)"France", (Object)address.getCountry());
                mgr.completeWorkItem(workItem.getId(), Collections.singletonMap("output", Arrays.asList(new Person("Javierito", new Address("Paris", "France")), new Person("Napoleon", new Address("Sevilla", "Spain")))));
                person = (Map)processInstance.getVariable("instanceMetadata");
                Assert.assertEquals((Object)"Javierito", person.get("name"));
                address = (Address)person.get("address");
                Assert.assertEquals((Object)"Sevilla", (Object)address.getCity());
                Assert.assertEquals((Object)"Spain", (Object)address.getCountry());
            }
        });
        HashMap<String, Object> person = new HashMap<String, Object>();
        person.put("name", "Javierito");
        person.put("address", new Address("Paris", "France"));
        this.ksession.startProcess("process", Collections.singletonMap("instanceMetadata", person));
    }

    @Test
    public void testDataOutputAssociationsXmlNode() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-xml-node.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
                    HashMap<String, Node> params = new HashMap<String, Node>();
                    params.put("output", document.getFirstChild());
                    mgr.completeWorkItem(workItem.getId(), params);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    public static class Address
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String city;
        private String country;

        public Address(String city, String country) {
            this.city = city;
            this.country = country;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public int hashCode() {
            return Objects.hash(this.city, this.country);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Address)) {
                return false;
            }
            Address other = (Address)obj;
            return Objects.equals(this.city, other.city) && Objects.equals(this.country, other.country);
        }

        public String toString() {
            return "Address [city=" + this.city + ", country=" + this.country + "]";
        }
    }

    public static class Person
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private Address address;

        public Person(String name, Address address) {
            this.name = name;
            this.address = address;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public Address getAddress() {
            return this.address;
        }

        public int hashCode() {
            return Objects.hash(this.address, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Person)) {
                return false;
            }
            Person other = (Person)obj;
            return Objects.equals(this.address, other.address) && Objects.equals(this.name, other.name);
        }

        public String toString() {
            return "Person [name=" + this.name + ", address=" + this.address + "]";
        }
    }

    private class CounterProcessEventListener
    extends DefaultProcessEventListener {
        private int counter = 0;

        private CounterProcessEventListener() {
        }

        protected void incCounter() {
            ++this.counter;
        }

        public int getCounter() {
            return this.counter;
        }

        public void afterVariableChanged(ProcessVariableChangedEvent event) {
            Assert.assertNotEquals((Object)event.getOldValue(), (Object)event.getNewValue());
            if (event.getOldValue() != null) {
                this.incCounter();
            }
        }

        public void beforeVariableChanged(ProcessVariableChangedEvent event) {
            Assert.assertNotEquals((Object)event.getOldValue(), (Object)event.getNewValue());
            if (event.getOldValue() != null) {
                this.incCounter();
            }
        }
    }
}

