/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.command.UpdateTimerCommand;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class SLAComplianceTest
extends JbpmBpmn2TestCase {
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public SLAComplianceTest(boolean persistence) throws Exception {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        SLAComplianceTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.abortProcessInstances(this.ksession);
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testSLAonProcessViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessUpdated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Date firstSlaDueDate = this.getSLADueDateForProcessInstance(processInstance.getId(), (WorkflowProcessInstance)processInstance);
        Collection timers = this.getTimerManager((KieSession)ksession).getTimers();
        Assertions.assertThat((int)timers.size()).isEqualTo(1);
        ksession.execute((Command)new UpdateTimerCommand(processInstance.getId(), ((TimerInstance)timers.iterator().next()).getId(), 7L));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"Process SLA was violated while it is not expected after update SLA", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)1L, (long)slaCompliance);
        slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Process SLA was not violated while it is expected after 10s", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.abortProcessInstance(processInstance.getId());
        Date updatedSlaDueDate = this.getSLADueDateForProcessInstance(processInstance.getId(), (WorkflowProcessInstance)processInstance);
        Assert.assertTrue((String)String.format("updatedSlaDueDate '%tc' should be around 4-5 seconds after firstSlaDueDate '%tc'", updatedSlaDueDate, firstSlaDueDate), (boolean)updatedSlaDueDate.after(firstSlaDueDate));
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessMet() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)2L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        Collection active = ((org.kie.api.runtime.process.WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskMet() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((org.kie.api.runtime.process.WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        if (this.sessionPersistence) {
            Assert.assertEquals((long)1L, (long)slaCompliance);
        } else {
            Assert.assertEquals((long)2L, (long)slaCompliance);
        }
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assert.assertEquals((long)2L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskUpdated() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        TimerIdListener listener = new TimerIdListener(latch);
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Collection active = ((org.kie.api.runtime.process.WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        Date firstSlaDueDate = this.getSLADueDateForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        long timerId = listener.getTimerId();
        Assert.assertNotEquals((long)-1L, (long)timerId);
        ksession.execute((Command)new UpdateTimerCommand(processInstance.getId(), timerId, 7L));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"SLA should not be violated by timer", (boolean)slaViolated);
        slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA should be violated by timer", (boolean)slaViolated);
        ksession.abortProcessInstance(processInstance.getId());
        Date updatedSlaDueDate = this.getSLADueDateForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 2);
        Assert.assertTrue((String)String.format("updatedSlaDueDate '%tc' should be around 4 seconds after firstSlaDueDate '%tc'", updatedSlaDueDate, firstSlaDueDate), (boolean)updatedSlaDueDate.after(firstSlaDueDate));
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"SLA should not violated by timer", (boolean)slaViolated);
        ksession.signalEvent("slaViolation", null, processInstance.getId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonUserTaskViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"SLA should not violated by timer", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((org.kie.api.runtime.process.WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance userTaskNode = (NodeInstance)active.iterator().next();
        ksession.signalEvent("slaViolation:" + userTaskNode.getId(), null, processInstance.getId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 0);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)userTaskNode, 1);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedWithExpression() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLAExpr.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "3s");
        ProcessInstance processInstance = ksession.startProcess("UserTask", parameters);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA was not violated while it is expected", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonProcessViolatedNoTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSLA.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getEnvironment().set("SLATimerMode", (Object)"false");
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"SLA should not violated by timer", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)1L, (long)slaCompliance);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonCatchEventViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignalWithSLAOnEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"SLA should be violated by timer", (boolean)slaViolated);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((org.kie.api.runtime.process.WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance eventNode = (NodeInstance)active.iterator().next();
        ksession.signalEvent("MyMessage", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)eventNode, 0);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)eventNode, 1);
        Assert.assertEquals((long)3L, (long)slaCompliance);
        ksession.dispose();
    }

    @Test
    public void testSLAonCatchEventNotViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignalWithSLAOnEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Collection active = ((org.kie.api.runtime.process.WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)active.size());
        NodeInstance eventNode = (NodeInstance)active.iterator().next();
        ksession.signalEvent("MyMessage", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assert.assertEquals((long)0L, (long)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getId(), (org.jbpm.workflow.instance.NodeInstance)eventNode, 1);
        Assert.assertEquals((long)2L, (long)slaCompliance);
        boolean slaViolated = latch.await(3L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"SLA should not violated by timer", (boolean)slaViolated);
        ksession.dispose();
    }

    private int getSLAComplianceForProcessInstance(ProcessInstance processInstance) {
        int slaCompliance = -1;
        if (this.sessionPersistence) {
            ProcessInstanceLog log = this.logService.findProcessInstance(processInstance.getId());
            if (log != null) {
                slaCompliance = log.getSlaCompliance();
            }
        } else {
            slaCompliance = ((org.jbpm.process.instance.ProcessInstance)processInstance).getSlaCompliance();
        }
        return slaCompliance;
    }

    private int getSLAComplianceForNodeInstance(long processInstanceId, org.jbpm.workflow.instance.NodeInstance nodeInstance, int logType) {
        int slaCompliance = -1;
        if (this.sessionPersistence) {
            List logs = this.logService.findNodeInstances(processInstanceId);
            if (logs != null) {
                for (NodeInstanceLog log : logs) {
                    if (log.getType() != logType || !log.getNodeInstanceId().equals(String.valueOf(nodeInstance.getId()))) continue;
                    slaCompliance = log.getSlaCompliance();
                    break;
                }
            }
        } else {
            slaCompliance = nodeInstance.getSlaCompliance();
        }
        return slaCompliance;
    }

    private Date getSLADueDateForNodeInstance(long processInstanceId, org.jbpm.workflow.instance.NodeInstance nodeInstance, int logType) {
        if (!this.sessionPersistence) {
            return nodeInstance.getSlaDueDate();
        }
        List logs = this.logService.findNodeInstances(processInstanceId);
        if (logs == null) {
            throw new RuntimeException("NodeInstanceLog not found");
        }
        for (NodeInstanceLog log : logs) {
            if (log.getType() != logType || !log.getNodeInstanceId().equals(String.valueOf(nodeInstance.getId()))) continue;
            return log.getSlaDueDate();
        }
        throw new RuntimeException("NodeInstanceLog not found for id " + nodeInstance.getId() + " and type " + logType);
    }

    private Date getSLADueDateForProcessInstance(long processInstanceId, WorkflowProcessInstance processInstance) {
        if (!this.sessionPersistence) {
            return processInstance.getSlaDueDate();
        }
        List logs = this.logService.findProcessInstances();
        if (logs == null) {
            throw new RuntimeException("ProcessInstanceLog not found");
        }
        for (ProcessInstanceLog log : logs) {
            if (log.getId() != processInstanceId) continue;
            return log.getSlaDueDate();
        }
        throw new RuntimeException("ProcessInstanceLog not found for id " + processInstanceId);
    }

    private TimerManager getTimerManager(KieSession ksession) {
        KieSession internal = ksession;
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            internal = ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession();
        }
        return ((InternalProcessRuntime)((StatefulKnowledgeSessionImpl)internal).getProcessRuntime()).getTimerManager();
    }

    class TimerIdListener
    extends DefaultProcessEventListener {
        private long timerId = -1L;
        private CountDownLatch latch;

        public TimerIdListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            if (event.getNodeInstance() instanceof HumanTaskNodeInstance) {
                this.timerId = ((HumanTaskNodeInstance)event.getNodeInstance()).getSlaTimerId();
            }
        }

        public long getTimerId() {
            return this.timerId;
        }

        public void afterSLAViolated(SLAViolatedEvent event) {
            this.latch.countDown();
        }
    }
}

