/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.util.IoUtils;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.handler.SignallingTaskHandlerDecorator;
import org.jbpm.bpmn2.objects.ExceptionService;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@RunWith(value=Parameterized.class)
public class StandaloneBPMNProcessTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneBPMNProcessTest.class);
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false, false}, {true, false}, {true, true}};
        return Arrays.asList(data);
    }

    public StandaloneBPMNProcessTest(boolean persistence, boolean locking) {
        super(persistence, locking);
    }

    @BeforeClass
    public static void setup() throws Exception {
        StandaloneBPMNProcessTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.abortProcessInstances(this.ksession);
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testMinimalProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testMinimalProcessWithGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testMinimalProcessWithDIGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithDIGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testCompositeProcessWithDIGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CompositeProcessWithDIGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Composite");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testScriptTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("ScriptTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testDataObject() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataObject.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEvaluationProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEvaluationProcess2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.evaluation", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEvaluationProcess3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess3.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john2");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testUserTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        String varId = "s";
        String varValue = "initialValue";
        params.put(varId, varValue);
        ProcessInstance processInstance = this.ksession.startProcess("UserTask", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        if (this.isPersistence()) {
            List varLogs = this.logService.findVariableInstancesByName(varId, true);
            Assertions.assertThat((List)varLogs).isNotEmpty();
            for (VariableInstanceLog varLog : varLogs) {
                Assertions.assertThat((String)varLog.getVariableId()).isEqualTo(varId);
            }
            varLogs = this.logService.findVariableInstancesByNameAndValue(varId, varValue, true);
            Assertions.assertThat((List)varLogs).isNotEmpty();
            for (VariableInstanceLog varLog : varLogs) {
                Assertions.assertThat((String)varLog.getVariableId()).isEqualTo(varId);
                Assertions.assertThat((String)varLog.getValue()).isEqualTo(varValue);
            }
        }
        this.ksession = this.restoreSession(this.ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testLane() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-Lane.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "mary");
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("SwimlaneActorId")).isEqualTo((Object)"mary");
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testExclusiveSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testExclusiveSplitDefault() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitDefault.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testInclusiveSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testInclusiveSplitDefault() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitDefault.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    @Ignore
    public void testExclusiveSplitXPath() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<myDocument><chapter1>BlaBla</chapter1><chapter2>MoreBlaBla</chapter2></myDocument>".getBytes()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("x", document);
        params.put("y", "SomeString");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEventBasedSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
        processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testEventBasedSplitBefore() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
    }

    @Test
    public void testEventBasedSplitAfter() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
    }

    @Test(timeout=10000L)
    public void testEventBasedSplit2() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    @Ignore(value="process does not complete")
    public void testEventBasedSplit3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit3.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        Person jack = new Person();
        jack.setName("Jack");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
        processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.insert((Object)jack);
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testEventBasedSplit4() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit4.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = this.ksession.startProcess("com.sample.test");
        this.ksession.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testEventBasedSplit5() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit5.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        processInstance = this.ksession.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    @Test
    public void testCallActivity() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                logger.error("{}", (Object)error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = this.createKnowledgeSession((KieBase)kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
        Assertions.assertThat((Object)((WorkflowProcessInstance)processInstance).getVariable("y")).isEqualTo((Object)"new value");
    }

    @Test
    public void testSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("SubProcess");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEvent() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventInterrupting() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    @Ignore(value="Process does not complete.")
    public void testAdHocSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNull();
        this.ksession = this.restoreSession(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.fireAllRules();
        this.ksession.signalEvent("Hello2", null, processInstance.getId());
        workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.ksession = this.restoreSession(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    @Ignore(value="Process does not complete.")
    public void testAdHocSubProcessAutoComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcessAutoComplete.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNull();
        this.ksession = this.restoreSession(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        ((ObjectAssert)Assertions.assertThat((Object)workItem).isNotNull()).withFailMessage("WorkItem should not be null.", new Object[0]);
        this.ksession = this.restoreSession(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testIntermediateCatchEventSignal() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testIntermediateCatchEventMessage() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventMessage.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    @Ignore(value="process does not complete")
    public void testIntermediateCatchEventCondition() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventCondition.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession);
        Person person = new Person();
        person.setName("Jack");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testErrorEndEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorEndEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
        Assertions.assertThat((Object)processInstance.getVariable("s")).isEqualTo((Object)"Hello john!");
    }

    @Test
    public void testSendTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SendTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("SendTask", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testReceiveTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ReceiveTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ReceiveTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.ksession = this.restoreSession(this.ksession);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    @Ignore(value="bpmn does not compile")
    public void testConditionalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ConditionalStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Person person = new Person();
        person.setName("jack");
        this.ksession.insert((Object)person);
        this.ksession.fireAllRules();
        person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.ksession.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testTimerStart() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
    }

    @Test
    public void testSignalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("MySignal", (Object)"NewValue");
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testSignalEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalEndEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance pi = this.ksession.startProcess("SignalEndEvent", params);
    }

    @Test
    public void testMessageStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("Message-HelloMessage", (Object)"NewValue");
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testMessageEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageEndEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("MessageEndEvent", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testMessageIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("MessageIntermediateEvent", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testSignalIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("SignalIntermediateEvent", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testNoneIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventNone.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("NoneIntermediateEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testErrorSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-ErrorSignalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestErrorSignallingExceptionServiceTask(this.ksession);
    }

    public static void runTestErrorSignallingExceptionServiceTask(KieSession ksession) throws Exception {
        String eventType = "Error-code";
        SignallingTaskHandlerDecorator signallingTaskWrapper = new SignallingTaskHandlerDecorator(ServiceTaskHandler.class, eventType);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)signallingTaskWrapper);
        Object[] caughtEventObjectHolder = new Object[]{null};
        ExceptionService.setCaughtEventObjectHolder(caughtEventObjectHolder);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        String input = "this is my service input";
        params.put("serviceInputItem", input);
        ProcessInstance processInstance = ksession.startProcess("ServiceProcess", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        Assertions.assertThat((caughtEventObjectHolder[0] != null && caughtEventObjectHolder[0] instanceof WorkItem ? 1 : 0) != 0).isTrue().withFailMessage("Event was not passed to Event Subprocess.", new Object[0]);
        workItem = (WorkItem)caughtEventObjectHolder[0];
        Object throwObj = workItem.getParameter(ExceptionService.exceptionParameterName);
        Assertions.assertThat((boolean)(throwObj instanceof Throwable)).isTrue().withFailMessage("WorkItem doesn't contain Throwable.", new Object[0]);
        Assertions.assertThat((boolean)((Throwable)throwObj).getMessage().endsWith(input)).isTrue().withFailMessage("Exception message does not match service input.", new Object[0]);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assertions.assertThat((processInstance == null || processInstance.getState() == 3 ? 1 : 0) != 0).isTrue().withFailMessage("Process instance has not been aborted.", new Object[0]);
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestSignallingExceptionServiceTask(this.ksession);
    }

    @Test
    public void testXXEProcessVulnerability() throws Exception {
        Resource processResource = ResourceFactory.newClassPathResource((String)"xxe-protection/BPMN2-XXE-Process.bpmn2");
        File dtdFile = new File("src/test/resources/xxe-protection/external.dtd");
        Assertions.assertThat((File)dtdFile).exists();
        String dtdContent = IoUtils.readFileAsString((File)dtdFile);
        dtdContent = dtdContent.replaceAll("@@PATH@@", dtdFile.getParentFile().getAbsolutePath());
        IoUtils.write((File)dtdFile, (byte[])dtdContent.getBytes("UTF-8"));
        byte[] data = IoUtils.readBytesFromInputStream((InputStream)processResource.getInputStream());
        String processAsString = new String(data, "UTF-8");
        File testFiles = new File("src/test/resources/xxe-protection");
        Assertions.assertThat((File)testFiles).exists();
        String path = testFiles.getAbsolutePath();
        processAsString = processAsString.replaceAll("@@PATH@@", path);
        Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(processAsString));
        resource.setSourcePath(processResource.getSourcePath());
        resource.setTargetPath(processResource.getTargetPath());
        KieBase kbase = this.createKnowledgeBaseFromResources(resource);
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("async-examples.bp1");
        String var1 = this.getProcessVarValue(processInstance, "testScript1");
        String var2 = this.getProcessVarValue(processInstance, "testScript2");
        Assertions.assertThat((String)var1).isNull();
        Assertions.assertThat((String)var2).isNull();
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testVariableRefInIntermediateThrowEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-WorkingMessageModel.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("messageContent", "some text");
        ProcessInstance processInstance = this.ksession.startProcess("workingMessageModel", parameters);
        Assertions.assertThat((Object)processInstance).isNotNull();
    }

    public static void runTestSignallingExceptionServiceTask(KieSession ksession) throws Exception {
        String eventType = "exception-signal";
        SignallingTaskHandlerDecorator signallingTaskWrapper = new SignallingTaskHandlerDecorator(ServiceTaskHandler.class, eventType);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)signallingTaskWrapper);
        Object[] caughtEventObjectHolder = new Object[]{null};
        ExceptionService.setCaughtEventObjectHolder(caughtEventObjectHolder);
        HashMap<String, String> params = new HashMap<String, String>();
        String input = "this is my service input";
        params.put("serviceInputItem", input);
        ProcessInstance processInstance = ksession.startProcess("ServiceProcess", params);
        Assertions.assertThat((caughtEventObjectHolder[0] != null && caughtEventObjectHolder[0] instanceof WorkItem ? 1 : 0) != 0).isTrue().withFailMessage("Event was not passed to Event Subprocess.", new Object[0]);
        WorkItem workItem = (WorkItem)caughtEventObjectHolder[0];
        Object throwObj = workItem.getParameter(ExceptionService.exceptionParameterName);
        Assertions.assertThat((boolean)(throwObj instanceof Throwable)).isTrue().withFailMessage("WorkItem doesn't contain Throwable.", new Object[0]);
        Assertions.assertThat((boolean)((Throwable)throwObj).getMessage().endsWith(input)).isTrue().withFailMessage("Exception message does not match service input.", new Object[0]);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1).withFailMessage("Process instance is not active.", new Object[0]);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        if (processInstance != null) {
            Assertions.assertThat((int)processInstance.getState()).isEqualTo(2).withFailMessage("Process instance is not completed.", new Object[0]);
        }
    }
}

