/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProcessFactoryTest
extends JbpmBpmn2TestCase {
    public ProcessFactoryTest() {
        super(false);
    }

    @Test
    public void testProcessFactory() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().actionNode(2L).name("Action").action("java", "System.out.println(\"Action\");").done().endNode(3L).name("End").done().connection(1L, 2L).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.startProcess("org.jbpm.process");
        ksession.dispose();
    }

    @Test
    public void testCompositeNode() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().compositeNode(2L).name("SubProcess").startNode(1L).name("SubProcess Start").done().actionNode(2L).name("SubProcess Action").action("java", "System.out.println(\"SubProcess Action\");").done().endNode(3L).name("SubProcess End").terminate(true).done().connection(1L, 2L).connection(2L, 3L).done().endNode(3L).name("End").done().connection(1L, 2L).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Assert.assertEquals((Object)"SubProcess", (Object)process.getNode(2L).getName());
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        Assert.assertEquals((long)2L, (long)pi.getState());
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testBoundaryTimerTimeCycle() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryTimerEvent", 1);
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().humanTaskNode(2L).name("Task").actorId("john").taskName("MyTask").done().endNode(3L).name("End1").terminate(false).done().boundaryEventNode(4L).name("BoundaryTimerEvent").attachedTo(2L).timeCycle("1s###5s").cancelActivity(false).done().endNode(5L).name("End2").terminate(false).done().connection(1L, 2L).connection(2L, 3L).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)testHandler);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        this.assertProcessInstanceActive(pi);
        countDownListener.waitTillCompleted();
        this.assertNodeTriggered(pi.getId(), "End2");
        this.assertProcessInstanceActive(pi);
        ksession.getWorkItemManager().completeWorkItem(testHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(pi);
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testBoundaryTimerTimeDuration() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryTimerEvent", 1);
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().humanTaskNode(2L).name("Task").actorId("john").taskName("MyTask").done().endNode(3L).name("End1").terminate(false).done().boundaryEventNode(4L).name("BoundaryTimerEvent").attachedTo(2L).timeDuration("1s").cancelActivity(false).done().endNode(5L).name("End2").terminate(false).done().connection(1L, 2L).connection(2L, 3L).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)testHandler);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        this.assertProcessInstanceActive(pi);
        countDownListener.waitTillCompleted();
        this.assertNodeTriggered(pi.getId(), "End2");
        this.assertProcessInstanceActive(pi);
        ksession.getWorkItemManager().completeWorkItem(testHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(pi);
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testAdHocSimple() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.dynamic(true).name("Event Process").version("1").packageName("org.jbpm");
        RuleFlowProcess process = factory.validate().getProcess();
        Assert.assertNotNull((Object)process);
        Assert.assertTrue((boolean)process.isDynamic());
    }

    @Test(timeout=10000L)
    public void testSignalEvent() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("Event Process").version("1").packageName("org.jbpm").variable("eventData", (DataType)new StringDataType()).startNode(1L).name("Start").done().eventNode(2L).name("Event1").eventType("testEvent").variableName("eventData").done().actionNode(3L).name("simpleActionNode").action("java", "System.out.println(\"test event action\");").done().endNode(4L).name("End").done().connection(1L, 2L).connection(2L, 3L).connection(3L, 4L);
        RuleFlowProcess process = factory.validate().getProcess();
        Assert.assertNotNull((Object)process);
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        Assert.assertNotNull((Object)pi);
        Assert.assertEquals((long)1L, (long)pi.getState());
        pi.signalEvent("testEvent", null);
        Assert.assertEquals((long)2L, (long)pi.getState());
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testActionNodeIsDroolsAction() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("ActionNodeActionProcess").version("1").startNode(1L).name("Start").done().endNode(3L).name("End").done().actionNode(2L).name("printTextActionNode").action("java", "System.out.println(\"test print\");", true).done().connection(1L, 2L).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Assert.assertNotNull((Object)process);
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        Assert.assertNotNull((Object)pi);
        Assert.assertEquals((long)2L, (long)pi.getState());
        ksession.dispose();
    }
}

