/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn;

import java.util.List;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.cmmn.AbstractCmmnBaseTest;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Process;

public class CaseTest
extends AbstractCmmnBaseTest {
    @Test
    public void testLoadMinimalCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-MinimalCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("loan_application");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"loan_application");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"Loan Application");
    }

    @Test
    public void testLoadMinimalCaseWithRoles() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-MinimalCaseWithRoles.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("loan_application");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"loan_application");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"Loan Application");
        String roles = (String)caseProcess.getMetaData("customCaseRoles");
        Assertions.assertThat((String)roles).isNotNull();
        Assertions.assertThat((String)roles).isEqualTo((Object)"owner,participant,manager");
    }

    @Test
    public void testLoadMinimalCaseHumanTasks() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-HumanTaskCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("loan_application");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"loan_application");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"Loan Application");
        String roles = (String)caseProcess.getMetaData("customCaseRoles");
        Assertions.assertThat((String)roles).isNotNull();
        Assertions.assertThat((String)roles).isEqualTo((Object)"owner,manager");
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(2);
        Assertions.assertThat((Object[])nodes).allSatisfy(n -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)n).isInstanceOf(HumanTaskNode.class);
        });
        HumanTaskNode humanTaskOne = (HumanTaskNode)nodes[0];
        Assertions.assertThat((String)humanTaskOne.getName()).isEqualTo((Object)"Check Application");
        Assertions.assertThat((String)humanTaskOne.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((Object)humanTaskOne.getWork().getParameter("ActorId")).isEqualTo((Object)"owner");
        Assertions.assertThat((Object)humanTaskOne.getWork().getParameter("TaskName")).isEqualTo((Object)"CheckApplication");
        HumanTaskNode humanTaskTwo = (HumanTaskNode)nodes[1];
        Assertions.assertThat((String)humanTaskTwo.getName()).isEqualTo((Object)"Provide Customer Rating");
        Assertions.assertThat((String)humanTaskTwo.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((Object)humanTaskTwo.getWork().getParameter("ActorId")).isEqualTo((Object)"manager");
        Assertions.assertThat((Object)humanTaskTwo.getWork().getParameter("TaskName")).isEqualTo((Object)"ProvideCustomerRating");
    }

    @Test
    public void testLoadMilestoneAndHumanTasksCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-MilestoneAndHumanTasksCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"First case");
        List variables = caseProcess.getVariableScope().getVariables();
        Assertions.assertThat((List)variables).hasSize(1);
        Variable caseFileItem = (Variable)variables.get(0);
        Assertions.assertThat((Object)caseFileItem).isNotNull();
        Assertions.assertThat((String)caseFileItem.getName()).isEqualTo((Object)"caseFile_document");
        Assertions.assertThat((Object)caseFileItem.getType()).isInstanceOf(ObjectDataType.class);
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(3);
        HumanTaskNode humanTaskOne = (HumanTaskNode)nodes[0];
        Assertions.assertThat((String)humanTaskOne.getName()).isEqualTo((Object)"First task");
        Assertions.assertThat((String)humanTaskOne.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((List)humanTaskOne.getInAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"caseFile_document");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getTarget()).isEqualTo((Object)"test");
        Assertions.assertThat((List)humanTaskOne.getOutAssociations()).hasSize(0);
        MilestoneNode humanTaskTwo = (MilestoneNode)nodes[1];
        Assertions.assertThat((String)humanTaskTwo.getName()).isEqualTo((Object)"Milestone");
        Assertions.assertThat((String)humanTaskTwo.getConstraint()).isEqualTo((Object)"org.kie.api.runtime.process.CaseData(data.get(\"shipped\") !=null)");
        DynamicNode stage = (DynamicNode)nodes[2];
        Assertions.assertThat((String)stage.getName()).isEqualTo((Object)"First stage");
        Assertions.assertThat((String)stage.getActivationExpression()).isNull();
        Assertions.assertThat((String)stage.getCompletionExpression()).isNull();
    }

    @Test
    public void testLoadMilestoneAndHumanTasksSentriesCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-HumanTaskMilestoneSentries.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"First case");
        String roles = (String)caseProcess.getMetaData("customCaseRoles");
        Assertions.assertThat((String)roles).isNotNull();
        Assertions.assertThat((String)roles).isEqualTo((Object)"owner,manager");
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(2);
        HumanTaskNode humanTaskOne = (HumanTaskNode)nodes[0];
        Assertions.assertThat((String)humanTaskOne.getName()).isEqualTo((Object)"First task");
        Assertions.assertThat((String)humanTaskOne.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((Object)humanTaskOne.getMetaData("customAutoStart")).isEqualTo((Object)"true");
        Assertions.assertThat((Object)humanTaskOne.getWork().getParameter("ActorId")).isEqualTo((Object)"owner");
        MilestoneNode milestone = (MilestoneNode)nodes[1];
        Assertions.assertThat((String)milestone.getName()).isEqualTo((Object)"All work done");
        Assertions.assertThat((String)milestone.getConstraint()).isEqualTo((Object)"org.kie.api.runtime.process.CaseData(data.get(\"shipped\") !=null)");
        Assertions.assertThat((Object)milestone.getMetaData("customAutoStart")).isEqualTo((Object)"true");
    }

    @Test
    public void testLoadStageAndHumanTasksCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-StageWithHumanTaskCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"First case");
        String roles = (String)caseProcess.getMetaData("customCaseRoles");
        Assertions.assertThat((String)roles).isNotNull();
        Assertions.assertThat((String)roles).isEqualTo((Object)"owner,manager");
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(2);
        HumanTaskNode humanTaskOne = (HumanTaskNode)nodes[0];
        Assertions.assertThat((String)humanTaskOne.getName()).isEqualTo((Object)"First task");
        Assertions.assertThat((String)humanTaskOne.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((Object)humanTaskOne.getMetaData("customAutoStart")).isEqualTo((Object)"true");
        Assertions.assertThat((Object)humanTaskOne.getWork().getParameter("ActorId")).isEqualTo((Object)"owner");
        DynamicNode stage = (DynamicNode)nodes[1];
        Assertions.assertThat((String)stage.getName()).isEqualTo((Object)"First stage");
        Assertions.assertThat((String)stage.getActivationExpression()).isEqualTo((Object)"org.kie.api.runtime.process.CaseData(data.get(\"ordered\") !=null)");
        Assertions.assertThat((String)stage.getCompletionExpression()).isEqualTo((Object)"org.kie.api.runtime.process.CaseData(data.get(\"shipped\") !=null)");
        Object[] stageNodes = stage.getNodes();
        Assertions.assertThat((Object[])stageNodes).hasSize(1);
        HumanTaskNode humanTaskTwo = (HumanTaskNode)stageNodes[0];
        Assertions.assertThat((String)humanTaskTwo.getName()).isEqualTo((Object)"Stage task");
        Assertions.assertThat((String)humanTaskTwo.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((Object)humanTaskTwo.getMetaData("customAutoStart")).isNull();
        Assertions.assertThat((Object)humanTaskTwo.getWork().getParameter("ActorId")).isEqualTo((Object)"manager");
    }

    @Test
    public void testLoadDataInputsAndOutputsHumanTasksCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-DataInputsAndOutputsCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"First case");
        List variables = caseProcess.getVariableScope().getVariables();
        Assertions.assertThat((List)variables).hasSize(2);
        Variable caseFileItem = (Variable)variables.get(0);
        Assertions.assertThat((Object)caseFileItem).isNotNull();
        Assertions.assertThat((String)caseFileItem.getName()).isEqualTo((Object)"caseFile_shipped");
        Assertions.assertThat((Object)caseFileItem.getType()).isInstanceOf(BooleanDataType.class);
        caseFileItem = (Variable)variables.get(1);
        Assertions.assertThat((Object)caseFileItem).isNotNull();
        Assertions.assertThat((String)caseFileItem.getName()).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((Object)caseFileItem.getType()).isInstanceOf(ObjectDataType.class);
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(2);
        HumanTaskNode humanTaskOne = (HumanTaskNode)nodes[0];
        Assertions.assertThat((String)humanTaskOne.getName()).isEqualTo((Object)"First task");
        Assertions.assertThat((String)humanTaskOne.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((List)humanTaskOne.getInAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getTarget()).isEqualTo((Object)"invoice");
        DynamicNode stage = (DynamicNode)nodes[1];
        Assertions.assertThat((String)stage.getName()).isEqualTo((Object)"First stage");
        Assertions.assertThat((String)stage.getActivationExpression()).isEqualTo((Object)"org.kie.api.runtime.process.CaseData(data.get(\"ordered\") !=null)");
        Assertions.assertThat((String)stage.getCompletionExpression()).isEqualTo((Object)"org.kie.api.runtime.process.CaseData(data.get(\"shipped\") !=null)");
        Object[] stageNodes = stage.getNodes();
        Assertions.assertThat((Object[])stageNodes).hasSize(1);
        humanTaskOne = (HumanTaskNode)stageNodes[0];
        Assertions.assertThat((String)humanTaskOne.getName()).isEqualTo((Object)"Stage task");
        Assertions.assertThat((String)humanTaskOne.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((List)humanTaskOne.getInAssociations()).hasSize(2);
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"caseFile_shipped");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getTarget()).isEqualTo((Object)"shipped");
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getInAssociations().get(1)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getInAssociations().get(1)).getSources().get(0))).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getInAssociations().get(1)).getTarget()).isEqualTo((Object)"invoiceApproved");
        Assertions.assertThat((List)humanTaskOne.getOutAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"shippedConfirmed");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getTarget()).isEqualTo((Object)"caseFile_shipped");
    }

    @Test
    public void testLoadDifferentTasksCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-DifferentTaskTypesCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"Case_517ac74c-fba4-4728-bcaf-e9853c864710");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"First case");
        List variables = caseProcess.getVariableScope().getVariables();
        Assertions.assertThat((List)variables).hasSize(1);
        Variable caseFileItem = (Variable)variables.get(0);
        Assertions.assertThat((Object)caseFileItem).isNotNull();
        Assertions.assertThat((String)caseFileItem.getName()).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((Object)caseFileItem.getType()).isInstanceOf(ObjectDataType.class);
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(5);
        HumanTaskNode humanTaskOne = (HumanTaskNode)nodes[0];
        Assertions.assertThat((String)humanTaskOne.getName()).isEqualTo((Object)"First task");
        Assertions.assertThat((String)humanTaskOne.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((List)humanTaskOne.getInAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getTarget()).isEqualTo((Object)"invoice");
        Assertions.assertThat((List)humanTaskOne.getOutAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"approval");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getTarget()).isEqualTo((Object)"caseFile_invoice");
        SubProcessNode processNode = (SubProcessNode)nodes[1];
        Assertions.assertThat((String)processNode.getName()).isEqualTo((Object)"Call subprocess");
        Assertions.assertThat((String)processNode.getProcessId()).isEqualTo((Object)"subprocessId");
        Assertions.assertThat((boolean)processNode.isWaitForCompletion()).isTrue();
        Assertions.assertThat((boolean)processNode.isIndependent()).isFalse();
        Assertions.assertThat((List)processNode.getInAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)processNode.getInAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)processNode.getInAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((String)((DataAssociation)processNode.getInAssociations().get(0)).getTarget()).isEqualTo((Object)"invoiceDoc");
        Assertions.assertThat((List)processNode.getOutAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)processNode.getOutAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)processNode.getOutAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"approved");
        Assertions.assertThat((String)((DataAssociation)processNode.getOutAssociations().get(0)).getTarget()).isEqualTo((Object)"caseFile_invoice");
        humanTaskOne = (HumanTaskNode)nodes[2];
        Assertions.assertThat((String)humanTaskOne.getName()).isEqualTo((Object)"non blocking HT");
        Assertions.assertThat((String)humanTaskOne.getWork().getName()).isEqualTo((Object)"Human Task");
        Assertions.assertThat((List)humanTaskOne.getInAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getInAssociations().get(0)).getTarget()).isEqualTo((Object)"invoice");
        Assertions.assertThat((List)humanTaskOne.getOutAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"approved");
        Assertions.assertThat((String)((DataAssociation)humanTaskOne.getOutAssociations().get(0)).getTarget()).isEqualTo((Object)"caseFile_invoice");
        RuleSetNode decisionTask = (RuleSetNode)nodes[3];
        Assertions.assertThat((String)decisionTask.getLanguage()).isEqualTo((Object)"http://www.jboss.org/drools/rule");
        Assertions.assertThat((String)decisionTask.getName()).isEqualTo((Object)"Make a decision");
        Assertions.assertThat((String)decisionTask.getRuleFlowGroup()).isEqualTo((Object)"decisionName");
        Assertions.assertThat((List)decisionTask.getInAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)decisionTask.getInAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)decisionTask.getInAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((String)((DataAssociation)decisionTask.getInAssociations().get(0)).getTarget()).isEqualTo((Object)"toApprove");
        Assertions.assertThat((List)decisionTask.getOutAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)decisionTask.getOutAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)decisionTask.getOutAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"decided");
        Assertions.assertThat((String)((DataAssociation)decisionTask.getOutAssociations().get(0)).getTarget()).isEqualTo((Object)"caseFile_invoice");
        WorkItemNode caseTask = (WorkItemNode)nodes[4];
        Assertions.assertThat((String)caseTask.getName()).isEqualTo((Object)"Start another case");
        Assertions.assertThat((String)caseTask.getWork().getName()).isEqualTo((Object)"StartCaseInstance");
        Assertions.assertThat((Object)caseTask.getWork().getParameter("CaseDefinitionId")).isEqualTo((Object)"caseDefId");
        Assertions.assertThat((List)caseTask.getInAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)caseTask.getInAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)caseTask.getInAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"caseFile_invoice");
        Assertions.assertThat((String)((DataAssociation)caseTask.getInAssociations().get(0)).getTarget()).isEqualTo((Object)"Data_origin");
        Assertions.assertThat((List)caseTask.getOutAssociations()).hasSize(1);
        Assertions.assertThat((List)((DataAssociation)caseTask.getOutAssociations().get(0)).getSources()).hasSize(1);
        Assertions.assertThat((String)((String)((DataAssociation)caseTask.getOutAssociations().get(0)).getSources().get(0))).isEqualTo((Object)"updated");
        Assertions.assertThat((String)((DataAssociation)caseTask.getOutAssociations().get(0)).getTarget()).isEqualTo((Object)"caseFile_invoice");
    }

    @Test
    public void testLoadOrderITHardwareCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-OrderITHardwareCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("itorders.orderhardware");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"itorders.orderhardware");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"Order IT hardware");
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(9);
        List variables = caseProcess.getVariableScope().getVariables();
        Assertions.assertThat((List)variables).hasSize(7);
    }

    @Test
    public void testLoadProcessTaskReferenceCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-ProcessTaskReferenceCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("Case_636d4bea-4d52-46fb-b1ad-9ceeddf1be69");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"Case_636d4bea-4d52-46fb-b1ad-9ceeddf1be69");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"ProcessTaskCase");
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(1);
        SubProcessNode processNode = (SubProcessNode)nodes[0];
        Assertions.assertThat((String)processNode.getName()).isEqualTo((Object)"call my process");
        Assertions.assertThat((String)processNode.getProcessId()).isEqualTo((Object)"_4e0c5178-c886-4a14-ab6b-6ec6c940194b");
        Assertions.assertThat((boolean)processNode.isWaitForCompletion()).isTrue();
        Assertions.assertThat((boolean)processNode.isIndependent()).isFalse();
        Assertions.assertThat((List)processNode.getInAssociations()).hasSize(0);
        Assertions.assertThat((List)processNode.getOutAssociations()).hasSize(0);
    }

    @Test
    public void testLoadProcessAndDecisionTaskReferenceCase() throws Exception {
        KieBase kbase = this.createKnowledgeBase("CMMN-DecisionTaskReferenceCase.cmmn");
        Assertions.assertThat((Object)kbase).isNotNull();
        Process process = kbase.getProcess("Case_636d4bea-4d52-46fb-b1ad-9ceeddf1be69");
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((Object)process).isInstanceOf(RuleFlowProcess.class);
        RuleFlowProcess caseProcess = (RuleFlowProcess)process;
        Assertions.assertThat((boolean)caseProcess.isDynamic()).isTrue();
        Assertions.assertThat((String)caseProcess.getId()).isEqualTo((Object)"Case_636d4bea-4d52-46fb-b1ad-9ceeddf1be69");
        Assertions.assertThat((String)caseProcess.getName()).isEqualTo((Object)"ProcessAndDecisionTaskCase");
        Object[] nodes = caseProcess.getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(2);
        SubProcessNode processNode = (SubProcessNode)nodes[0];
        Assertions.assertThat((String)processNode.getName()).isEqualTo((Object)"call my process");
        Assertions.assertThat((String)processNode.getProcessId()).isEqualTo((Object)"_4e0c5178-c886-4a14-ab6b-6ec6c940194b");
        Assertions.assertThat((boolean)processNode.isWaitForCompletion()).isTrue();
        Assertions.assertThat((boolean)processNode.isIndependent()).isFalse();
        Assertions.assertThat((List)processNode.getInAssociations()).hasSize(0);
        Assertions.assertThat((List)processNode.getOutAssociations()).hasSize(0);
        RuleSetNode decisionTask = (RuleSetNode)nodes[1];
        Assertions.assertThat((String)decisionTask.getName()).isEqualTo((Object)"call my decision");
        Assertions.assertThat((String)decisionTask.getLanguage()).isEqualTo((Object)"http://www.jboss.org/drools/dmn");
        Assertions.assertThat((String)decisionTask.getRuleFlowGroup()).isNull();
        Assertions.assertThat((String)decisionTask.getNamespace()).isEqualTo((Object)"http://www.trisotech.com/definitions/_0020_vacation_days");
        Assertions.assertThat((String)decisionTask.getModel()).isEqualTo((Object)"_0020_vacation_days");
        Assertions.assertThat((String)decisionTask.getDecision()).isEqualTo((Object)"Total Vacation Days");
        Assertions.assertThat((List)decisionTask.getInAssociations()).hasSize(0);
        Assertions.assertThat((List)decisionTask.getOutAssociations()).hasSize(0);
    }
}

