/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.casemgmt.cmmn.xml.AbstractCaseNodeHandler;
import org.jbpm.process.core.Work;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HumanTaskHandler
extends AbstractCaseNodeHandler {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskHandler.class);

    @Override
    protected Node createNode(Attributes attrs) {
        return new HumanTaskNode();
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        HumanTaskNode humanTaskNode = (HumanTaskNode)node;
        Work work = humanTaskNode.getWork();
        work.setName("Human Task");
        String performerRef = element.getAttribute("performerRef");
        if (performerRef != null) {
            humanTaskNode.getWork().setParameter("ActorId", (Object)performerRef);
        }
        HashMap<String, String> inputs = new HashMap<String, String>();
        HashMap<String, String> outputs = new HashMap<String, String>();
        HashMap<String, String> inputTypes = new HashMap<String, String>();
        HashMap<String, String> outputTypes = new HashMap<String, String>();
        this.loadDataInputsAndOutputs(element, inputs, outputs, inputTypes, outputTypes, parser);
        humanTaskNode.setMetaData("DataInputs", inputTypes);
        humanTaskNode.setMetaData("DataOutputs", outputTypes);
        humanTaskNode.getWork().setParameter("NodeName", (Object)humanTaskNode.getName());
        humanTaskNode.getWork().setParameter("TaskName", (Object)humanTaskNode.getName().replaceAll("\\s", ""));
        for (Map.Entry entry : inputs.entrySet()) {
            humanTaskNode.addInAssociation(new DataAssociation((String)entry.getValue(), (String)entry.getKey(), Collections.emptyList(), null));
        }
        for (Map.Entry entry : outputs.entrySet()) {
            humanTaskNode.addOutAssociation(new DataAssociation((String)entry.getKey(), (String)entry.getValue(), Collections.emptyList(), null));
        }
    }

    public Class<?> generateNodeFor() {
        return HumanTaskNode.class;
    }
}

