/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseMilestoneInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.api.model.instance.CommentSortBy;
import org.jbpm.casemgmt.impl.objects.EchoService;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.document.Document;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseServiceImplTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseServiceImplTest.class);
    private static final String TEST_DOC_STORAGE = "target/docs";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        System.setProperty("org.jbpm.document.storage", TEST_DOC_STORAGE);
        this.deleteFolder(TEST_DOC_STORAGE);
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/UserTaskCase.bpmn2");
        processes.add("cases/UserTaskWithStageCase.bpmn2");
        processes.add("cases/UserTaskWithStageCaseAutoStart.bpmn2");
        processes.add("cases/UserStageAdhocCase.bpmn2");
        processes.add("processes/DataVerificationProcess.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        System.clearProperty("org.jbpm.document.storage");
        CaseServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCase() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.cancelCase(caseId);
            try {
                this.caseService.getCaseInstance(caseId);
                Assert.fail((String)"Case was aborted so it should not be found any more");
            }
            catch (CaseNotFoundException caseNotFoundException) {
                // empty catch block
            }
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseAndDestroy() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.destroyCase(caseId);
            try {
                this.caseService.getCaseInstance(caseId);
                Assert.fail((String)"Case was aborted so it should not be found any more");
            }
            catch (CaseNotFoundException caseNotFoundException) {
                // empty catch block
            }
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseWithCaseFile() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertNotNull((Object)cInstance.getCaseFile());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseFile().getData("name"));
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.cancelCase(caseId);
            try {
                this.caseService.getCaseInstance(caseId);
                Assert.fail((String)"Case was aborted so it should not be found any more");
            }
            catch (CaseNotFoundException caseNotFoundException) {
                // empty catch block
            }
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseWithCaseFileAndDocument() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        byte[] docContent = "first case document".getBytes();
        DocumentImpl document = new DocumentImpl(UUID.randomUUID().toString(), "test case doc", (long)docContent.length, new Date());
        document.setContent(docContent);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        data.put("document", (String)document);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertNotNull((Object)cInstance.getCaseFile());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseFile().getData("name"));
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Object doc = cInstance.getCaseFile().getData("document");
            Assert.assertNotNull((Object)doc);
            Assert.assertTrue((boolean)(doc instanceof Document));
            Document caseDoc = (Document)doc;
            Assert.assertEquals((Object)"test case doc", (Object)caseDoc.getName());
            Assert.assertEquals((long)docContent.length, (long)caseDoc.getSize());
            Assert.assertEquals((Object)new String(docContent), (Object)new String(caseDoc.getContent()));
            this.caseService.cancelCase(caseId);
            try {
                this.caseService.getCaseInstance(caseId);
                Assert.fail((String)"Case was aborted so it should not be found any more");
            }
            catch (CaseNotFoundException caseNotFoundException) {
                // empty catch block
            }
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddUserTaskToEmptyCase() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap parameters = new HashMap();
            this.caseService.addDynamicTask("CASE-0000000001", this.caseService.newHumanTaskSpec("First task", "test", "john", null, parameters));
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            this.assertTask(task, "john", "First task", Status.Reserved);
            Assert.assertEquals((Object)"test", (Object)task.getDescription());
            String nameVar = (String)this.processService.getProcessInstanceVariable(task.getProcessInstanceId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"my first case", (Object)nameVar);
            this.userTaskService.start(task.getId(), "john");
            HashMap<String, String> outcome = new HashMap<String, String>();
            outcome.put("name", "updated by dynamic task");
            this.userTaskService.complete(task.getId(), "john", outcome);
            nameVar = (String)this.processService.getProcessInstanceVariable(task.getProcessInstanceId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"updated by dynamic task", (Object)nameVar);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)1L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            this.caseService.addDynamicTask(casePI.getId(), this.caseService.newHumanTaskSpec("Second task", "another test", "mary", null, parameters));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            task = (TaskSummary)tasks.get(0);
            this.assertTask(task, "mary", "Second task", Status.Reserved);
            Assert.assertEquals((Object)"another test", (Object)task.getDescription());
            this.userTaskService.start(task.getId(), "mary");
            this.userTaskService.complete(task.getId(), "mary", null);
            Collection nodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(casePI.getId().longValue(), (QueryContext)new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)nodes);
            Assert.assertEquals((long)4L, (long)nodes.size());
            Map<String, String> nodesByName = nodes.stream().collect(Collectors.toMap(NodeInstanceDesc::getName, NodeInstanceDesc::getNodeType));
            Assert.assertTrue((boolean)nodesByName.containsKey("StartProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("EndProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] First task"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] Second task"));
            Assert.assertEquals((Object)"StartNode", (Object)nodesByName.get("StartProcess"));
            Assert.assertEquals((Object)"EndNode", (Object)nodesByName.get("EndProcess"));
            Assert.assertEquals((Object)"Human Task", (Object)nodesByName.get("[Dynamic] First task"));
            Assert.assertEquals((Object)"Human Task", (Object)nodesByName.get("[Dynamic] Second task"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddUserTaskToCaseWithStage() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            CaseDefinition caseDef = this.caseRuntimeDataService.getCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase");
            Assert.assertNotNull((Object)caseDef);
            Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
            CaseStage stage = (CaseStage)caseDef.getCaseStages().iterator().next();
            HashMap parameters = new HashMap();
            this.caseService.addDynamicTaskToStage("CASE-0000000001", stage.getId(), this.caseService.newHumanTaskSpec("First task", "test", "john", null, parameters));
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            this.assertTask(task, "john", "First task", Status.Reserved);
            Assert.assertEquals((Object)"test", (Object)task.getDescription());
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)1L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            this.caseService.addDynamicTaskToStage(casePI.getId(), stage.getId(), this.caseService.newHumanTaskSpec("Second task", "another test", "mary", null, parameters));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            task = (TaskSummary)tasks.get(0);
            this.assertTask(task, "mary", "Second task", Status.Reserved);
            Assert.assertEquals((Object)"another test", (Object)task.getDescription());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddServiceTaskToEmptyCase() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)1L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            String nameVar = (String)this.processService.getProcessInstanceVariable(casePI.getId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"my first case", (Object)nameVar);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("Interface", EchoService.class.getName());
            parameters.put("Operation", "echo");
            parameters.put("ParameterType", String.class.getName());
            parameters.put("Parameter", "testing dynamic service task");
            this.caseService.addDynamicTask("CASE-0000000001", this.caseService.newTaskSpec("Service Task", "task 1", parameters));
            nameVar = (String)this.processService.getProcessInstanceVariable(casePI.getId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"testing dynamic service task echoed by service", (Object)nameVar);
            parameters.put("Parameter", "testing dynamic service task 2");
            this.caseService.addDynamicTask(casePI.getId(), this.caseService.newTaskSpec("Service Task", "task 2", parameters));
            nameVar = (String)this.processService.getProcessInstanceVariable(casePI.getId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"testing dynamic service task 2 echoed by service", (Object)nameVar);
            Collection nodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(casePI.getId().longValue(), (QueryContext)new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)nodes);
            Assert.assertEquals((long)4L, (long)nodes.size());
            Map<String, String> nodesByName = nodes.stream().collect(Collectors.toMap(NodeInstanceDesc::getName, NodeInstanceDesc::getNodeType));
            Assert.assertTrue((boolean)nodesByName.containsKey("StartProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("EndProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] task 1"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] task 2"));
            Assert.assertEquals((Object)"StartNode", (Object)nodesByName.get("StartProcess"));
            Assert.assertEquals((Object)"EndNode", (Object)nodesByName.get("EndProcess"));
            Assert.assertEquals((Object)"Service Task", (Object)nodesByName.get("[Dynamic] task 1"));
            Assert.assertEquals((Object)"Service Task", (Object)nodesByName.get("[Dynamic] task 2"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSubprocessToEmptyCase() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap parameters = new HashMap();
            this.caseService.addDynamicSubprocess("CASE-0000000001", "DataVerification", parameters);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)2L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            this.caseService.addDynamicSubprocess(casePI.getId(), "DataVerification", parameters);
            caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)3L, (long)caseProcessInstances.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSubprocessToCaseWithStage() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            CaseDefinition caseDef = this.caseRuntimeDataService.getCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase");
            Assert.assertNotNull((Object)caseDef);
            Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
            CaseStage stage = (CaseStage)caseDef.getCaseStages().iterator().next();
            HashMap parameters = new HashMap();
            this.caseService.addDynamicSubprocessToStage("CASE-0000000001", stage.getId(), "DataVerification", parameters);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)2L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            this.caseService.addDynamicSubprocessToStage(casePI.getId(), stage.getId(), "DataVerification", parameters);
            caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)3L, (long)caseProcessInstances.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerTaskAndMilestoneInCase() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(deploymentUnit.getIdentifier(), "UserTaskCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Assert.assertEquals((long)3L, (long)caseDef.getAdHocFragments().size());
        Map<String, AdHocFragment> mappedFragments = this.mapAdHocFragments(caseDef.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Hello2"));
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone1"));
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone2"));
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Hello1", (Object)task.getName());
            Assert.assertEquals((Object)"john", (Object)task.getActualOwnerId());
            Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
            HashMap<String, String> taskData = new HashMap<String, String>();
            taskData.put("test", "value");
            taskData.put("fromVar", "#{s}");
            this.caseService.triggerAdHocFragment("HR-0000000001", "Hello2", taskData);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)2L, (long)tasks.size());
            task = (TaskSummary)tasks.get(0);
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Hello2", (Object)task.getName());
            Assert.assertEquals((Object)"john", (Object)task.getActualOwnerId());
            Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
            Map taskInputs = this.userTaskService.getTaskInputContentByTaskId(task.getId());
            Assert.assertNotNull((Object)taskInputs);
            Assert.assertTrue((boolean)taskInputs.containsKey("test"));
            Assert.assertTrue((boolean)taskInputs.containsKey("fromVar"));
            Assert.assertEquals((Object)"value", taskInputs.get("test"));
            Assert.assertEquals((Object)"description", taskInputs.get("fromVar"));
            task = (TaskSummary)tasks.get(1);
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Hello1", (Object)task.getName());
            Assert.assertEquals((Object)"john", (Object)task.getActualOwnerId());
            Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
            Collection milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", true, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)0L, (long)milestones.size());
            this.caseService.triggerAdHocFragment("HR-0000000001", "Milestone1", null);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", true, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)1L, (long)milestones.size());
            CaseMilestoneInstance msInstance = (CaseMilestoneInstance)milestones.iterator().next();
            Assert.assertNotNull((Object)msInstance);
            Assert.assertEquals((Object)"Milestone1", (Object)msInstance.getName());
            Assert.assertEquals((Object)true, (Object)msInstance.isAchieved());
            Assert.assertNotNull((Object)msInstance.getAchievedAt());
            this.caseService.triggerAdHocFragment("HR-0000000001", "Milestone2", null);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", true, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)1L, (long)milestones.size());
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", false, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)2L, (long)milestones.size());
            this.caseService.addDataToCaseFile("HR-0000000001", "dataComplete", (Object)true);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", true, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)2L, (long)milestones.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseRolesWithDynamicTask() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(deploymentUnit.getIdentifier(), "UserTaskCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Assert.assertEquals((long)3L, (long)caseDef.getAdHocFragments().size());
        Map<String, AdHocFragment> mappedFragments = this.mapAdHocFragments(caseDef.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Hello2"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedFragments.get("Hello2").getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone1"));
        Assert.assertEquals((Object)"MilestoneNode", (Object)mappedFragments.get("Milestone1").getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone2"));
        Assert.assertEquals((Object)"MilestoneNode", (Object)mappedFragments.get("Milestone2").getType());
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.assignToCaseRole("HR-0000000001", "contact", (OrganizationalEntity)new UserImpl("mary"));
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "john", "Hello1", Status.Reserved);
            this.caseService.addDynamicTask("HR-0000000001", this.caseService.newHumanTaskSpec("Second task", "another test", "contact", null, new HashMap()));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "mary", "Second task", Status.Reserved);
            this.caseService.assignToCaseRole("HR-0000000001", "contact", (OrganizationalEntity)new UserImpl("john"));
            this.caseService.addDynamicTask("HR-0000000001", this.caseService.newHumanTaskSpec("Third task", "another test", "contact", null, new HashMap()));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)2L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), null, "Third task", Status.Ready);
            this.assertTask((TaskSummary)tasks.get(1), "mary", "Second task", Status.Reserved);
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithStageAutoStartNodes() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)2L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "john", "Ask for input", Status.Reserved);
            this.assertTask((TaskSummary)tasks.get(1), "john", "Missing data", Status.Reserved);
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithComments() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseComments = this.caseService.getCaseComments("CASE-0000000001", new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            this.caseService.addCaseComment("CASE-0000000001", "poul", "just a tiny comment");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            CommentInstance comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "just a tiny comment");
            this.caseService.updateCaseComment("CASE-0000000001", comment.getId(), comment.getAuthor(), "Updated " + comment.getComment());
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "Updated just a tiny comment");
            this.caseService.addCaseComment("CASE-0000000001", "mary", "another comment");
            this.caseService.addCaseComment("CASE-0000000001", "john", "third comment");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)3L, (long)caseComments.size());
            Iterator it = caseComments.iterator();
            this.assertComment((CommentInstance)it.next(), "poul", "Updated just a tiny comment");
            this.assertComment((CommentInstance)it.next(), "mary", "another comment");
            this.assertComment((CommentInstance)it.next(), "john", "third comment");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new org.kie.internal.query.QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)3L, (long)caseComments.size());
            it = caseComments.iterator();
            this.assertComment((CommentInstance)it.next(), "john", "third comment");
            this.assertComment((CommentInstance)it.next(), "mary", "another comment");
            this.assertComment((CommentInstance)it.next(), "poul", "Updated just a tiny comment");
            this.caseService.removeCaseComment("CASE-0000000001", comment.getId());
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new org.kie.internal.query.QueryContext());
            Assert.assertEquals((long)2L, (long)caseComments.size());
            it = caseComments.iterator();
            this.assertComment((CommentInstance)it.next(), "john", "third comment");
            this.assertComment((CommentInstance)it.next(), "mary", "another comment");
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithStageAndAdHocFragments() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserStageAdhocCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserStageAdhocCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            this.assertCaseInstance(caseId, "my first case");
            Collection availableFragments = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
            Assert.assertEquals((long)2L, (long)availableFragments.size());
            Map<String, AdHocFragment> mapped = this.mapAdHocFragments(availableFragments);
            Assert.assertEquals((Object)"HumanTaskNode", (Object)mapped.get("Adhoc 1").getType());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)mapped.get("Adhoc 2").getType());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "john", "Initial step", Status.Reserved);
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", null);
            availableFragments = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
            Assert.assertEquals((long)4L, (long)availableFragments.size());
            mapped = this.mapAdHocFragments(availableFragments);
            Assert.assertEquals((Object)"HumanTaskNode", (Object)mapped.get("Adhoc 1").getType());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)mapped.get("Adhoc 2").getType());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)mapped.get("First").getType());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)mapped.get("Second").getType());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    protected void assertComment(CommentInstance comment, String author, String content) {
        Assert.assertNotNull((Object)comment);
        Assert.assertEquals((Object)author, (Object)comment.getAuthor());
        Assert.assertEquals((Object)content, (Object)comment.getComment());
    }

    protected void assertTask(TaskSummary task, String actor, String name, Status status) {
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)name, (Object)task.getName());
        Assert.assertEquals((Object)actor, (Object)task.getActualOwnerId());
        Assert.assertEquals((Object)status, (Object)task.getStatus());
    }

    protected void assertCaseInstance(String caseId, String name) {
        CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
        Assert.assertNotNull((Object)cInstance);
        Assert.assertEquals((Object)caseId, (Object)cInstance.getCaseId());
        Assert.assertNotNull((Object)cInstance.getCaseFile());
        Assert.assertEquals((Object)name, (Object)cInstance.getCaseFile().getData("name"));
    }
}

