/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseMilestone;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseMilestoneInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.impl.model.AdHocFragmentImpl;
import org.jbpm.casemgmt.impl.model.CaseDefinitionComparator;
import org.jbpm.casemgmt.impl.model.CaseDefinitionImpl;
import org.jbpm.casemgmt.impl.model.CaseMilestoneImpl;
import org.jbpm.casemgmt.impl.model.CaseRoleImpl;
import org.jbpm.casemgmt.impl.model.CaseStageImpl;
import org.jbpm.casemgmt.impl.model.instance.CaseMilestoneInstanceImpl;
import org.jbpm.casemgmt.impl.model.instance.CaseStageInstanceImpl;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.KieInternalServices;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;

public class CaseRuntimeDataServiceImpl
implements CaseRuntimeDataService,
DeploymentEventListener {
    protected Set<CaseDefinitionImpl> availableCases = new HashSet<CaseDefinitionImpl>();
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private CaseIdGenerator caseIdGenerator;
    private RuntimeDataService runtimeDataService;
    private TransactionalCommandService commandService;
    private IdentityProvider identityProvider;
    private DeploymentRolesManager deploymentRolesManager = new DeploymentRolesManager();
    private List<Integer> statuses = Arrays.asList(1);

    public CaseRuntimeDataServiceImpl() {
        QueryManager.get().addNamedQueries("META-INF/CaseMgmtorm.xml");
    }

    public CaseIdGenerator getCaseIdGenerator() {
        return this.caseIdGenerator;
    }

    public void setCaseIdGenerator(CaseIdGenerator caseIdGenerator) {
        this.caseIdGenerator = caseIdGenerator;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setDeploymentRolesManager(DeploymentRolesManager deploymentRolesManager) {
        this.deploymentRolesManager = deploymentRolesManager;
    }

    public void onDeploy(DeploymentEvent event) {
        AbstractRuntimeManager runtimeManager = (AbstractRuntimeManager)event.getDeployedUnit().getRuntimeManager();
        KieBase kieBase = runtimeManager.getEnvironment().getKieBase();
        Collection processes = kieBase.getProcesses();
        Map<String, DeployedAsset> mapProcessById = event.getDeployedUnit().getDeployedAssets().stream().collect(Collectors.toMap(DeployedAsset::getId, asset -> asset));
        for (Process process : processes) {
            if (!((WorkflowProcess)process).isDynamic()) continue;
            String caseIdPrefix = this.collectCaseIdPrefix(process);
            Collection<CaseMilestone> caseMilestones = this.collectMilestoness(process);
            Collection<CaseStage> caseStages = this.collectCaseStages(event.getDeploymentId(), process.getId(), (NodeContainer)((WorkflowProcess)process));
            Collection<CaseRole> caseRoles = this.collectCaseRoles(process);
            Collection<AdHocFragment> adHocFragments = this.collectAdHocFragments((NodeContainer)((WorkflowProcess)process));
            CaseDefinitionImpl caseDef = new CaseDefinitionImpl((ProcessAssetDesc)mapProcessById.get(process.getId()), caseIdPrefix, caseStages, caseMilestones, caseRoles, adHocFragments);
            this.availableCases.add(caseDef);
            this.caseIdGenerator.register(caseIdPrefix);
        }
        Collection assets = event.getDeployedUnit().getDeployedAssets();
        List roles = null;
        for (DeployedAsset asset2 : assets) {
            if (!(asset2 instanceof ProcessAssetDesc) || roles != null) continue;
            roles = ((ProcessAssetDesc)asset2).getRoles();
        }
        if (roles == null) {
            roles = Collections.emptyList();
        }
        this.deploymentRolesManager.addRolesForDeployment(event.getDeploymentId(), roles);
    }

    public void onUnDeploy(DeploymentEvent event) {
        Collection undeployed = this.availableCases.stream().filter(caseDef -> caseDef.getDeploymentId().equals(event.getDeploymentId())).collect(Collectors.toList());
        this.availableCases.removeAll(undeployed);
        undeployed.forEach(caseDef -> this.caseIdGenerator.unregister(caseDef.getIdentifierPrefix()));
        this.deploymentRolesManager.removeRolesForDeployment(event.getDeploymentId());
    }

    public void onActivate(DeploymentEvent event) {
    }

    public void onDeactivate(DeploymentEvent event) {
    }

    public CaseDefinition getCase(String deploymentId, String caseDefinitionId) {
        return this.availableCases.stream().filter(caseDef -> caseDef.getDeploymentId().equals(deploymentId) && caseDef.getId().equals(caseDefinitionId)).findFirst().orElse(null);
    }

    public Collection<CaseDefinition> getCases(org.kie.internal.query.QueryContext queryContext) {
        Collection cases = this.availableCases.stream().filter(caseDef -> caseDef.isActive()).sorted(new CaseDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<CaseDefinition> getCases(String filter, org.kie.internal.query.QueryContext queryContext) {
        String pattern = "(?i)^.*" + filter + ".*$";
        Collection cases = this.availableCases.stream().filter(caseDef -> caseDef.isActive() && (caseDef.getId().matches(pattern) || caseDef.getName().matches(pattern))).sorted(new CaseDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<CaseDefinition> getCasesByDeployment(String deploymentId, org.kie.internal.query.QueryContext queryContext) {
        Collection cases = this.availableCases.stream().filter(caseDef -> caseDef.isActive() && caseDef.getDeploymentId().equals(deploymentId)).sorted(new CaseDefinitionComparator(queryContext.getOrderBy(), queryContext.isAscending())).skip(queryContext.getOffset().intValue()).limit(queryContext.getCount().intValue()).collect(Collectors.toList());
        return cases;
    }

    public Collection<ProcessInstanceDesc> getProcessInstancesForCase(String caseId, org.kie.internal.query.QueryContext queryContext) {
        CorrelationKey correlationKey = this.correlationKeyFactory.newCorrelationKey(caseId);
        return this.runtimeDataService.getProcessInstancesByCorrelationKey(correlationKey, (QueryContext)queryContext);
    }

    public Collection<ProcessInstanceDesc> getProcessInstancesForCase(String caseId, List<Integer> states, org.kie.internal.query.QueryContext queryContext) {
        CorrelationKey correlationKey = this.correlationKeyFactory.newCorrelationKey(caseId);
        return this.runtimeDataService.getProcessInstancesByCorrelationKeyAndStatus(correlationKey, states, (QueryContext)queryContext);
    }

    public Collection<CaseMilestoneInstance> getCaseInstanceMilestones(String caseId, boolean achievedOnly, org.kie.internal.query.QueryContext queryContext) {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi == null || !pi.getState().equals(1)) {
            throw new CaseNotFoundException("No case instance found with id " + caseId + " or it's not active anymore");
        }
        CorrelationKey correlationKey = this.correlationKeyFactory.newCorrelationKey(caseId);
        Collection nodes = this.runtimeDataService.getNodeInstancesByCorrelationKeyNodeType(correlationKey, Arrays.asList(1), Arrays.asList("MilestoneNode"), (QueryContext)queryContext);
        Collection completedNodes = nodes.stream().filter(n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == 1).map(n -> n.getId()).collect(Collectors.toList());
        Predicate<NodeInstanceDesc> filterNodes = null;
        filterNodes = achievedOnly ? n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == 1 : n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == 0;
        Collection milestones = nodes.stream().filter(filterNodes).map(n -> new CaseMilestoneInstanceImpl(String.valueOf(n.getId()), n.getName(), completedNodes.contains(n.getId()), n.getDataTimeStamp())).collect(Collectors.toList());
        return milestones;
    }

    public Collection<CaseStageInstance> getCaseInstanceStages(String caseId, boolean activeOnly, org.kie.internal.query.QueryContext queryContext) {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi == null || !pi.getState().equals(1)) {
            throw new CaseNotFoundException("No case instance found with id " + caseId + " or it's not active anymore");
        }
        CaseDefinition caseDef = this.getCase(pi.getDeploymentId(), pi.getProcessId());
        Collection<CaseStageInstance> stages = this.internalGetCaseStages(caseDef, caseId, activeOnly, queryContext);
        return stages;
    }

    public Collection<NodeInstanceDesc> getActiveNodesForCase(String caseId, org.kie.internal.query.QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getActiveNodesForCase", params));
        return nodeInstances;
    }

    public Collection<CaseInstance> getCaseInstances(org.kie.internal.query.QueryContext queryContext) {
        return this.getCaseInstances(this.statuses, queryContext);
    }

    public Collection<CaseInstance> getCaseInstances(List<Integer> statuses, org.kie.internal.query.QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("statuses", statuses);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseInstances", params));
        return processInstances;
    }

    public Collection<CaseInstance> getCaseInstancesByDeployment(String deploymentId, List<Integer> statuses, org.kie.internal.query.QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("statuses", statuses);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesByDeployment", params));
        return processInstances;
    }

    public Collection<CaseInstance> getCaseInstancesByDefinition(String definitionId, List<Integer> statuses, org.kie.internal.query.QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("definitionId", definitionId);
        params.put("statuses", statuses);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesByDefinition", params));
        return processInstances;
    }

    public Collection<CaseInstance> getCaseInstancesOwnedBy(String owner, List<Integer> statuses, org.kie.internal.query.QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("owner", owner);
        params.put("statuses", statuses);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getCaseInstancesOwnedBy", params));
        return processInstances;
    }

    public Collection<AdHocFragment> getAdHocFragmentsForCase(String caseId) {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi == null || !pi.getState().equals(1)) {
            throw new CaseNotFoundException("No case instance found with id " + caseId + " or it's not active anymore");
        }
        CaseDefinition caseDef = this.getCase(pi.getDeploymentId(), pi.getProcessId());
        ArrayList<AdHocFragment> adHocFragments = new ArrayList<AdHocFragment>();
        adHocFragments.addAll(caseDef.getAdHocFragments());
        Collection<CaseStageInstance> activeStages = this.internalGetCaseStages(caseDef, caseId, true, new org.kie.internal.query.QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
        activeStages.forEach(stage -> adHocFragments.addAll(stage.getAdHocFragments()));
        return adHocFragments;
    }

    public Collection<CaseStageInstance> internalGetCaseStages(CaseDefinition caseDef, String caseId, boolean activeOnly, org.kie.internal.query.QueryContext queryContext) {
        CorrelationKey correlationKey = this.correlationKeyFactory.newCorrelationKey(caseId);
        Collection nodes = this.runtimeDataService.getNodeInstancesByCorrelationKeyNodeType(correlationKey, Arrays.asList(1), Arrays.asList("DynamicNode"), (QueryContext)queryContext);
        Map<String, CaseStage> stagesByName = caseDef.getCaseStages().stream().collect(Collectors.toMap(CaseStage::getId, c -> c));
        Predicate<NodeInstanceDesc> filterNodes = null;
        if (activeOnly) {
            Collection completedNodes = nodes.stream().filter(n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == 1).map(n -> n.getId()).collect(Collectors.toList());
            filterNodes = n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == 0 && !completedNodes.contains(((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getId());
        } else {
            filterNodes = n -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)n).getType() == 0;
        }
        Collection stages = nodes.stream().filter(filterNodes).map(n -> new CaseStageInstanceImpl(n.getNodeId(), n.getName(), ((CaseStage)stagesByName.get(n.getNodeId())).getAdHocFragments(), Collections.emptyList())).collect(Collectors.toList());
        return stages;
    }

    private Collection<CaseRole> collectCaseRoles(Process process) {
        String[] roleStrings;
        String roles = (String)process.getMetaData().get("customCaseRoles");
        if (roles == null) {
            return Collections.emptyList();
        }
        ArrayList<CaseRole> result = new ArrayList<CaseRole>();
        for (String roleString : roleStrings = roles.split(",")) {
            String[] elements = roleString.split(":");
            CaseRoleImpl role = new CaseRoleImpl(elements[0]);
            result.add(role);
            if (elements.length <= 1) continue;
            role.setCardinality(Integer.parseInt(elements[1]));
        }
        return result;
    }

    private String collectCaseIdPrefix(Process process) {
        String caseIdPrefix = (String)process.getMetaData().get("customCaseIdPrefix");
        if (caseIdPrefix == null) {
            return "CASE";
        }
        return caseIdPrefix;
    }

    private Collection<CaseMilestone> collectMilestoness(Process process) {
        ArrayList<CaseMilestone> result = new ArrayList<CaseMilestone>();
        this.getMilestones((NodeContainer)((WorkflowProcess)process), result);
        return result;
    }

    private void getMilestones(NodeContainer container, Collection<CaseMilestone> result) {
        for (Node node : container.getNodes()) {
            if (node instanceof MilestoneNode) {
                result.add(new CaseMilestoneImpl((String)node.getMetaData().get("UniqueId"), node.getName(), ((MilestoneNode)node).getConstraint(), false));
            }
            if (!(node instanceof NodeContainer)) continue;
            this.getMilestones((NodeContainer)node, result);
        }
    }

    private Collection<CaseStage> collectCaseStages(String deploymentId, String processId, NodeContainer process) {
        ArrayList<CaseStage> result = new ArrayList<CaseStage>();
        for (Node node : process.getNodes()) {
            if (!(node instanceof DynamicNode)) continue;
            DynamicNode dynamicNode = (DynamicNode)node;
            Collection<AdHocFragment> adHocFragments = this.collectAdHocFragments((NodeContainer)dynamicNode);
            result.add(new CaseStageImpl((String)((DynamicNode)node).getMetaData("UniqueId"), node.getName(), adHocFragments));
        }
        return result;
    }

    private Collection<AdHocFragment> collectAdHocFragments(NodeContainer process) {
        ArrayList<AdHocFragment> result = new ArrayList<AdHocFragment>();
        this.checkAdHoc(process, result);
        return result;
    }

    private void checkAdHoc(NodeContainer nodeContainer, List<AdHocFragment> result) {
        for (Node node : nodeContainer.getNodes()) {
            if (node instanceof StartNode || !node.getIncomingConnections().isEmpty()) continue;
            result.add(new AdHocFragmentImpl(node.getName(), node.getClass().getSimpleName()));
        }
    }

    protected void applyQueryContext(Map<String, Object> params, org.kie.internal.query.QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    protected void applyDeploymentFilter(Map<String, Object> params) {
        List deploymentIdForUser;
        if (this.deploymentRolesManager != null && (deploymentIdForUser = this.deploymentRolesManager.getDeploymentsForUser(this.identityProvider)) != null && !deploymentIdForUser.isEmpty()) {
            params.put("filter", " log.externalId in (:deployments) ");
            params.put("deployments", deploymentIdForUser);
        }
    }
}

