/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.generator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.generator.CasePrefixNotFoundException;

public class InMemoryCaseIdGenerator
implements CaseIdGenerator {
    private static ConcurrentMap<String, AtomicLong> sequences = new ConcurrentHashMap<String, AtomicLong>();

    public void register(String prefix) {
        sequences.putIfAbsent(prefix, new AtomicLong());
    }

    public void unregister(String prefix) {
        sequences.remove(prefix);
    }

    public String generate(String prefix, Map<String, Object> optionalParameters) throws CasePrefixNotFoundException {
        if (!sequences.containsKey(prefix)) {
            throw new CasePrefixNotFoundException("No case identifier prefix '" + prefix + "' was registered");
        }
        long nextVal = ((AtomicLong)sequences.get(prefix)).incrementAndGet();
        String paddedNumber = String.format("%010d", nextVal);
        return prefix + "-" + paddedNumber;
    }
}

