/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.event.CaseReopenEvent;
import org.jbpm.casemgmt.api.event.CaseRoleAssignmentEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.impl.audit.CaseRoleAssignmentLog;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryStringCommand;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.kie.api.command.Command;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.task.api.TaskModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInstanceAuditEventListener
implements CaseEventListener,
Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(CaseInstanceAuditEventListener.class);
    private static final String UPDATE_CASE_PROCESS_INST_ID_QUERY = "update CaseRoleAssignmentLog set processInstanceId =:piID where caseId =:caseId";
    private static final String DELETE_CASE_ROLE_ASSIGNMENT_QUERY = "delete from CaseRoleAssignmentLog where caseId =:caseId and roleName =:role and entityId =:entity";
    private static final String FIND_CASE_PROCESS_INST_ID_QUERY = "select processInstanceId from ProcessInstanceLog where correlationKey =:caseId";
    private TransactionalCommandService commandService;

    public CaseInstanceAuditEventListener(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void afterCaseStarted(CaseStartEvent event) {
        CaseFileInstance caseFile = event.getCaseFile();
        if (caseFile == null) {
            return;
        }
        Collection<CaseRoleInstance> caseRoleAssignments = ((CaseFileInstanceImpl)caseFile).getAssignments();
        if (caseRoleAssignments != null && !caseRoleAssignments.isEmpty()) {
            for (CaseRoleInstance roleAssignment : caseRoleAssignments) {
                logger.debug("Role {} has following assignments {}", (Object)roleAssignment.getRoleName(), (Object)roleAssignment.getRoleAssignments());
                if (roleAssignment.getRoleAssignments() == null || roleAssignment.getRoleAssignments().isEmpty()) continue;
                ArrayList objects = new ArrayList();
                roleAssignment.getRoleAssignments().forEach(entity -> {
                    CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(event.getProcessInstanceId(), event.getCaseId(), roleAssignment.getRoleName(), (OrganizationalEntity)entity);
                    objects.add(assignmentLog);
                });
                this.commandService.execute((Command)new PersistObjectCommand(objects.toArray()));
            }
        } else {
            CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(event.getProcessInstanceId(), event.getCaseId(), "*", (OrganizationalEntity)TaskModelProvider.getFactory().newGroup("_public_"));
            this.commandService.execute((Command)new PersistObjectCommand(new Object[]{assignmentLog}));
        }
    }

    public void afterCaseReopen(CaseReopenEvent event) {
        logger.debug("Updating process instance id ({})in case assignment log for case id {}", (Object)event.getProcessInstanceId(), (Object)event.getCaseId());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("piID", event.getProcessInstanceId());
        parameters.put("caseId", event.getCaseId());
        UpdateStringCommand updateCommand = new UpdateStringCommand(UPDATE_CASE_PROCESS_INST_ID_QUERY, parameters);
        int updated = (Integer)this.commandService.execute((Command)updateCommand);
        logger.debug("Updated {} role assignment entries for case id {}", (Object)updated, (Object)event.getCaseId());
    }

    public void afterCaseRoleAssignmentAdded(CaseRoleAssignmentEvent event) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", event.getCaseId());
        QueryStringCommand queryCommand = new QueryStringCommand(FIND_CASE_PROCESS_INST_ID_QUERY, parameters);
        List processInstanceId = (List)this.commandService.execute((Command)queryCommand);
        if (processInstanceId.isEmpty()) {
            return;
        }
        CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog((Long)processInstanceId.get(0), event.getCaseId(), event.getRole(), event.getEntity());
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{assignmentLog}));
    }

    public void afterCaseRoleAssignmentRemoved(CaseRoleAssignmentEvent event) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", event.getCaseId());
        parameters.put("role", event.getRole());
        parameters.put("entity", event.getEntity().getId());
        UpdateStringCommand updateCommand = new UpdateStringCommand(DELETE_CASE_ROLE_ASSIGNMENT_QUERY, parameters);
        this.commandService.execute((Command)updateCommand);
        logger.debug("Removed {} role assignment for entity {} for case id {}", new Object[]{event.getRole(), event.getEntity(), event.getCaseId()});
    }

    public void close() {
    }
}

