/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import java.util.Map;
import org.drools.core.ClassObjectFilter;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

public class AddDataCaseFileInstanceCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335953L;
    private Map<String, Object> parameters;

    public AddDataCaseFileInstanceCommand(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() != 1) {
            throw new IllegalStateException("Not able to find distinct case file - found case files " + caseFiles.size());
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseDataAdded(caseFile.getCaseId(), this.parameters);
        caseFile.addAll(this.parameters);
        caseEventSupport.fireAfterCaseDataAdded(caseFile.getCaseId(), this.parameters);
        ksession.update(factHandle, (Object)caseFile);
        return null;
    }
}

