/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Map;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;

public class AddDynamicTaskCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335953L;
    private String caseId;
    private String nodeType;
    private long processInstanceId;
    private Map<String, Object> parameters;

    public AddDynamicTaskCommand(String caseId, String nodeType, Long processInstanceId, Map<String, Object> parameters) {
        this.caseId = caseId;
        this.nodeType = nodeType;
        this.processInstanceId = processInstanceId;
        this.parameters = parameters;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        if (processInstance == null) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + this.processInstanceId);
        }
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeDynamicTaskAdded(this.caseId, this.processInstanceId, this.nodeType, this.parameters);
        DynamicUtils.addDynamicWorkItem((ProcessInstance)processInstance, (KieRuntime)ksession, (String)this.nodeType, this.parameters);
        caseEventSupport.fireAfterDynamicTaskAdded(this.caseId, this.processInstanceId, this.nodeType, this.parameters);
        return null;
    }
}

