/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import org.drools.core.ClassObjectFilter;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.task.model.OrganizationalEntity;

public class ModifyRoleAssignmentCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335923L;
    private String roleName;
    private OrganizationalEntity entity;
    private boolean add;

    public ModifyRoleAssignmentCommand(String roleName, OrganizationalEntity entity, boolean add) {
        this.roleName = roleName;
        this.entity = entity;
        this.add = add;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() != 1) {
            throw new IllegalStateException("Not able to find distinct case file - found case files " + caseFiles.size());
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        if (this.add) {
            caseEventSupport.fireBeforeCaseRoleAssignmentAdded(caseFile.getCaseId(), this.roleName, this.entity);
            ((CaseAssignment)caseFile).assign(this.roleName, this.entity);
            caseEventSupport.fireAfterCaseRoleAssignmentAdded(caseFile.getCaseId(), this.roleName, this.entity);
        } else {
            caseEventSupport.fireBeforeCaseRoleAssignmentRemoved(caseFile.getCaseId(), this.roleName, this.entity);
            ((CaseAssignment)caseFile).remove(this.roleName, this.entity);
            caseEventSupport.fireAfterCaseRoleAssignmentRemoved(caseFile.getCaseId(), this.roleName, this.entity);
        }
        ksession.update(factHandle, (Object)caseFile);
        return null;
    }
}

