/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Map;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.identity.IdentityProvider;

public class AddDynamicProcessToStageCommand
extends CaseCommand<Long> {
    private static final long serialVersionUID = 6345222909719335953L;
    private String caseId;
    private String processId;
    private String stageId;
    private long processInstanceId;
    private Map<String, Object> parameters;

    public AddDynamicProcessToStageCommand(IdentityProvider identityProvider, String caseId, Long processInstanceId, String stageId, String processId, Map<String, Object> parameters) {
        super(identityProvider);
        this.caseId = caseId;
        this.processInstanceId = processInstanceId;
        this.stageId = stageId;
        this.processId = processId;
        this.parameters = parameters;
        if (processInstanceId == null || processId == null || stageId == null) {
            throw new IllegalArgumentException("Mandatory parameters are missing - process instance id / process id / stage id");
        }
    }

    public Long execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        if (processInstance == null) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + this.processInstanceId);
        }
        DynamicNodeInstance dynamicContext = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances(true).stream().filter(ni -> ni instanceof DynamicNodeInstance && this.stageId.equals(ni.getNode().getMetaData().get("UniqueId"))).findFirst().orElse(null);
        if (dynamicContext == null) {
            throw new StageNotFoundException("No stage found with id " + this.stageId);
        }
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeDynamicProcessAdded(this.caseId, this.processInstanceId, this.processId, this.parameters);
        long subProcessInstanceId = DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicContext, (KieRuntime)ksession, (String)this.processId, this.parameters);
        caseEventSupport.fireAfterDynamicProcessAdded(this.caseId, this.processInstanceId, this.processId, this.parameters, subProcessInstanceId);
        return subProcessInstanceId;
    }
}

