/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.KieInternalServices;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseCaseCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6811181095390934149L;
    private static final Logger logger = LoggerFactory.getLogger(CloseCaseCommand.class);
    private static CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private String deploymentId;
    private String caseId;
    private String comment;
    private transient ProcessService processService;
    private transient RuntimeDataService runtimeDataService;

    public CloseCaseCommand(IdentityProvider identityProvider, String deploymentId, String caseId, String comment, ProcessService processService, RuntimeDataService runtimeDataService) {
        super(identityProvider);
        this.deploymentId = deploymentId;
        this.caseId = caseId;
        this.comment = comment;
        this.processService = processService;
        this.runtimeDataService = runtimeDataService;
    }

    public Void execute(org.kie.api.runtime.Context context) {
        CorrelationKey correlationKey = correlationKeyFactory.newCorrelationKey(this.caseId);
        Collection caseProcesses = this.runtimeDataService.getProcessInstancesByCorrelationKey(correlationKey, new QueryContext(Integer.valueOf(0), Integer.valueOf(1000)));
        if (caseProcesses.isEmpty()) {
            throw new CaseNotFoundException("Case with id " + this.caseId + " was not found");
        }
        final List processInstanceIds = caseProcesses.stream().filter(pi -> pi.getState().equals(1)).sorted((o1, o2) -> Long.valueOf(o2.getParentId()).compareTo((long)o1.getParentId())).map(pi -> pi.getId()).collect(Collectors.toList());
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        CaseFileInstance caseFile = this.getCaseFile(ksession, this.caseId);
        caseEventSupport.fireBeforeCaseClosed(this.caseId, caseFile, this.comment);
        logger.debug("Process instances {} that will be completed as part of the close of the case {}", processInstanceIds, (Object)this.caseId);
        this.processService.execute(this.deploymentId, (Context)CaseContext.get((String)this.caseId), (Command)new ExecutableCommand<Void>(){
            private static final long serialVersionUID = 1L;

            public Void execute(org.kie.api.runtime.Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                for (Long processInstanceId : processInstanceIds) {
                    WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId.longValue());
                    processInstance.setState(2, CloseCaseCommand.this.comment);
                    logger.debug("Process instance {} set to state completed", (Object)processInstanceId);
                }
                return null;
            }
        });
        caseEventSupport.fireAfterCaseClosed(this.caseId, caseFile, this.comment);
        return null;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

