/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.impl.model.instance.CaseInstanceImpl;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class StageActivationConditionTest
extends AbstractCaseServicesBaseTest {
    private static final String STAGE_WITH_ACTIVATION_COND = "NoStartNodeAdhocCaseWithActivationCondition";

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/stage/activation/NoStartNodeAdhocCaseWithActivationCondition.bpmn2");
        return processes;
    }

    @Test
    public void testAutoComplete() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_ACTIVATION_COND);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(0);
        this.caseService.addDataToCaseFile(caseId, "readyToActivate", (Object)true, new String[0]);
        activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(1);
        this.caseService.addDataToCaseFile(caseId, "readyToComplete", (Object)true, new String[0]);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testAutoCompleteCheckActivationData() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_ACTIVATION_COND);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(0);
        this.caseService.addDataToCaseFile(caseId, "readyToActivate", (Object)true, new String[0]);
        activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(1);
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
        final Long processInstanceId = ((CaseInstanceImpl)caseInstance).getProcessInstanceId();
        Boolean readyVar = (Boolean)this.processService.execute(this.deploymentUnit.getIdentifier(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new ExecutableCommand<Boolean>(){
            private static final long serialVersionUID = 6953820688229804654L;

            public Boolean execute(org.kie.api.runtime.Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                WorkflowProcessInstance pi = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId.longValue(), true);
                NodeInstance ni = (NodeInstance)pi.getNodeInstances().iterator().next();
                return (Boolean)ni.getVariable("ready");
            }
        });
        Assert.assertNotNull((String)"Ready variable should not be null", (Object)readyVar);
        Assert.assertTrue((String)"Ready variable should be set to true", (boolean)readyVar);
        this.caseService.addDataToCaseFile(caseId, "readyToComplete", (Object)true, new String[0]);
        this.assertCaseInstanceNotActive(caseId);
    }
}

