/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseMilestoneInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.casemgmt.impl.util.CountDownListenerFactory;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMMNOrderITHardwareCaseTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CMMNOrderITHardwareCaseTest.class);
    protected static final String CMMN_CASE_ORDER_IT_ID = "itorders.orderhardware";
    @Rule
    public TestName name = new TestName();

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/cmmn/CMMN-OrderITHardwareCase.cmmn");
        processes.add("processes/BPMN2-PlaceOrder.bpmn2");
        return processes;
    }

    @After
    public void tearDown() {
        super.tearDown();
        CountDownListenerFactory.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartOrderITHardwareCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        roleAssignments.put("supplier", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_ORDER_IT_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_ORDER_IT_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Prepare hardware spec");
            HashMap<String, Object> params = new HashMap<String, Object>();
            DocumentImpl doc = new DocumentImpl("hwspec.pdf", 100L, new Date());
            doc.setContent("test value".getBytes());
            params.put("hwSpec_", doc);
            params.put("supplierComment_", "best offer");
            this.userTaskService.completeAutoProgress(task.getId(), "john", params);
            Collection milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(1);
            Assertions.assertThat((String)((CaseMilestoneInstance)milestones.iterator().next()).getName()).isEqualTo((Object)"Hardware spec ready");
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Manager approval");
            params = new HashMap();
            params.put("approved_", true);
            params.put("managerComment_", "good to be ordered");
            this.userTaskService.completeAutoProgress(task.getId(), "mary", params);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(2);
            Iterator it = milestones.iterator();
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Hardware spec ready");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Manager decision");
            Collection pInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assertions.assertThat((Iterable)pInstances).hasSize(2);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Place order");
            params = new HashMap();
            params.put("ordered_", true);
            params.put("info_", "order placed with order number XXXX-YYY-ZZZZ");
            this.userTaskService.completeAutoProgress(task.getId(), "john", params);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(3);
            it = milestones.iterator();
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Hardware spec ready");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Manager decision");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Milestone 1: Order placed");
            this.caseService.addDataToCaseFile(caseId, "shipped", (Object)true, new String[0]);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(4);
            it = milestones.iterator();
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Hardware spec ready");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Manager decision");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Milestone 1: Order placed");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Milestone 2: Order shipped");
            this.caseService.addDataToCaseFile(caseId, "delivered", (Object)true, new String[0]);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(5);
            it = milestones.iterator();
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Hardware spec ready");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Manager decision");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Milestone 1: Order placed");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Milestone 2: Order shipped");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Milestone 3: Delivered to customer");
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Customer satisfaction survey");
            this.caseService.closeCase(caseId, "all work done");
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CLOSED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartOrderITHardwareCaseManagerRejected() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        roleAssignments.put("supplier", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_ORDER_IT_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_ORDER_IT_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Prepare hardware spec");
            HashMap<String, Object> params = new HashMap<String, Object>();
            DocumentImpl doc = new DocumentImpl("hwspec.pdf", 100L, new Date());
            doc.setContent("test value".getBytes());
            params.put("hwSpec_", doc);
            params.put("supplierComment_", "best offer");
            this.userTaskService.completeAutoProgress(task.getId(), "john", params);
            Collection milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(1);
            Assertions.assertThat((String)((CaseMilestoneInstance)milestones.iterator().next()).getName()).isEqualTo((Object)"Hardware spec ready");
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Manager approval");
            params = new HashMap();
            params.put("approved_", false);
            params.put("managerComment_", "too expensive");
            this.userTaskService.completeAutoProgress(task.getId(), "mary", params);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(2);
            Iterator it = milestones.iterator();
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Hardware spec ready");
            Assertions.assertThat((String)((CaseMilestoneInstance)it.next()).getName()).isEqualTo((Object)"Manager decision");
            Collection pInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assertions.assertThat((Iterable)pInstances).hasSize(1);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Order rejected");
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }
}

