/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.jbpm.casemgmt.api.model.CaseFileItem;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory;
import org.jbpm.casemgmt.impl.objects.Patient;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.process.audit.VariableInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseWithJPADataTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseWithJPADataTest.class);

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/CaseExecutionInOneGo.bpmn2");
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseWithJPAData() {
        Patient patient = new Patient("john");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("patient", patient);
        data.put("name", "Patient case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Patient patientFromCase = (Patient)cInstance.getCaseFile().getData("patient");
            Assertions.assertThat((Object)patientFromCase).isNotNull();
            Assertions.assertThat((String)patient.getName()).isEqualTo((Object)patientFromCase.getName());
            Collection logs = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assertions.assertThat((Iterable)logs).hasSize(3);
            Map<String, CaseFileItem> mappedLogs = logs.stream().collect(Collectors.toMap(CaseFileItem::getName, t -> t));
            Assertions.assertThat(mappedLogs).containsKey((Object)"patient");
            Assertions.assertThat(mappedLogs).containsKey((Object)"patient_name");
            this.caseService.removeDataFromCaseFile(caseId, "patient");
            logs = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assertions.assertThat((Iterable)logs).hasSize(1);
            mappedLogs = logs.stream().collect(Collectors.toMap(CaseFileItem::getName, t -> t));
            Assertions.assertThat(mappedLogs).doesNotContainKeys((Object[])new String[]{"patient", "patient_name"});
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testStartCaseInOneGoWithJPAData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("inputData", "Hello request inputData!");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "CaseExecutionInOneGo", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseExecutionInOneGo", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            EntityManager em = this.emf.createEntityManager();
            List logs = em.createQuery("SELECT A FROM VariableInstanceLog A", VariableInstanceLog.class).getResultList();
            Assert.assertThat((Object)logs, (Matcher)CoreMatchers.hasItem((Matcher)CaseWithJPADataTest.var("caseFile_inputData")));
            Assert.assertThat((Object)logs, (Matcher)CoreMatchers.hasItem((Matcher)CaseWithJPADataTest.var("CaseId")));
            Assert.assertThat((Object)logs, (Matcher)CoreMatchers.hasItem((Matcher)CaseWithJPADataTest.var("initiator")));
            Assert.assertThat((Object)logs, (Matcher)CoreMatchers.hasItem((Matcher)CaseWithJPADataTest.var("caseFile_assignedData")));
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CLOSED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
    }

    public static isVar var(String varName) {
        return new isVar(varName);
    }

    protected DeploymentDescriptor createDeploymentDescriptor() {
        this.listenerMvelDefinitions.add("new org.jbpm.casemgmt.impl.util.TrackingCaseEventListener()");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        DeploymentDescriptorBuilder ddBuilder = customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_CASE).addMarshalingStrategy(new ObjectModel("mvel", CaseMarshallerFactory.builder().withDoc().withJpa("org.jbpm.persistence.patient.example").toString(), new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "StartCaseInstance", "new org.jbpm.casemgmt.impl.wih.StartCaseWorkItemHandler(ksession)", new Object[0]));
        this.listenerMvelDefinitions.forEach(listenerDefinition -> ddBuilder.addEventListener(new ObjectModel("mvel", listenerDefinition, new Object[0])));
        this.getProcessListeners().forEach(listener -> ddBuilder.addEventListener(listener));
        this.getWorkItemHandlers().forEach(listener -> ddBuilder.addWorkItemHandler(listener));
        return customDescriptor;
    }

    public static class isVar
    extends CustomMatcher<VariableInstanceLog> {
        private String varName;

        public isVar(String varName) {
            super("isVariable");
            this.varName = varName;
        }

        public boolean matches(Object item) {
            VariableInstanceLog log = (VariableInstanceLog)item;
            return log.getVariableId().equals(this.varName);
        }
    }
}

