/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.jms;

import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jbpm.casemgmt.api.event.CaseDataEvent;
import org.jbpm.casemgmt.api.event.CaseReopenEvent;
import org.jbpm.casemgmt.api.event.CaseRoleAssignmentEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.jms.AsyncCaseInstanceAuditEventProducer;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.model.OrganizationalEntity;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AsyncCaseInstanceAuditEventProducerTest {
    private ConnectionFactory connectionFactory;
    private Queue queue;
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private TextMessage message;
    private AsyncCaseInstanceAuditEventProducer logProducer;

    @Before
    public void configure() throws JMSException {
        this.connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        this.queue = (Queue)Mockito.mock(Queue.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.session = (Session)Mockito.mock(Session.class);
        this.producer = (MessageProducer)Mockito.mock(MessageProducer.class);
        this.message = (TextMessage)Mockito.mock(TextMessage.class);
        Mockito.when((Object)this.connectionFactory.createConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.createSession(true, 1)).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.createProducer((Destination)Matchers.any())).thenReturn((Object)this.producer);
        Mockito.when((Object)this.session.createTextMessage((String)Matchers.any())).thenReturn((Object)this.message);
        this.logProducer = new AsyncCaseInstanceAuditEventProducer();
        this.logProducer.setConnectionFactory(this.connectionFactory);
        this.logProducer.setQueue(this.queue);
        this.logProducer.setTransacted(true);
    }

    @After
    public void assertClose() throws JMSException {
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).close();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCaseStarted() throws JMSException {
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl("TEST-01", "case");
        CaseStartEvent event = new CaseStartEvent("user", "TEST-01", "test", "case", (CaseFileInstance)caseFile, Long.valueOf(1L));
        this.logProducer.afterCaseStarted(event);
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Case"));
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setIntProperty((String)Matchers.eq((Object)"EventType"), Matchers.eq((int)0));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)8));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }

    @Test
    public void testCaseReopen() throws JMSException {
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl("TEST-01", "case");
        CaseReopenEvent event = new CaseReopenEvent("user", "TEST-01", (CaseFileInstance)caseFile, "test", "case", new HashMap());
        this.logProducer.afterCaseReopen(event);
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Case"));
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setIntProperty((String)Matchers.eq((Object)"EventType"), Matchers.eq((int)1));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)4));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }

    @Test
    public void testCaseRoleAssignmentAdded() throws JMSException {
        OrganizationalEntity entity = (OrganizationalEntity)Mockito.mock(OrganizationalEntity.class);
        Mockito.when((Object)entity.getId()).thenReturn((Object)"john");
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl("TEST-01", "case");
        CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent("user", "TEST-01", (CaseFileInstance)caseFile, "owner", entity);
        this.logProducer.afterCaseRoleAssignmentAdded(event);
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Case"));
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setIntProperty((String)Matchers.eq((Object)"EventType"), Matchers.eq((int)2));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)4));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }

    @Test
    public void testCaseRoleAssignmentRemoved() throws JMSException {
        OrganizationalEntity entity = (OrganizationalEntity)Mockito.mock(OrganizationalEntity.class);
        Mockito.when((Object)entity.getId()).thenReturn((Object)"john");
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl("TEST-01", "case");
        CaseRoleAssignmentEvent event = new CaseRoleAssignmentEvent("user", "TEST-01", (CaseFileInstance)caseFile, "owner", entity);
        this.logProducer.afterCaseRoleAssignmentRemoved(event);
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Case"));
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setIntProperty((String)Matchers.eq((Object)"EventType"), Matchers.eq((int)3));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)4));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }

    @Test
    public void testCaseDataAdded() throws JMSException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("test", "value");
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl("TEST-01", "case");
        CaseDataEvent event = new CaseDataEvent("user", "TEST-01", (CaseFileInstance)caseFile, "case", data);
        this.logProducer.afterCaseDataAdded(event);
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Case"));
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setIntProperty((String)Matchers.eq((Object)"EventType"), Matchers.eq((int)4));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)4));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }

    @Test
    public void testCaseDataRemoved() throws JMSException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("test", "value");
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl("TEST-01", "case");
        CaseDataEvent event = new CaseDataEvent("user", "TEST-01", (CaseFileInstance)caseFile, "case", data);
        this.logProducer.afterCaseDataRemoved(event);
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setStringProperty((String)Matchers.eq((Object)"LogType"), (String)Matchers.eq((Object)"Case"));
        ((TextMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setIntProperty((String)Matchers.eq((Object)"EventType"), Matchers.eq((int)5));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).setPriority(Matchers.eq((int)4));
        ((MessageProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.times((int)1))).send((Message)Matchers.eq((Object)this.message));
    }
}

