/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.demo.enrichment.DocumentType;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.document.service.impl.DocumentImpl;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;

public class AdHocConditionsTest
extends AbstractCaseServicesBaseTest {
    private static final String ENRICHMENT_PROC_ID = "src.enrichment-case";

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("org/jbpm/casemgmt/demo/enrichment/enrichment-case.bpmn2");
        processes.add("org/jbpm/casemgmt/demo/enrichment/init.drl");
        return processes;
    }

    @Test
    public void testEnrichmentFlowNotValidManuallyApproved() throws Exception {
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), ENRICHMENT_PROC_ID, data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), ENRICHMENT_PROC_ID, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(3);
        this.identityProvider.setRoles(Arrays.asList("HR"));
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(4);
        Map mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document jbpm", "Upload Document enablement", "Upload Document test"});
        TaskSummary task1 = tasks.stream().filter(task -> task.getName().equals("Upload Document test")).findAny().get();
        HashMap<String, Object> results = new HashMap<String, Object>();
        DocumentImpl document = new DocumentImpl("test", 10L, new Date());
        document.setContent("test".getBytes());
        results.put("uploadedDoc", document);
        this.userTaskService.completeAutoProgress(task1.getId(), "john", results);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(4);
        mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document jbpm", "Upload Document enablement", "Manual Approval for test"});
        task1 = tasks.stream().filter(task -> task.getName().equals("Manual Approval for test")).findAny().get();
        Map inputs = this.userTaskService.getTaskInputContentByTaskId(task1.getId());
        Assertions.assertThat((Map)inputs).containsKeys((Object[])new String[]{"documentFile", "documentType"});
        Assertions.assertThat(inputs.get("documentFile")).isNotNull();
        Assertions.assertThat(inputs.get("documentType")).isNotNull();
        Assertions.assertThat(inputs.get("documentFile")).isInstanceOf(DocumentImpl.class);
        Assertions.assertThat(inputs.get("documentType")).isInstanceOf(DocumentType.class);
        Assertions.assertThat(inputs.get("documentFile")).hasFieldOrPropertyWithValue("name", (Object)"test");
        Assertions.assertThat(inputs.get("documentType")).hasFieldOrPropertyWithValue("name", (Object)"test");
        results = new HashMap();
        DocumentType documentType = new DocumentType("test", true, true, "txt", false);
        results.put("decided", documentType);
        this.userTaskService.completeAutoProgress(task1.getId(), "john", results);
        activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(2);
        this.caseService.destroyCase(caseId);
    }

    @Test
    public void testEnrichmentFlowNotValidManuallyRejected() throws Exception {
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), ENRICHMENT_PROC_ID, data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), ENRICHMENT_PROC_ID, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(3);
        this.identityProvider.setRoles(Arrays.asList("HR"));
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(4);
        Map mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document jbpm", "Upload Document enablement", "Upload Document test"});
        TaskSummary task1 = tasks.stream().filter(task -> task.getName().equals("Upload Document test")).findAny().get();
        HashMap<String, Object> results = new HashMap<String, Object>();
        DocumentImpl document = new DocumentImpl("test", 10L, new Date());
        document.setContent("test".getBytes());
        results.put("uploadedDoc", document);
        this.userTaskService.completeAutoProgress(task1.getId(), "john", results);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(4);
        mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document jbpm", "Upload Document enablement", "Manual Approval for test"});
        task1 = tasks.stream().filter(task -> task.getName().equals("Manual Approval for test")).findAny().get();
        results = new HashMap();
        DocumentType documentType = new DocumentType("test", true, false, "txt", true);
        results.put("decided", documentType);
        this.userTaskService.completeAutoProgress(task1.getId(), "john", results);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(4);
        mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document jbpm", "Upload Document enablement", "Upload Document test"});
        activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(3);
        this.caseService.destroyCase(caseId);
    }

    @Test
    public void testEnrichmentFlowNotValidDirectlyRejected() throws Exception {
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), ENRICHMENT_PROC_ID, data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), ENRICHMENT_PROC_ID, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(3);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(4);
        Map mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document jbpm", "Upload Document enablement", "Upload Document test"});
        TaskSummary task1 = tasks.stream().filter(task -> task.getName().equals("Upload Document enablement")).findAny().get();
        HashMap<String, DocumentImpl> results = new HashMap<String, DocumentImpl>();
        DocumentImpl document = new DocumentImpl("enablement", 10L, new Date());
        document.setContent("enablement".getBytes());
        results.put("uploadedDoc", document);
        this.userTaskService.completeAutoProgress(task1.getId(), "john", results);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(4);
        mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document jbpm", "Upload Document enablement", "Upload Document test"});
        activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(3);
        this.caseService.destroyCase(caseId);
    }

    @Test
    public void testEnrichmentFlowNotValidDirectlyApproved() throws Exception {
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), ENRICHMENT_PROC_ID, data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), ENRICHMENT_PROC_ID, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(3);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(4);
        Map mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document jbpm", "Upload Document enablement", "Upload Document test"});
        TaskSummary task1 = tasks.stream().filter(task -> task.getName().equals("Upload Document jbpm")).findAny().get();
        HashMap<String, DocumentImpl> results = new HashMap<String, DocumentImpl>();
        DocumentImpl document = new DocumentImpl("jbpm", 10L, new Date());
        document.setContent("jbpm".getBytes());
        results.put("uploadedDoc", document);
        this.userTaskService.completeAutoProgress(task1.getId(), "john", results);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(3);
        mappedTasks = this.mapTaskSummaries(tasks);
        Assertions.assertThat((Map)mappedTasks).containsKeys((Object[])new String[]{"Additional Client Details", "Upload Document enablement", "Upload Document test"});
        activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(2);
        this.caseService.destroyCase(caseId);
    }
}

