/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.casemgmt.impl.util.CountDownListenerFactory;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseSLAComplianceTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseSLAComplianceTest.class);
    protected static final String USER_TASK_SLA_CASE_P_ID = "UserTaskCaseSLA";
    protected static final String USER_TASK_SLA_EXPR_CASE_P_ID = "UserTaskCaseSLAExpr";
    @Rule
    public TestName name = new TestName();

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/UserTaskCaseWithSLA.bpmn2");
        processes.add("cases/UserTaskCaseWithSLAExpr.bpmn2");
        processes.add("processes/DataVerificationProcess.bpmn2");
        processes.add("rules/sla-rules.drl");
        return processes;
    }

    @After
    public void tearDown() {
        super.tearDown();
        CountDownListenerFactory.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithSLAEscalation() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("admin", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "Case with SLA");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_CASE_P_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_CASE_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)1L, (long)cInstance.getSlaCompliance().intValue());
            List escalationTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assertions.assertThat((List)escalationTasks).hasSize(0);
            CountDownListenerFactory.getExisting("slaCompliance").waitTillCompleted();
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)3L, (long)cInstance.getSlaCompliance().intValue());
            escalationTasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assertions.assertThat((List)escalationTasks).hasSize(1);
            TaskSummary task = (TaskSummary)escalationTasks.get(0);
            Assertions.assertThat((String)task.getName()).isEqualTo("SLA violation for case " + caseId);
            Assertions.assertThat((String)task.getDescription()).isEqualTo("Service Level Agreement has been violated for case " + caseId);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithSLANotification() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("admin", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "Case with SLA");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_CASE_P_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_CASE_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)1L, (long)cInstance.getSlaCompliance().intValue());
            Collection activeNodes = this.caseRuntimeDataService.getActiveNodesForCase(caseId, new QueryContext());
            Assertions.assertThat((Iterable)activeNodes).hasSize(1);
            Iterator it = activeNodes.iterator();
            NodeInstanceDesc active = (NodeInstanceDesc)it.next();
            Assertions.assertThat((String)active.getName()).isEqualTo("Hello1");
            CountDownListenerFactory.getExisting("slaCompliance").waitTillCompleted();
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)3L, (long)cInstance.getSlaCompliance().intValue());
            activeNodes = this.caseRuntimeDataService.getActiveNodesForCase(caseId, new QueryContext());
            Assertions.assertThat((Iterable)activeNodes).hasSize(2);
            it = activeNodes.iterator();
            active = (NodeInstanceDesc)it.next();
            Assertions.assertThat((String)active.getName()).isEqualTo("Hello1");
            active = (NodeInstanceDesc)it.next();
            Assertions.assertThat((String)active.getName()).isEqualTo("[Dynamic] SLA Violation for case " + caseId);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithSLASubprocess() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("admin", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "Case with SLA");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_CASE_P_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_CASE_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)1L, (long)cInstance.getSlaCompliance().intValue());
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)1L, (long)caseProcessInstances.size());
            CountDownListenerFactory.getExisting("slaCompliance").waitTillCompleted();
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)3L, (long)cInstance.getSlaCompliance().intValue());
            caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)2L, (long)caseProcessInstances.size());
            for (ProcessInstanceDesc pi : caseProcessInstances) {
                Assertions.assertThat((String)pi.getCorrelationKey()).startsWith((CharSequence)"HR-0000000001");
            }
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithSLAForGoldCustomerByRules() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("admin", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "Case with SLA");
        data.put("CustomerType", "Gold");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_EXPR_CASE_P_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_EXPR_CASE_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)1L, (long)cInstance.getSlaCompliance().intValue());
            Object calcualtedSlaDueDate = cInstance.getCaseFile().getData("slaDueDate");
            Assert.assertNotNull((Object)calcualtedSlaDueDate);
            Assertions.assertThat((Object)calcualtedSlaDueDate).isEqualTo((Object)"1s");
            CountDownListenerFactory.getExisting("slaCompliance").waitTillCompleted();
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)3L, (long)cInstance.getSlaCompliance().intValue());
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithSLAForSilverCustomerByRules() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("admin", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "Case with SLA");
        data.put("CustomerType", "Silver");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_EXPR_CASE_P_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_EXPR_CASE_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)1L, (long)cInstance.getSlaCompliance().intValue());
            Object calcualtedSlaDueDate = cInstance.getCaseFile().getData("slaDueDate");
            Assert.assertNotNull((Object)calcualtedSlaDueDate);
            Assertions.assertThat((Object)calcualtedSlaDueDate).isEqualTo((Object)"2s");
            CountDownListenerFactory.getExisting("slaCompliance").waitTillCompleted();
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)3L, (long)cInstance.getSlaCompliance().intValue());
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithSLAForNewCustomerByRules() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("admin", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "Case with SLA");
        data.put("CustomerType", "New");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_EXPR_CASE_P_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), USER_TASK_SLA_EXPR_CASE_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((long)0L, (long)cInstance.getSlaCompliance().intValue());
            Object calcualtedSlaDueDate = cInstance.getCaseFile().getData("slaDueDate");
            Assert.assertNotNull((Object)calcualtedSlaDueDate);
            Assertions.assertThat((Object)calcualtedSlaDueDate).isEqualTo((Object)"");
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    protected List<ObjectModel> getProcessListeners() {
        List listeners = super.getProcessListeners();
        listeners.add(new ObjectModel("mvel", "org.jbpm.casemgmt.impl.util.CountDownListenerFactory.getSLA(\"slaCompliance\", 1)", new Object[0]));
        if (this.name.getMethodName().equals("testStartCaseWithSLAEscalation")) {
            listeners.add(new ObjectModel("mvel", "new org.jbpm.casemgmt.impl.wih.EscalateToAdminSLAViolationListener()", new Object[0]));
        } else if (this.name.getMethodName().equals("testStartCaseWithSLANotification")) {
            listeners.add(new ObjectModel("mvel", "new org.jbpm.casemgmt.impl.wih.NotifyOwnerSLAViolationListener()", new Object[0]));
        } else if (this.name.getMethodName().equals("testStartCaseWithSLASubprocess")) {
            listeners.add(new ObjectModel("mvel", "new org.jbpm.casemgmt.impl.wih.StartProcessSLAViolationListener(\"DataVerification\")", new Object[0]));
        }
        return listeners;
    }

    protected List<NamedObjectModel> getWorkItemHandlers() {
        List handlers = super.getWorkItemHandlers();
        handlers.add(new NamedObjectModel("mvel", "Email", "new org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler()", new Object[0]));
        return handlers;
    }
}

