/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.generator.CasePrefixCannotBeGeneratedException;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.junit.Assert;
import org.junit.Test;

public class CaseIdGeneratorTest
extends AbstractCaseServicesBaseTest {
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCaseWithCaseIdPrefix1.bpmn2");
        processes.add("cases/EmptyCaseWithCaseIdPrefix2.bpmn2");
        processes.add("cases/EmptyCaseWithCaseIdPrefix3.bpmn2");
        processes.add("cases/EmptyCaseWithCaseIdPrefix4.bpmn2");
        processes.add("cases/EmptyCase.bpmn2");
        return processes;
    }

    @Test
    public void testStartEmptyCaseWithIdCaseExpression() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("class", "test");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCaseWithIdCaseExpression", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCaseWithIdCaseExpression", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"EmptyCaseWithIdCaseExpression-0000000001", (Object)caseId);
        this.caseService.cancelCase(caseId);
    }

    @Test
    public void testStartEmptyCaseWithOverridingSequence() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("CORRELATION_KEY", "0101010101");
        data.put("IS_PREFIX_SEQUENCE", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCaseWithIdCaseExpressionAndEmptyPrefixExpression", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCaseWithIdCaseExpressionAndEmptyPrefixExpression", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"0101010101", (Object)caseId);
        this.caseService.cancelCase(caseId);
    }

    @Test
    public void testStartEmptyCaseWithIdCaseExpressionWithOverridingMetadata() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("CORRELATION_KEY", "0101010101");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCaseWithCaseIdPrefix4", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCaseWithCaseIdPrefix4", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"0101010101", (Object)caseId);
        this.caseService.cancelCase(caseId);
    }

    @Test
    public void testErrorWhenNoVariableIsSupplied() {
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCaseWithCaseIdPrefix4", data);
        Assertions.assertThatThrownBy(() -> this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCaseWithCaseIdPrefix4", caseFile)).isInstanceOf(CasePrefixCannotBeGeneratedException.class);
    }

    @Test
    public void testStartEmptyCaseImplicitVariableWithExpression() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "Test with Expressions");
        data.put("type", "type1");
        data.put("color", "blue");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCaseWithIdCaseExpressionAndPrefixExpression", data);
        String caseId1 = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCaseWithIdCaseExpressionAndPrefixExpression", caseFile);
        Assert.assertNotNull((Object)caseId1);
        Assert.assertEquals((Object)"EmptyCaseWithIdCaseExpressionAndPrefixExpression-TYPE1-0000000001", (Object)caseId1);
        this.caseService.cancelCase(caseId1);
        data.put("type", "3type");
        data.put("color", "green");
        String caseId2 = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCaseWithIdCaseExpressionAndPrefixExpression", caseFile);
        Assert.assertNotNull((Object)caseId2);
        Assert.assertEquals((Object)"EmptyCaseWithIdCaseExpressionAndPrefixExpression-3TYPE-0000000001", (Object)caseId2);
        this.caseService.cancelCase(caseId2);
        data.put("type", "type1");
        String caseId3 = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCaseWithIdCaseExpressionAndPrefixExpression", caseFile);
        Assert.assertNotNull((Object)caseId3);
        Assert.assertEquals((Object)"EmptyCaseWithIdCaseExpressionAndPrefixExpression-TYPE1-0000000002", (Object)caseId3);
        this.caseService.cancelCase(caseId3);
    }
}

