/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.core.ClassObjectFilter;
import org.jbpm.casemgmt.api.AdHocFragmentNotFoundException;
import org.jbpm.casemgmt.api.CaseActiveException;
import org.jbpm.casemgmt.api.CaseDefinitionNotFoundException;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.api.model.instance.CommentSortBy;
import org.jbpm.casemgmt.impl.command.AddDataCaseFileInstanceCommand;
import org.jbpm.casemgmt.impl.command.AddDynamicProcessCommand;
import org.jbpm.casemgmt.impl.command.AddDynamicProcessToStageCommand;
import org.jbpm.casemgmt.impl.command.AddDynamicTaskCommand;
import org.jbpm.casemgmt.impl.command.AddDynamicTaskToStageCommand;
import org.jbpm.casemgmt.impl.command.CancelCaseCommand;
import org.jbpm.casemgmt.impl.command.CaseCommentCommand;
import org.jbpm.casemgmt.impl.command.CloseCaseCommand;
import org.jbpm.casemgmt.impl.command.ModifyRoleAssignmentCommand;
import org.jbpm.casemgmt.impl.command.RemoveDataCaseFileInstanceCommand;
import org.jbpm.casemgmt.impl.command.ReopenCaseCommand;
import org.jbpm.casemgmt.impl.command.StartCaseCommand;
import org.jbpm.casemgmt.impl.dynamic.HumanTaskSpecification;
import org.jbpm.casemgmt.impl.dynamic.WorkItemTaskSpecification;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.casemgmt.impl.model.instance.CaseInstanceImpl;
import org.jbpm.runtime.manager.impl.PerCaseRuntimeManager;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.KieInternalServices;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.TaskModelFactory;
import org.kie.internal.task.api.TaskModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseServiceImpl
implements CaseService {
    private static final Logger logger = LoggerFactory.getLogger(CaseServiceImpl.class);
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private KieCommands commandsFactory = KieServices.Factory.get().getCommands();
    private TaskModelFactory factory = TaskModelProvider.getFactory();
    private CaseIdGenerator caseIdGenerator;
    private ProcessService processService;
    private RuntimeDataService runtimeDataService;
    private DeploymentService deploymentService;
    private CaseRuntimeDataService caseRuntimeDataService;
    private TransactionalCommandService commandService;
    private AuthorizationManager authorizationManager;
    private IdentityProvider identityProvider;
    private CaseEventSupport emptyCaseEventSupport = new CaseEventSupport(null, Collections.emptyList());

    public CaseServiceImpl() {
        ServiceRegistry.get().register(CaseService.class.getSimpleName(), (Object)this);
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setCaseRuntimeDataService(CaseRuntimeDataService caseRuntimeDataService) {
        this.caseRuntimeDataService = caseRuntimeDataService;
    }

    public void setCaseIdGenerator(CaseIdGenerator caseIdGenerator) {
        this.caseIdGenerator = caseIdGenerator;
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
        this.emptyCaseEventSupport = new CaseEventSupport(identityProvider, Collections.emptyList());
    }

    public String startCase(String deploymentId, String caseDefinitionId) {
        return this.startCase(deploymentId, caseDefinitionId, null);
    }

    public String startCase(String deploymentId, String caseDefinitionId, CaseFileInstance caseFile) {
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(deploymentId, caseDefinitionId);
        if (caseDef == null) {
            throw new CaseNotFoundException("Case definition " + caseDefinitionId + " not found");
        }
        String caseId = this.caseIdGenerator.generate(caseDef.getIdentifierPrefix(), caseFile == null ? new HashMap() : caseFile.getData());
        logger.debug("Generated case id {} for case definition id {}", (Object)caseId, (Object)caseDefinitionId);
        if (caseFile == null) {
            caseFile = new CaseFileInstanceImpl(caseId, caseDefinitionId);
            ((CaseFileInstanceImpl)caseFile).setupRoles(caseDef.getCaseRoles());
            logger.debug("CaseFile was not given, creating new empty one.");
        } else {
            ((CaseFileInstanceImpl)caseFile).setCaseId(caseId);
            logger.debug("CaseFile {} was given, associating it with case {}", (Object)caseFile, (Object)caseId);
        }
        boolean hasOwner = ((CaseFileInstanceImpl)caseFile).getAssignments().stream().anyMatch(role -> role.getRoleName().equals("owner"));
        if (!hasOwner) {
            ((CaseFileInstanceImpl)caseFile).assignOwner(this.newUser(this.identityProvider.getName()));
        }
        this.processService.execute(deploymentId, (Context)CaseContext.get((String)caseId), (Command)new StartCaseCommand(this.identityProvider, caseId, deploymentId, caseDefinitionId, caseFile, this.processService));
        return caseId;
    }

    public CaseFileInstance getCaseFileInstance(String caseId) throws CaseNotFoundException {
        this.authorizationManager.checkAuthorization(caseId);
        ProcessInstanceDesc pi = this.verifyCaseIdExisted(caseId);
        return this.internalGetCaseFileInstance(caseId, pi.getDeploymentId());
    }

    public CaseInstance getCaseInstance(String caseId) throws CaseNotFoundException {
        return this.getCaseInstance(caseId, false, false, false, false);
    }

    public CaseInstance getCaseInstance(String caseId, boolean withData, boolean withRoles, boolean withMilestones, boolean withStages) throws CaseNotFoundException {
        this.authorizationManager.checkAuthorization(caseId);
        CaseInstanceImpl caseInstance = (CaseInstanceImpl)this.caseRuntimeDataService.getCaseInstanceById(caseId);
        if (caseInstance.getStatus().equals(1)) {
            if (withData) {
                CaseFileInstance caseFile = this.internalGetCaseFileInstance(caseId, caseInstance.getDeploymentId());
                caseInstance.setCaseFile(caseFile);
            }
            if (withMilestones) {
                Collection milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, false, (QueryContext)new org.kie.internal.query.QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
                caseInstance.setCaseMilestones(milestones);
            }
            if (withRoles) {
                Collection<CaseRoleInstance> roles = this.getCaseRoleAssignments(caseId);
                caseInstance.setCaseRoles(roles);
            }
            if (withStages) {
                Collection stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, (QueryContext)new org.kie.internal.query.QueryContext(Integer.valueOf(0), Integer.valueOf(100)));
                caseInstance.setCaseStages(stages);
            }
        }
        return caseInstance;
    }

    public void closeCase(String caseId, String comment) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.CLOSE_CASE);
        logger.debug("About to close case {} with comment {}", (Object)caseId, (Object)comment);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CloseCaseCommand(this.identityProvider, pi.getDeploymentId(), caseId, comment, this.processService, this.runtimeDataService));
    }

    public void cancelCase(String caseId) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.CANCEL_CASE);
        logger.debug("About to abort case {}", (Object)caseId);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CancelCaseCommand(this.identityProvider, caseId, this.processService, this.runtimeDataService, false));
    }

    public void destroyCase(String caseId) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.DESTROY_CASE);
        logger.debug("About to destroy permanently case {}", (Object)caseId);
        ProcessInstanceDesc pi = this.verifyCaseIdExisted(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CancelCaseCommand(this.identityProvider, caseId, this.processService, this.runtimeDataService, true));
    }

    public void reopenCase(String caseId, String deploymentId, String caseDefinitionId) throws CaseNotFoundException {
        this.reopenCase(caseId, deploymentId, caseDefinitionId, new HashMap<String, Object>());
    }

    public void reopenCase(String caseId, String deploymentId, String caseDefinitionId, Map<String, Object> data) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.REOPEN_CASE);
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi != null) {
            throw new CaseActiveException("Case with id " + caseId + " is still active and cannot be reopened");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId);
        params.put("maxResults", 1);
        List caseIdMapping = (List)this.commandService.execute((Command)new QueryNameCommand("findCaseIdContextMapping", params));
        if (caseIdMapping.isEmpty()) {
            throw new CaseNotFoundException("Case with id " + caseId + " was not found");
        }
        logger.debug("About to reopen case {} by starting process instance {} from deployment {} with additional data {}", new Object[]{caseId, caseDefinitionId, deploymentId, data});
        this.processService.execute(deploymentId, (Context)CaseContext.get((String)caseId), (Command)new ReopenCaseCommand(this.identityProvider, caseId, deploymentId, caseDefinitionId, data, this.processService));
    }

    public void addDynamicTask(String caseId, TaskSpecification taskSpecification) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_TASK_TO_CASE);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDynamicTaskCommand(this.identityProvider, caseId, taskSpecification.getNodeType(), pi.getId(), taskSpecification.getParameters()));
    }

    public void addDynamicTask(Long processInstanceId, TaskSpecification taskSpecification) throws ProcessInstanceNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + processInstanceId + " or it's not active anymore");
        }
        String caseId = pi.getCorrelationKey();
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_TASK_TO_CASE);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new AddDynamicTaskCommand(this.identityProvider, caseId, taskSpecification.getNodeType(), pi.getId(), taskSpecification.getParameters()));
    }

    public void addDynamicTaskToStage(String caseId, String stageId, TaskSpecification taskSpecification) throws CaseNotFoundException, StageNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_TASK_TO_CASE);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + pi.getId() + " or it's not active anymore");
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDynamicTaskToStageCommand(this.identityProvider, caseId, taskSpecification.getNodeType(), pi.getId(), stageId, taskSpecification.getParameters()));
    }

    public void addDynamicTaskToStage(Long processInstanceId, String stageId, TaskSpecification taskSpecification) throws CaseNotFoundException, StageNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + processInstanceId + " or it's not active anymore");
        }
        String caseId = pi.getCorrelationKey();
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_TASK_TO_CASE);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new AddDynamicTaskToStageCommand(this.identityProvider, caseId, taskSpecification.getNodeType(), pi.getId(), stageId, taskSpecification.getParameters()));
    }

    public Long addDynamicSubprocess(String caseId, String processId, Map<String, Object> parameters) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_PROCESS_TO_CASE);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + pi.getId() + " or it's not active anymore");
        }
        return (Long)this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDynamicProcessCommand(this.identityProvider, caseId, pi.getId(), processId, parameters));
    }

    public Long addDynamicSubprocess(Long processInstanceId, String processId, Map<String, Object> parameters) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + processInstanceId + " or it's not active anymore");
        }
        String caseId = pi.getCorrelationKey();
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_PROCESS_TO_CASE);
        return (Long)this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new AddDynamicProcessCommand(this.identityProvider, caseId, pi.getId(), processId, parameters));
    }

    public Long addDynamicSubprocessToStage(String caseId, String stageId, String processId, Map<String, Object> parameters) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_PROCESS_TO_CASE);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        return (Long)this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDynamicProcessToStageCommand(this.identityProvider, caseId, pi.getId(), stageId, processId, parameters));
    }

    public Long addDynamicSubprocessToStage(Long processInstanceId, String stageId, String processId, Map<String, Object> parameters) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (pi == null || !pi.getState().equals(1)) {
            throw new ProcessInstanceNotFoundException("No process instance found with id " + processInstanceId + " or it's not active anymore");
        }
        String caseId = pi.getCorrelationKey();
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_PROCESS_TO_CASE);
        return (Long)this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new AddDynamicProcessToStageCommand(this.identityProvider, caseId, pi.getId(), stageId, processId, parameters));
    }

    public void triggerAdHocFragment(String caseId, String fragmentName, Object data) throws CaseNotFoundException {
        this.authorizationManager.checkAuthorization(caseId);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.triggerAdHocFragment(pi.getId(), fragmentName, data);
    }

    public void triggerAdHocFragment(Long processInstanceId, String fragmentName, Object data) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        this.internalTriggerAdHocFragment(pi, fragmentName, data);
    }

    public void addDataToCaseFile(String caseId, String name, Object value, String ... restrictedTo) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_DATA);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        List<String> accessRestriction = null;
        if (restrictedTo != null) {
            accessRestriction = Arrays.asList(restrictedTo);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(name, value);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDataCaseFileInstanceCommand(this.identityProvider, parameters, accessRestriction, this.authorizationManager));
    }

    public void addDataToCaseFile(String caseId, Map<String, Object> data, String ... restrictedTo) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.ADD_DATA);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        List<String> accessRestriction = null;
        if (restrictedTo != null) {
            accessRestriction = Arrays.asList(restrictedTo);
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new AddDataCaseFileInstanceCommand(this.identityProvider, data, accessRestriction, this.authorizationManager));
    }

    public void removeDataFromCaseFile(String caseId, String name) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.REMOVE_DATA);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new RemoveDataCaseFileInstanceCommand(this.identityProvider, Arrays.asList(name), this.authorizationManager));
    }

    public void removeDataFromCaseFile(String caseId, List<String> variableNames) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.REMOVE_DATA);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new RemoveDataCaseFileInstanceCommand(this.identityProvider, variableNames, this.authorizationManager));
    }

    public void assignToCaseRole(String caseId, String role, OrganizationalEntity entity) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.MODIFY_ROLE_ASSIGNMENT);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new ModifyRoleAssignmentCommand(this.identityProvider, role, entity, true));
    }

    public void removeFromCaseRole(String caseId, String role, OrganizationalEntity entity) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.MODIFY_ROLE_ASSIGNMENT);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new ModifyRoleAssignmentCommand(this.identityProvider, role, entity, false));
    }

    public Collection<CaseRoleInstance> getCaseRoleAssignments(String caseId) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.MODIFY_ROLE_ASSIGNMENT);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        CaseFileInstance caseFile = this.internalGetCaseFileInstance(caseId, pi.getDeploymentId());
        return ((CaseFileInstanceImpl)caseFile).getAssignments();
    }

    public Collection<CommentInstance> getCaseComments(String caseId, QueryContext queryContext) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.MODIFY_COMMENT);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        CaseFileInstance caseFile = this.internalGetCaseFileInstance(caseId, pi.getDeploymentId());
        List<Object> caseComments = new ArrayList<CommentInstance>(((CaseFileInstanceImpl)caseFile).getComments());
        caseComments = this.authorizationManager.filterByCommentAuthorization(caseId, caseFile, caseComments);
        int caseCommentsSize = caseComments.size();
        int offset = queryContext.getOffset();
        int pageSize = queryContext.getCount();
        int pageIndex = (caseCommentsSize + pageSize - 1) / pageSize;
        if (caseCommentsSize < pageSize) {
            return caseComments;
        }
        if (pageIndex == offset / pageSize + 1) {
            return caseComments.subList(offset, caseCommentsSize);
        }
        return caseComments.subList(offset, offset + pageSize);
    }

    public Collection<CommentInstance> getCaseComments(String caseId, CommentSortBy sortBy, QueryContext queryContext) throws CaseNotFoundException {
        this.authorizationManager.checkAuthorization(caseId);
        Collection<CommentInstance> comments = this.getCaseComments(caseId, queryContext);
        return comments.stream().sorted((o1, o2) -> {
            int result = 0;
            switch (sortBy) {
                case Date: {
                    result = o1.getCreatedAt().compareTo(o2.getCreatedAt());
                    break;
                }
                case Author: {
                    result = o1.getAuthor().compareTo(o2.getAuthor());
                }
            }
            return result;
        }).collect(Collectors.toList());
    }

    public void addCaseComment(String caseId, String author, String comment, String ... restrictedTo) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.MODIFY_COMMENT);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        List<String> accessRestriction = null;
        if (restrictedTo != null && restrictedTo.length > 0) {
            accessRestriction = Arrays.asList(restrictedTo);
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CaseCommentCommand(this.identityProvider, author, comment, accessRestriction));
    }

    public void updateCaseComment(String caseId, String commentId, String author, String text, String ... restrictedTo) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.MODIFY_COMMENT);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        List<String> accessRestriction = null;
        if (restrictedTo != null && restrictedTo.length > 0) {
            accessRestriction = Arrays.asList(restrictedTo);
        }
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CaseCommentCommand(this.identityProvider, commentId, author, text, accessRestriction, this.authorizationManager));
    }

    public void removeCaseComment(String caseId, String commentId) throws CaseNotFoundException {
        this.authorizationManager.checkOperationAuthorization(caseId, AuthorizationManager.ProtectedOperation.MODIFY_COMMENT);
        ProcessInstanceDesc pi = this.verifyCaseIdExists(caseId);
        this.processService.execute(pi.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)pi.getId()), (Command)new CaseCommentCommand(this.identityProvider, commentId, this.authorizationManager));
    }

    public CaseFileInstance newCaseFileInstance(String deploymentId, String caseDefinition, Map<String, Object> data) {
        CaseDefinition def = this.caseRuntimeDataService.getCase(deploymentId, caseDefinition);
        if (def == null) {
            throw new CaseDefinitionNotFoundException("Case definition " + caseDefinition + " does not exist in deployment " + deploymentId);
        }
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl(caseDefinition, data);
        caseFile.setupRoles(def.getCaseRoles());
        caseFile.setAccessRestrictions(def.getDataAccessRestrictions());
        return caseFile;
    }

    public CaseFileInstance newCaseFileInstanceWithRestrictions(String deploymentId, String caseDefinition, Map<String, Object> data, Map<String, List<String>> accessRestrictions) {
        CaseDefinition def = this.caseRuntimeDataService.getCase(deploymentId, caseDefinition);
        if (def == null) {
            throw new CaseDefinitionNotFoundException("Case definition " + caseDefinition + " does not exist in deployment " + deploymentId);
        }
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl(caseDefinition, data);
        caseFile.setupRoles(def.getCaseRoles());
        Map combinedAccessRestrictions = def.getDataAccessRestrictions();
        if (accessRestrictions != null) {
            combinedAccessRestrictions.putAll(accessRestrictions);
        }
        caseFile.setAccessRestrictions(combinedAccessRestrictions);
        return caseFile;
    }

    public CaseFileInstance newCaseFileInstance(String deploymentId, String caseDefinition, Map<String, Object> data, Map<String, OrganizationalEntity> rolesAssignment) {
        CaseDefinition def = this.caseRuntimeDataService.getCase(deploymentId, caseDefinition);
        if (def == null) {
            throw new CaseDefinitionNotFoundException("Case definition " + caseDefinition + " does not exist in deployment " + deploymentId);
        }
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl(caseDefinition, data);
        caseFile.setupRoles(def.getCaseRoles());
        caseFile.setAccessRestrictions(def.getDataAccessRestrictions());
        rolesAssignment.entrySet().stream().forEach(entry -> caseFile.assign((String)entry.getKey(), (OrganizationalEntity)entry.getValue()));
        return caseFile;
    }

    public CaseFileInstance newCaseFileInstanceWithRestrictions(String deploymentId, String caseDefinition, Map<String, Object> data, Map<String, OrganizationalEntity> rolesAssignment, Map<String, List<String>> accessRestrictions) {
        CaseDefinition def = this.caseRuntimeDataService.getCase(deploymentId, caseDefinition);
        if (def == null) {
            throw new CaseDefinitionNotFoundException("Case definition " + caseDefinition + " does not exist in deployment " + deploymentId);
        }
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl(caseDefinition, data);
        caseFile.setupRoles(def.getCaseRoles());
        Map combinedAccessRestrictions = def.getDataAccessRestrictions();
        if (accessRestrictions != null) {
            combinedAccessRestrictions.putAll(accessRestrictions);
        }
        caseFile.setAccessRestrictions(combinedAccessRestrictions);
        rolesAssignment.entrySet().stream().forEach(entry -> caseFile.assign((String)entry.getKey(), (OrganizationalEntity)entry.getValue()));
        return caseFile;
    }

    public TaskSpecification newHumanTaskSpec(String taskName, String description, String actorIds, String groupIds, Map<String, Object> parameters) {
        return new HumanTaskSpecification(taskName, actorIds, groupIds, description, parameters);
    }

    public TaskSpecification newTaskSpec(String nodeType, String nodeName, Map<String, Object> parameters) {
        return new WorkItemTaskSpecification(nodeType, nodeName, parameters);
    }

    public User newUser(String userId) {
        return this.factory.newUser(userId);
    }

    public Group newGroup(String groupId) {
        return this.factory.newGroup(groupId);
    }

    protected CaseFileInstance internalGetCaseFileInstance(String caseId, String deploymentId) {
        logger.debug("Retrieving case file from working memory for case " + caseId);
        Collection caseFiles = (Collection)this.processService.execute(deploymentId, (Context)CaseContext.get((String)caseId), this.commandsFactory.newGetObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class)));
        if (caseFiles.size() == 0) {
            throw new CaseNotFoundException("Case with id " + caseId + " was not found");
        }
        if (caseFiles.size() == 1) {
            CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
            logger.debug("Single case file {} found in working memory", (Object)caseFile);
            Map filteredData = this.authorizationManager.filterByDataAuthorization(caseId, caseFile, caseFile.getData());
            ((CaseFileInstanceImpl)caseFile).setData(filteredData);
            return caseFile;
        }
        logger.warn("Multiple case files found in working memory (most likely not using PER_CASE strategy), trying to filter out...");
        CaseFileInstance caseFile = caseFiles.stream().filter(cf -> cf.getCaseId().equals(caseId)).findFirst().orElse(null);
        logger.warn("Case file {} after filtering {}", (Object)caseFile, (Object)(caseFile == null ? "not found" : "found"));
        if (caseFile != null) {
            Map filteredData = this.authorizationManager.filterByDataAuthorization(caseId, caseFile, caseFile.getData());
            ((CaseFileInstanceImpl)caseFile).setData(filteredData);
        }
        return caseFile;
    }

    protected void internalTriggerAdHocFragment(ProcessInstanceDesc pi, String fragmentName, Object data) throws CaseNotFoundException {
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(pi.getDeploymentId(), pi.getProcessId());
        ArrayList allFragments = new ArrayList();
        if (caseDef.getAdHocFragments() != null) {
            allFragments.addAll(caseDef.getAdHocFragments());
        }
        caseDef.getCaseStages().forEach(stage -> {
            if (stage.getAdHocFragments() != null) {
                allFragments.addAll(stage.getAdHocFragments());
            }
        });
        allFragments.stream().filter(fragment -> fragment.getName().equals(fragmentName)).findFirst().orElseThrow(() -> new AdHocFragmentNotFoundException("AdHoc fragment '" + fragmentName + "' not found in case " + pi.getCorrelationKey()));
        this.processService.signalProcessInstance(pi.getId(), fragmentName, data);
    }

    protected ProcessInstanceDesc verifyCaseIdExists(String caseId) throws CaseNotFoundException {
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId));
        if (pi == null) {
            throw new CaseNotFoundException("Case with id " + caseId + " was not found");
        }
        return pi;
    }

    protected ProcessInstanceDesc verifyCaseIdExisted(String caseId) throws CaseNotFoundException {
        Collection instances = this.runtimeDataService.getProcessInstancesByCorrelationKey(this.correlationKeyFactory.newCorrelationKey(caseId), new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
        if (instances.isEmpty()) {
            throw new CaseNotFoundException("Case with id " + caseId + " was not found");
        }
        return (ProcessInstanceDesc)instances.iterator().next();
    }

    protected CaseEventSupport getCaseEventSupport(String deploymentId) {
        CaseEventSupport caseEventSupport;
        RuntimeManager runtimeManager = this.deploymentService.getRuntimeManager(deploymentId);
        if (runtimeManager instanceof PerCaseRuntimeManager && (caseEventSupport = (CaseEventSupport)((PerCaseRuntimeManager)runtimeManager).getCaseEventSupport()) != null) {
            return caseEventSupport;
        }
        return this.emptyCaseEventSupport;
    }

    protected boolean isEmpty(Collection<?> data) {
        return data == null || data.isEmpty();
    }
}

