/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.demo.insurance.ClaimReport;
import org.jbpm.casemgmt.demo.insurance.PropertyDamageReport;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.casemgmt.impl.util.CountDownListenerFactory;
import org.jbpm.document.Document;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.runtime.conf.ObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CarInsuranceClaimCaseTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CarInsuranceClaimCaseTest.class);
    private static final String CAR_INSURANCE_CLAIM_PROC_ID = "insurance-claims.CarInsuranceClaimCase";
    protected static final String CAR_INS_CASE_ID = "CAR_INS-0000000001";

    @Override
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("org/jbpm/casemgmt/demo/insurance/CarInsuranceClaimCase.bpmn2");
        processes.add("org/jbpm/casemgmt/demo/insurance/insurance-rules.drl");
        return processes;
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        CountDownListenerFactory.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCarInsuranceClaimCase() {
        String caseId = this.startAndAssertCaseInstance(this.deploymentUnit.getIdentifier(), "john", "mary");
        try {
            this.assertCaseInstance(this.deploymentUnit.getIdentifier(), CAR_INS_CASE_ID);
            this.assertBuildClaimReportStage();
            long taskId = this.assertBuildClaimReportAvailableForBothRoles();
            this.provideAndAssertClaimReport(taskId);
            taskId = this.assertPropertyDamageReportAvailableForBothRoles();
            this.provideAndAssertPropertyDamageReport(taskId);
            this.caseService.addDataToCaseFile(CAR_INS_CASE_ID, "claimReportDone", (Object)true, new String[0]);
            this.assertClaimAssesmentStage();
            this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Calculate claim", null);
            this.assertAndAcceptClaimOffer();
            Collection caseProcesInstances = this.caseRuntimeDataService.getProcessInstancesForCase(CAR_INS_CASE_ID, Arrays.asList(1), new QueryContext());
            Assert.assertEquals((long)0L, (long)caseProcesInstances.size());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCarInsuranceClaimCaseWithPoliceReport() {
        String caseId = this.startAndAssertCaseInstance(this.deploymentUnit.getIdentifier(), "john", "mary");
        try {
            this.assertCaseInstance(this.deploymentUnit.getIdentifier(), CAR_INS_CASE_ID);
            this.assertBuildClaimReportStage();
            long taskId = this.assertBuildClaimReportAvailableForBothRoles();
            this.provideAndAssertClaimReport(taskId);
            taskId = this.assertPropertyDamageReportAvailableForBothRoles();
            this.attachAndAssertPoliceReport();
            this.provideAndAssertPropertyDamageReport(taskId);
            this.caseService.addDataToCaseFile(CAR_INS_CASE_ID, "claimReportDone", (Object)true, new String[0]);
            this.assertClaimAssesmentStage();
            this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Calculate claim", null);
            this.assertAndAcceptClaimOffer();
            Collection caseProcesInstances = this.caseRuntimeDataService.getProcessInstancesForCase(CAR_INS_CASE_ID, Arrays.asList(1), new QueryContext());
            Assert.assertEquals((long)0L, (long)caseProcesInstances.size());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCarInsuranceClaimCaseWithContactByInsured() {
        String caseId = this.startAndAssertCaseInstance(this.deploymentUnit.getIdentifier(), "john", "mary");
        try {
            this.assertCaseInstance(this.deploymentUnit.getIdentifier(), CAR_INS_CASE_ID);
            this.assertBuildClaimReportStage();
            long taskId = this.assertBuildClaimReportAvailableForBothRoles();
            this.provideAndAssertClaimReport(taskId);
            taskId = this.assertPropertyDamageReportAvailableForBothRoles();
            this.provideAndAssertPropertyDamageReport(taskId);
            this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Contacted by insured", null);
            this.attachAndAssertPoliceReport(false, null);
            this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Contacted by insured", null);
            this.attachAndAssertPoliceReport(true, "2s");
            this.caseService.addDataToCaseFile(CAR_INS_CASE_ID, "claimReportDone", (Object)true, new String[0]);
            this.assertClaimAssesmentStage();
            this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Calculate claim", null);
            this.assertAndAcceptClaimOffer();
            Collection caseProcesInstances = this.caseRuntimeDataService.getProcessInstancesForCase(CAR_INS_CASE_ID, Arrays.asList(1), new QueryContext());
            Assert.assertEquals((long)0L, (long)caseProcesInstances.size());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCarInsuranceClaimCaseWithNegotiations() {
        String caseId = this.startAndAssertCaseInstance(this.deploymentUnit.getIdentifier(), "john", "mary");
        try {
            this.assertCaseInstance(this.deploymentUnit.getIdentifier(), CAR_INS_CASE_ID);
            this.assertBuildClaimReportStage();
            long taskId = this.assertBuildClaimReportAvailableForBothRoles();
            this.provideAndAssertClaimReport(taskId);
            taskId = this.assertPropertyDamageReportAvailableForBothRoles();
            this.provideAndAssertPropertyDamageReport(taskId);
            this.caseService.addDataToCaseFile(CAR_INS_CASE_ID, "claimReportDone", (Object)true, new String[0]);
            this.assertClaimAssesmentStage();
            this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Calculate claim", null);
            this.assertAndNegotiateClaimOffer(3);
            Collection caseProcesInstances = this.caseRuntimeDataService.getProcessInstancesForCase(CAR_INS_CASE_ID, Arrays.asList(1), new QueryContext());
            Assert.assertEquals((long)0L, (long)caseProcesInstances.size());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCarInsuranceClaimCaseWithAssessorInvolved() {
        String caseId = this.startAndAssertCaseInstance(this.deploymentUnit.getIdentifier(), "john", "mary");
        try {
            this.assertCaseInstance(this.deploymentUnit.getIdentifier(), CAR_INS_CASE_ID);
            this.assertBuildClaimReportStage();
            this.caseService.assignToCaseRole(CAR_INS_CASE_ID, "assessor", (OrganizationalEntity)new UserImpl("krisv"));
            long taskId = this.assertBuildClaimReportAvailableForBothRoles();
            this.provideAndAssertClaimReport(taskId);
            taskId = this.assertPropertyDamageReportAvailableForBothRoles();
            this.provideAndAssertPropertyDamageReport(taskId);
            this.caseService.addDataToCaseFile(CAR_INS_CASE_ID, "claimReportDone", (Object)true, new String[0]);
            this.assertClaimAssesmentStage();
            this.assertAndRunClaimAssessment();
            this.assertAndAcceptClaimOffer();
            Collection caseProcesInstances = this.caseRuntimeDataService.getProcessInstancesForCase(CAR_INS_CASE_ID, Arrays.asList(1), new QueryContext());
            Assert.assertEquals((long)0L, (long)caseProcesInstances.size());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCarInsuranceClaimCaseWithExtraTaskFromRules() {
        String caseId = this.startAndAssertCaseInstance(this.deploymentUnit.getIdentifier(), "john", "mary");
        try {
            this.assertCaseInstance(this.deploymentUnit.getIdentifier(), CAR_INS_CASE_ID);
            this.assertBuildClaimReportStage();
            long taskId = this.assertBuildClaimReportAvailableForBothRoles();
            this.provideAndAssertClaimReport(taskId);
            taskId = this.assertPropertyDamageReportAvailableForBothRoles();
            this.provideAndAssertPropertyDamageReport(taskId);
            this.caseService.addDataToCaseFile(CAR_INS_CASE_ID, "claimReportDone", (Object)true, new String[0]);
            this.assertClaimAssesmentStage();
            this.caseService.addDataToCaseFile(CAR_INS_CASE_ID, "decision", (Object)"AskForDetails", new String[0]);
            this.assertAndProvideAdditionalDetails();
            this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Calculate claim", null);
            this.assertAndAcceptClaimOffer();
            Collection caseProcesInstances = this.caseRuntimeDataService.getProcessInstancesForCase(CAR_INS_CASE_ID, Arrays.asList(1), new QueryContext());
            Assert.assertEquals((long)0L, (long)caseProcesInstances.size());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Override
    protected void assertComment(CommentInstance comment, String author, String content) {
        Assert.assertNotNull((Object)comment);
        Assert.assertEquals((Object)author, (Object)comment.getAuthor());
        Assert.assertEquals((Object)content, (Object)comment.getComment());
    }

    @Override
    protected void assertTask(TaskSummary task, String actor, String name, Status status) {
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)name, (Object)task.getName());
        Assert.assertEquals((Object)actor, (Object)task.getActualOwnerId());
        Assert.assertEquals((Object)status, (Object)task.getStatus());
    }

    protected String startAndAssertCaseInstance(String deploymentId, String insured, String insuranceRepresentative) {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("insured", new UserImpl(insured));
        roleAssignments.put("insuranceRepresentative", new UserImpl(insuranceRepresentative));
        roleAssignments.put("assessor", new UserImpl("krisv"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentId, CAR_INSURANCE_CLAIM_PROC_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(deploymentId, CAR_INSURANCE_CLAIM_PROC_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)CAR_INS_CASE_ID, (Object)caseId);
        return caseId;
    }

    @Override
    protected void assertCaseInstance(String deploymentId, String caseId) {
        CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
        Assert.assertNotNull((Object)cInstance);
        Assert.assertEquals((Object)caseId, (Object)cInstance.getCaseId());
        Assert.assertEquals((Object)deploymentId, (Object)cInstance.getDeploymentId());
    }

    protected void assertBuildClaimReportStage() {
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(CAR_INS_CASE_ID, true, new QueryContext());
        Assert.assertEquals((long)1L, (long)activeStages.size());
        CaseStageInstance stage = (CaseStageInstance)activeStages.iterator().next();
        Assert.assertEquals((Object)"Build claim report", (Object)stage.getName());
    }

    protected void assertClaimAssesmentStage() {
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(CAR_INS_CASE_ID, true, new QueryContext());
        Assert.assertEquals((long)1L, (long)activeStages.size());
        CaseStageInstance stage = (CaseStageInstance)activeStages.iterator().next();
        Assert.assertEquals((Object)"Claim assesment", (Object)stage.getName());
    }

    protected long assertBuildClaimReportAvailableForBothRoles() {
        return this.assertTasksForBothRoles("Provide accident information", "john", "mary", Status.Ready);
    }

    protected long assertPropertyDamageReportAvailableForBothRoles() {
        return this.assertTasksForBothRoles("File property damage claim", "john", "mary", Status.Ready);
    }

    protected long assertTasksForBothRoles(String taskName, String actor1, String actor2, Status status) {
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner(actor1, new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.assertTask((TaskSummary)tasks.get(0), null, taskName, status);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner(actor2, new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.assertTask((TaskSummary)tasks.get(0), null, taskName, status);
        return ((TaskSummary)tasks.get(0)).getId();
    }

    protected void provideAndAssertClaimReport(Long taskId) {
        ClaimReport claimReport = new ClaimReport();
        claimReport.setName("John Doe");
        claimReport.setAddress("Main street, NY");
        claimReport.setAccidentDescription("It happened so sudden...");
        claimReport.setAccidentDate(new Date());
        HashMap<String, ClaimReport> params = new HashMap<String, ClaimReport>();
        params.put("claimReport_", claimReport);
        this.userTaskService.completeAutoProgress(taskId, "john", params);
        CaseFileInstance caseFile = this.caseService.getCaseFileInstance(CAR_INS_CASE_ID);
        Assert.assertNotNull((Object)caseFile);
        ClaimReport caseClaimReport = (ClaimReport)caseFile.getData("claimReport");
        Assert.assertNotNull((Object)caseClaimReport);
    }

    protected void provideAndAssertPropertyDamageReport(Long taskId) {
        PropertyDamageReport damageReport = new PropertyDamageReport("Car is completely destroyed", 1000.0);
        HashMap<String, PropertyDamageReport> params = new HashMap<String, PropertyDamageReport>();
        params.put("propertyDamageReport_", damageReport);
        this.userTaskService.completeAutoProgress(taskId, "john", params);
        CaseFileInstance caseFile = this.caseService.getCaseFileInstance(CAR_INS_CASE_ID);
        Assert.assertNotNull((Object)caseFile);
        PropertyDamageReport casePropertyDamageReport = (PropertyDamageReport)caseFile.getData("propertyDamageReport");
        Assert.assertNotNull((Object)casePropertyDamageReport);
    }

    protected void assertAndAcceptClaimOffer() {
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.assertTask((TaskSummary)tasks.get(0), "john", "Present calculated claim", Status.Reserved);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("accepted", true);
        this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
    }

    protected void attachAndAssertPoliceReport() {
        this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Submit police report", null);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.assertTask((TaskSummary)tasks.get(0), null, "Submit police report", Status.Ready);
        this.assertTask((TaskSummary)tasks.get(1), null, "File property damage claim", Status.Ready);
        byte[] docContent = "police report content".getBytes();
        DocumentImpl document = new DocumentImpl(UUID.randomUUID().toString(), "car-accident-police-report.txt", (long)docContent.length, new Date());
        document.setContent(docContent);
        HashMap<String, DocumentImpl> params = new HashMap<String, DocumentImpl>();
        params.put("policeReport_", document);
        this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
        CaseFileInstance caseFile = this.caseService.getCaseFileInstance(CAR_INS_CASE_ID);
        Assert.assertNotNull((Object)caseFile);
        Document policeReport = (Document)caseFile.getData("policeReport");
        Assert.assertNotNull((Object)policeReport);
        Assert.assertEquals((Object)"car-accident-police-report.txt", (Object)policeReport.getName());
    }

    protected void attachAndAssertPoliceReport(boolean callback, String callbackAfter) {
        List tasks = this.runtimeDataService.getTasksOwned("mary", new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.assertTask((TaskSummary)tasks.get(0), "mary", "Contacted by insured", Status.Reserved);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback_", callback);
        if (callback) {
            params.put("callbackAfter_", callbackAfter);
        }
        this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "mary", params);
        if (callback) {
            CountDownListenerFactory.getExisting("carInsuranceCase").waitTillCompleted();
            tasks = this.runtimeDataService.getTasksOwned("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "mary", "Requested callback", Status.Reserved);
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "mary", null);
        }
    }

    protected void assertAndNegotiateClaimOffer(int numberOfNegotiations) {
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.assertTask((TaskSummary)tasks.get(0), "john", "Present calculated claim", Status.Reserved);
        HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
        params.put("accepted", Boolean.valueOf(false));
        this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(CAR_INS_CASE_ID, true, new QueryContext());
        Assert.assertEquals((long)1L, (long)activeStages.size());
        CaseStageInstance stage = (CaseStageInstance)activeStages.iterator().next();
        Assert.assertEquals((Object)"Escalate rejected claim", (Object)stage.getName());
        while (numberOfNegotiations > 0) {
            params.clear();
            params.put("Offer", Integer.valueOf(1000));
            this.caseService.triggerAdHocFragment(CAR_INS_CASE_ID, "Negotiation meeting", params);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), null, "Negotiation meeting", Status.Ready);
            boolean accepted = false;
            if (numberOfNegotiations == 1) {
                accepted = true;
            }
            params.put("accepted", Boolean.valueOf(accepted));
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
            --numberOfNegotiations;
        }
    }

    private void assertAndRunClaimAssessment() {
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("krisv", new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.assertTask((TaskSummary)tasks.get(0), "krisv", "Assessor evaluation", Status.Reserved);
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        Map taskInput = this.userTaskService.getTaskInputContentByTaskId(Long.valueOf(taskId));
        Assert.assertNotNull((Object)taskInput);
        Assert.assertTrue((boolean)taskInput.containsKey("_claimReport"));
        ClaimReport claimReport = (ClaimReport)taskInput.get("_claimReport");
        claimReport.setAmount(20000.0);
        claimReport.setCalculated(Boolean.TRUE);
        HashMap<String, ClaimReport> params = new HashMap<String, ClaimReport>();
        params.put("claimReport_", claimReport);
        this.userTaskService.completeAutoProgress(Long.valueOf(taskId), "krisv", params);
    }

    protected void assertAndProvideAdditionalDetails() {
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.assertTask((TaskSummary)tasks.get(0), "john", "Please provide additional details", Status.Reserved);
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        Map inputs = this.userTaskService.getTaskInputContentByTaskId(Long.valueOf(taskId));
        Assert.assertNotNull((Object)inputs);
        Assert.assertEquals((Object)"How did it happen?", inputs.get("reason"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseFile_answer", "It just happened in a split second, don't remember anything else");
        this.userTaskService.completeAutoProgress(Long.valueOf(taskId), "john", params);
        CaseFileInstance caseFile = this.caseService.getCaseFileInstance(CAR_INS_CASE_ID);
        Assert.assertNotNull((Object)caseFile);
        String answer = (String)caseFile.getData("answer");
        Assert.assertNotNull((Object)answer);
        Assert.assertEquals((Object)"It just happened in a split second, don't remember anything else", (Object)answer);
    }

    @Override
    protected List<ObjectModel> getProcessListeners() {
        List<ObjectModel> listeners = super.getProcessListeners();
        listeners.add(new ObjectModel("mvel", "org.jbpm.casemgmt.impl.util.CountDownListenerFactory.get(\"carInsuranceCase\", \"wait before callback\", 1)", new Object[0]));
        return listeners;
    }
}

