/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.util;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.assertj.core.api.Assertions;
import org.dashbuilder.DataSetCore;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.utils.DefaultCaseServiceConfigurator;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.test.services.AbstractCaseServicesTest;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public abstract class AbstractCaseServicesBaseTest
extends AbstractCaseServicesTest {
    protected static final String ARTIFACT_ID = "case-module";
    protected static final String GROUP_ID = "org.jbpm.cases";
    protected static final String VERSION = "1.0.0";
    protected PoolingDataSourceWrapper ds;
    protected static final String EMPTY_CASE_P_ID = "EmptyCase";
    protected static final String USER_TASK_STAGE_CASE_P_ID = "UserTaskWithStageCase";
    protected static final String USER_TASK_CASE_P_ID = "UserTaskCase";
    protected static final String USER_TASK_STAGE_AUTO_START_CASE_P_ID = "UserTaskWithStageCaseAutoStart";
    protected static final String USER_TASK_STAGE_ADHOC_CASE_P_ID = "UserStageAdhocCase";
    protected static final String NO_START_NODE_CASE_P_ID = "NoStartNodeAdhocCase";
    protected static final String COND_CASE_P_ID = "CaseFileConditionalEvent";
    protected static final String TWO_STAGES_CASE_P_ID = "CaseWithTwoStages";
    protected static final String TWO_STAGES_CONDITIONS_CASE_P_ID = "CaseWithTwoStagesConditions";
    protected static final String EXPRESSION_CASE_P_ID = "ExpressionWithCaseFileItem";
    protected static final String USER_TASK_DATA_RESTRICTIONS_CASE_P_ID = "UserTaskCaseDataRestrictions";
    protected static final String MULTI_STAGE_CASE_P_ID = "multiplestages";
    protected static final String USER_TASK_DATA_CASE_P_ID = "UserTaskCaseData";
    protected static final String EXECUTION_IN_ONE_GO = "CaseExecutionInOneGo";
    protected static final String STAGE_WITH_BOUNDARY_EVENT_CONDITION = "NoStartNodeCaseWithBoundaryTimerStage";
    protected static final String USER_TASK_REQUIRED_V_CASE_P_ID = "UserTaskCaseRequiredVar";
    protected static final String USER_TASK_RESTRICTED_V_CASE_P_ID = "UserTaskCaseRestrictedVar";
    protected static final String USER_TASK_REQUIRED_RESTRICTED_V_CASE_P_ID = "UserTaskCaseRequiredRestrictedVar";
    protected static final String USER_TASK_READONLY_V_CASE_P_ID = "UserTaskCaseReadOnlyVar";
    protected static final String SUBPROCESS_P_ID = "DataVerification";
    protected static final String DYNAMIC_SUBPROCESS_P_ID = "DynamicSubProcess";
    protected static final String FIRST_CASE_ID = "CASE-0000000001";
    protected static final String HR_CASE_ID = "HR-0000000001";
    protected static final String USER = "john";
    private static final String TEST_DOC_STORAGE = "target/docs";

    protected void configureServices() {
        super.configureServices();
        this.emf = ((DefaultCaseServiceConfigurator)this.caseConfigurator).getEmf();
    }

    protected DeploymentUnit prepareDeploymentUnit() throws Exception {
        this.identityProvider.setName(USER);
        return this.createAndDeployUnit(GROUP_ID, ARTIFACT_ID, VERSION);
    }

    protected void close() {
        DataSetCore.set(null);
        super.close();
    }

    protected void prepareDocumentStorage() {
        System.setProperty("org.jbpm.document.storage", TEST_DOC_STORAGE);
        this.deleteFolder(TEST_DOC_STORAGE);
    }

    protected void clearDocumentStorageProperty() {
        System.clearProperty("org.jbpm.document.storage");
    }

    protected static void waitForTheOtherThreads(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Thread 1 was interrupted while waiting for the other threads!");
        }
        catch (BrokenBarrierException e) {
            Assertions.fail((String)"Thread 1's barrier was broken while waiting for the other threads!");
        }
    }

    protected void assertComment(CommentInstance comment, String author, String content) {
        Assertions.assertThat((Object)comment).isNotNull();
        Assertions.assertThat((String)comment.getAuthor()).isEqualTo(author);
        Assertions.assertThat((String)comment.getComment()).isEqualTo(content);
    }

    protected void assertTask(TaskSummary task, String actor, String name, Status status) {
        Assertions.assertThat((Object)task).isNotNull();
        Assertions.assertThat((String)task.getName()).isEqualTo(name);
        Assertions.assertThat((String)task.getActualOwnerId()).isEqualTo(actor);
        Assertions.assertThat((Comparable)task.getStatus()).isEqualTo((Object)status);
    }

    protected void assertCaseInstance(String caseId, String name) {
        CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
        Assertions.assertThat((Object)cInstance).isNotNull();
        Assertions.assertThat((String)cInstance.getCaseId()).isEqualTo(caseId);
        Assertions.assertThat((Object)cInstance.getCaseFile()).isNotNull();
        Assertions.assertThat((Object)cInstance.getCaseFile().getData("name")).isEqualTo((Object)name);
    }

    public void assertCaseInstanceActive(String caseId) {
        try {
            CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Object)caseInstance).isNotNull();
            Assertions.assertThat((Integer)caseInstance.getStatus()).isEqualTo(CaseStatus.OPEN.getId());
        }
        catch (CaseNotFoundException ex) {
            Assertions.fail((String)"Case instance is not active");
        }
    }

    public void assertCaseInstanceNotActive(String caseId) {
        try {
            CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Object)caseInstance).isNotNull();
            Assertions.assertThat((Integer)caseInstance.getStatus()).isIn(new Object[]{CaseStatus.CLOSED.getId(), CaseStatus.CANCELLED.getId()});
        }
        catch (CaseNotFoundException caseNotFoundException) {
            // empty catch block
        }
    }
}

