/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jbpm.casemgmt.api.event.CaseCommentEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.event.CommentNotificationEventListener;
import org.jbpm.casemgmt.impl.model.CaseRoleImpl;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.casemgmt.impl.model.instance.CommentInstanceImpl;
import org.jbpm.casemgmt.impl.util.TestNotificationPublisher;
import org.junit.Test;
import org.kie.api.task.model.User;
import org.kie.internal.utils.NotificationPublisher;

public class CommentNotificationEventListenerTest {
    @Test
    public void testFindMentionsNoMentionsInComment() {
        String commentText = "just a plain text without mentioning any role";
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        List found = listener.extractMentionedRoles(commentText);
        Assertions.assertThat((List)found).isEmpty();
    }

    @Test
    public void testFindMentionsSingleMentionsInComment() {
        String commentText = "just a plain text mentioning @owner only";
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        List found = listener.extractMentionedRoles(commentText);
        Assertions.assertThat((List)found).hasSize(1);
        Assertions.assertThat((List)found).contains((Object[])new String[]{"owner"});
    }

    @Test
    public void testFindMentionsMultipleMentionsInComment() {
        String commentText = "@owner could you please get in touch with @manager regarding your vacation?";
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        List found = listener.extractMentionedRoles(commentText);
        Assertions.assertThat((List)found).hasSize(2);
        Assertions.assertThat((List)found).contains((Object[])new String[]{"owner"});
        Assertions.assertThat((List)found).contains((Object[])new String[]{"manager"});
    }

    @Test
    public void testCollectOrgEntitiesByRole() {
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        ArrayList<String> mentionedRoles = new ArrayList<String>();
        mentionedRoles.add("owner");
        mentionedRoles.add("manager");
        CommentInstanceImpl comment = new CommentInstanceImpl("john", "simple comment for @owner and @manager", new ArrayList());
        CaseFileInstance caseFile = this.buildCaseFile(mentionedRoles);
        CaseCommentEvent event = new CaseCommentEvent("john", caseFile.getCaseId(), caseFile, (CommentInstance)comment);
        StringBuilder commentContent = new StringBuilder(comment.getComment());
        Set collected = listener.collectOrgEntitiesByRole(mentionedRoles, event, commentContent);
        Assertions.assertThat((Iterable)collected).hasSize(2);
        Assertions.assertThat((Iterable)collected).allMatch(item -> item instanceof User);
        Assertions.assertThat((String)commentContent.toString()).isEqualTo("simple comment for john and mary");
    }

    @Test
    public void testCollectOrgEntitiesByRoleNotExistingRole() {
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        ArrayList<String> mentionedRoles = new ArrayList<String>();
        mentionedRoles.add("owner");
        mentionedRoles.add("manager");
        CommentInstanceImpl comment = new CommentInstanceImpl("john", "simple comment for @owner and @manager", new ArrayList());
        CaseFileInstance caseFile = this.buildCaseFile(mentionedRoles);
        CaseCommentEvent event = new CaseCommentEvent("john", caseFile.getCaseId(), caseFile, (CommentInstance)comment);
        mentionedRoles.add("notexisting");
        StringBuilder commentContent = new StringBuilder(comment.getComment());
        Set collected = listener.collectOrgEntitiesByRole(mentionedRoles, event, commentContent);
        Assertions.assertThat((Iterable)collected).hasSize(2);
        Assertions.assertThat((Iterable)collected).allMatch(item -> item instanceof User);
        Assertions.assertThat((String)commentContent.toString()).isEqualTo("simple comment for john and mary");
    }

    @Test
    public void testBuildParametersMap() {
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        CommentInstanceImpl comment = new CommentInstanceImpl("john", "simple comment for @owner and @manager", new ArrayList());
        CaseCommentEvent event = new CaseCommentEvent("john", "CASE-00001", null, (CommentInstance)comment);
        StringBuilder commentContent = new StringBuilder(comment.getComment());
        Map parameters = listener.buildParams(event, commentContent);
        Assertions.assertThat((Map)parameters).hasSize(5);
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)parameters).containsEntry((Object)"_AUTHOR_", (Object)comment.getAuthor())).containsEntry((Object)"_CASE_ID_", (Object)"CASE-00001")).containsEntry((Object)"_COMMENT_ID_", (Object)comment.getId())).containsEntry((Object)"_COMMENT_", (Object)commentContent.toString())).containsEntry((Object)"_CREATED_AT_", (Object)comment.getCreatedAt());
    }

    @Test
    public void testNotificationOnCommentAdded() {
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        ArrayList<String> mentionedRoles = new ArrayList<String>();
        mentionedRoles.add("owner");
        mentionedRoles.add("manager");
        CaseFileInstance caseFile = this.buildCaseFile(mentionedRoles);
        CommentInstanceImpl comment = new CommentInstanceImpl("john", "simple comment for @owner and @manager", new ArrayList());
        CaseCommentEvent event = new CaseCommentEvent("john", caseFile.getCaseId(), caseFile, (CommentInstance)comment);
        TestNotificationPublisher publisher = new TestNotificationPublisher(false);
        listener.addPublisher((NotificationPublisher)publisher);
        listener.afterCaseCommentAdded(event);
        String expectedNotification = "Publishing notification from cases@jbpm.org, with subject You have been mentioned in case (CASE-00001) comment to [[UserImpl:'mary'], [UserImpl:'john']] with template mentioned-in-comment";
        List<String> published = publisher.get();
        Assertions.assertThat(published).hasSize(1);
        Assertions.assertThat((String)published.get(0)).isEqualTo(expectedNotification);
    }

    @Test
    public void testNotificationOnCommentAddedWithRawBody() {
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        ArrayList<String> mentionedRoles = new ArrayList<String>();
        mentionedRoles.add("owner");
        mentionedRoles.add("manager");
        CaseFileInstance caseFile = this.buildCaseFile(mentionedRoles);
        CommentInstanceImpl comment = new CommentInstanceImpl("john", "simple comment for @owner and @manager", new ArrayList());
        CaseCommentEvent event = new CaseCommentEvent("john", caseFile.getCaseId(), caseFile, (CommentInstance)comment);
        TestNotificationPublisher publisher = new TestNotificationPublisher(true);
        listener.addPublisher((NotificationPublisher)publisher);
        listener.afterCaseCommentAdded(event);
        String expectedNotification = "Publishing notification from cases@jbpm.org, with subject You have been mentioned in case (CASE-00001) comment to [[UserImpl:'mary'], [UserImpl:'john']] with body simple comment for john and mary";
        List<String> published = publisher.get();
        Assertions.assertThat(published).hasSize(1);
        Assertions.assertThat((String)published.get(0)).isEqualTo(expectedNotification);
    }

    protected CaseFileInstance buildCaseFile(List<String> mentionedRoles) {
        CaseFileInstanceImpl caseFile = new CaseFileInstanceImpl("CASE-00001", "dummy", new HashMap());
        List roles = mentionedRoles.stream().map(roleName -> new CaseRoleImpl(roleName)).collect(Collectors.toList());
        caseFile.setupRoles(roles);
        caseFile.assignUser("owner", "john");
        caseFile.assignUser("manager", "mary");
        return caseFile;
    }
}

