/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.utils.NotificationPublisher;

public class TestNotificationPublisher
implements NotificationPublisher {
    private List<String> published = new ArrayList<String>();
    private boolean templateNotSupported = false;

    public TestNotificationPublisher(boolean templateNotSupported) {
        this.templateNotSupported = templateNotSupported;
    }

    public void publish(String sender, String subject, Set<OrganizationalEntity> recipients, String body) {
        String notificationString = String.format("Publishing notification from %s, with subject %s to %s with body %s", sender, subject, recipients, body);
        this.published.add(notificationString);
    }

    public void publish(String sender, String subject, Set<OrganizationalEntity> recipients, String template, Map<String, Object> parameters) {
        if (this.templateNotSupported) {
            throw new IllegalArgumentException("Tempalate " + template + " not found");
        }
        String notificationString = String.format("Publishing notification from %s, with subject %s to %s with template %s", sender, subject, recipients, template);
        this.published.add(notificationString);
    }

    public List<String> get() {
        ArrayList<String> current = new ArrayList<String>(this.published);
        this.published.clear();
        return current;
    }

    public boolean isActive() {
        return true;
    }
}

