/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.api.model.instance.StageStatus;
import org.jbpm.casemgmt.impl.model.instance.CaseInstanceImpl;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.kie.services.impl.admin.commands.CancelNodeInstanceCommand;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class StageCancelTest
extends AbstractCaseServicesBaseTest {
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/CaseWithBoundaryTimerStage.bpmn2");
        processes.add("cases/NoStartNodeCaseWithBoundaryTimerStage.bpmn2");
        processes.add("cases/CaseMultiInstanceStage.bpmn2");
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelStageForMultiInstanceStages() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "multiplestages");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
            Long processInstanceId = ((CaseInstanceImpl)caseInstance).getProcessInstanceId();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("type", "one");
            this.caseService.triggerAdHocFragment(caseId, "Stage #{type}", data);
            data.put("type", "two");
            this.caseService.triggerAdHocFragment(caseId, "Stage #{type}", data);
            data.put("type", "three");
            this.caseService.triggerAdHocFragment(caseId, "Stage #{type}", data);
            Collection activeNodes = this.caseRuntimeDataService.getActiveNodesForCase("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)activeNodes);
            Assertions.assertThat((Iterable)activeNodes).hasSize(3);
            Iterator activeStageNode = activeNodes.iterator();
            Collection allStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, false, new QueryContext());
            ((IterableAssert)((IterableAssert)((IterableAssert)((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)allStages).hasSize(4)).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Available))).noneMatch(item -> item.getStatus().equals((Object)StageStatus.Canceled))).noneMatch(item -> item.getStatus().equals((Object)StageStatus.Completed))).filteredOn(item -> item.getStatus().equals((Object)StageStatus.Active))).hasSize(3);
            this.assertActiveStages(caseId, 3);
            this.processService.execute(caseInstance.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new CancelNodeInstanceCommand(processInstanceId.longValue(), ((NodeInstanceDesc)activeStageNode.next()).getId().longValue()));
            allStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, false, new QueryContext());
            ((IterableAssert)((IterableAssert)((IterableAssert)((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)allStages).hasSize(4)).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Available))).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Canceled))).noneMatch(item -> item.getStatus().equals((Object)StageStatus.Completed))).filteredOn(item -> item.getStatus().equals((Object)StageStatus.Active))).hasSize(2);
            this.assertActiveStages(caseId, 2);
            this.caseService.triggerAdHocFragment(caseId, "Stage two", "Simple task", null);
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(1);
            this.assertTask((TaskSummary)tasks.get(0), "john", "Simple task", Status.Reserved);
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", new HashMap());
            allStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, false, new QueryContext());
            ((IterableAssert)((IterableAssert)((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)allStages).hasSize(4)).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Available))).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Active))).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Canceled))).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Completed));
            this.assertActiveStages(caseId, 1);
            activeStageNode.next();
            this.processService.execute(caseInstance.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new CancelNodeInstanceCommand(processInstanceId.longValue(), ((NodeInstanceDesc)activeStageNode.next()).getId().longValue()));
            allStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, false, new QueryContext());
            ((IterableAssert)((IterableAssert)((IterableAssert)((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)allStages).hasSize(4)).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Available))).anyMatch(item -> item.getStatus().equals((Object)StageStatus.Completed))).noneMatch(item -> item.getStatus().equals((Object)StageStatus.Active))).filteredOn(item -> item.getStatus().equals((Object)StageStatus.Canceled))).hasSize(2);
            this.assertActiveStages(caseId, 0);
        }
        catch (Exception e) {
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testCancelStageAutoComplete() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseWithBoundaryTimerStage");
        try {
            this.testCancelStage(caseId);
        }
        catch (Exception e) {
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testCancelStageNoAutoComplete() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "NoStartNodeCaseWithBoundaryTimerStage");
        try {
            this.caseService.addDataToCaseFile(caseId, "readyToActivate", (Object)true, new String[0]);
            this.testCancelStage(caseId);
        }
        catch (Exception e) {
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    private void testCancelStage(String caseId) {
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(1);
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
        Long processInstanceId = ((CaseInstanceImpl)caseInstance).getProcessInstanceId();
        Collection activeNodes = this.caseRuntimeDataService.getActiveNodesForCase("CASE-0000000001", new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        NodeInstanceDesc activeStage = (NodeInstanceDesc)activeNodes.iterator().next();
        this.processService.execute(caseInstance.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)processInstanceId), (Command)new CancelNodeInstanceCommand(processInstanceId.longValue(), activeStage.getId().longValue()));
        Collection allStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, false, new QueryContext());
        Assertions.assertThat((Iterable)allStages).hasSize(2);
        Iterator iterator = allStages.iterator();
        Assertions.assertThat((Comparable)((CaseStageInstance)iterator.next()).getStatus()).isEqualTo((Object)StageStatus.Canceled);
        Assertions.assertThat((Comparable)((CaseStageInstance)iterator.next()).getStatus()).isEqualTo((Object)StageStatus.Available);
        this.assertActiveStages(caseId, 0);
    }

    private void assertActiveStages(String caseId, int expectedActiveStages) {
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(expectedActiveStages);
    }
}

