/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import org.jbpm.console.ng.bd.security.KeyCloakTokenCredentialsProvider;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.credentials.SubjectCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerUtils.class);

    public static KieServicesClient createKieServicesClient(String ... capabilities) {
        String kieServerEndpoint = System.getProperty("org.kie.server.location");
        Preconditions.checkNotNull((Object)kieServerEndpoint, (Object)"Missing Kie Server system property org.kie.server.location");
        String userName = System.getProperty("org.kie.server.user");
        String password = System.getProperty("org.kie.server.pwd");
        if (Strings.isNullOrEmpty((String)userName)) {
            return KieServerUtils.createKieServicesClient(kieServerEndpoint, null, KieServerUtils.getCredentialsProvider(), capabilities);
        }
        return KieServerUtils.createKieServicesClient(kieServerEndpoint, null, userName, password, capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, String login, String password, String ... capabilities) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)endpoint, (String)login, (String)password);
        return KieServerUtils.createKieServicesClient(endpoint, classLoader, configuration, capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, CredentialsProvider credentialsProvider, String ... capabilities) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)endpoint, (CredentialsProvider)credentialsProvider);
        return KieServerUtils.createKieServicesClient(endpoint, classLoader, configuration, capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, KieServicesConfiguration configuration, String ... capabilities) {
        LOGGER.debug("Creating client that will use following endpoint {}", (Object)endpoint);
        configuration.setTimeout(60000L);
        configuration.setCapabilities(Arrays.asList(capabilities));
        configuration.setMarshallingFormat(MarshallingFormat.XSTREAM);
        configuration.setLoadBalancer(LoadBalancer.getDefault((String)endpoint));
        KieServicesClient kieServicesClient = classLoader == null ? KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration) : KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration, (ClassLoader)classLoader);
        LOGGER.debug("KieServerClient created successfully for endpoint {}", (Object)endpoint);
        return kieServicesClient;
    }

    public static CredentialsProvider getCredentialsProvider() {
        KeyCloakTokenCredentialsProvider credentialsProvider;
        try {
            credentialsProvider = new KeyCloakTokenCredentialsProvider();
        }
        catch (UnsupportedOperationException e) {
            credentialsProvider = new SubjectCredentialsProvider();
        }
        LOGGER.debug("{} initialized for the client.", (Object)credentialsProvider.getClass().getName());
        return credentialsProvider;
    }
}

