/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.KnowledgeDataService;
import org.droolsjbpm.services.api.KnowledgeDomainService;
import org.droolsjbpm.services.impl.model.ProcessInstanceDesc;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.kie.runtime.KieSession;
import org.kie.runtime.process.ProcessInstance;

@Service
@ApplicationScoped
@Transactional
public class KieSessionEntryPointImpl
implements KieSessionEntryPoint {
    @Inject
    KnowledgeDomainService domainService;
    @Inject
    KnowledgeDataService dataService;

    public long startProcess(int sessionId, String processId) {
        KieSession ksession = (KieSession)this.domainService.getSessionsByName(this.domainService.getProcessInSessionByName(processId)).get(sessionId);
        ProcessInstance pi = ksession.startProcess(processId);
        return pi.getId();
    }

    public long startProcess(int sessionId, String processId, Map<String, String> params) {
        KieSession ksession = (KieSession)this.domainService.getSessionsByName(this.domainService.getProcessInSessionByName(processId)).get(sessionId);
        ProcessInstance pi = ksession.startProcess(processId, new HashMap<String, String>(params));
        return pi.getId();
    }

    public void abortProcessInstance(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        this.domainService.getSessionById(piDesc.getSessionId()).abortProcessInstance(processInstanceId);
    }

    public void signalProcessInstance(long processInstanceId, String signalName, Object event) {
        if (processInstanceId == -1L) {
            Collection sessionNames = this.domainService.getSessionsNames();
            for (String sessionName : sessionNames) {
                Map sessions = this.domainService.getSessionsByName(sessionName);
                for (KieSession ksession : sessions.values()) {
                    ksession.signalEvent(signalName, event);
                }
            }
        } else {
            ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
            KieSession ksession = this.domainService.getSessionById(piDesc.getSessionId());
            ksession.signalEvent(signalName, event, processInstanceId);
        }
    }
}

