/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.KnowledgeDataService;
import org.droolsjbpm.services.api.KnowledgeDomainService;
import org.droolsjbpm.services.api.RulesNotificationService;
import org.droolsjbpm.services.api.bpmn2.BPMN2DataService;
import org.droolsjbpm.services.impl.model.ProcessDesc;
import org.droolsjbpm.services.impl.model.ProcessInstanceDesc;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.bd.backend.server.KieSessionHelper;
import org.jbpm.console.ng.bd.backend.server.RuleNotificationHelper;
import org.jbpm.console.ng.bd.model.KieSessionSummary;
import org.jbpm.console.ng.bd.model.RuleNotificationSummary;
import org.jbpm.console.ng.bd.service.KnowledgeDomainServiceEntryPoint;
import org.jbpm.console.ng.ht.backend.server.TaskDefHelper;
import org.jbpm.console.ng.ht.model.TaskDefSummary;
import org.jbpm.console.ng.pr.backend.server.NodeInstanceHelper;
import org.jbpm.console.ng.pr.backend.server.ProcessHelper;
import org.jbpm.console.ng.pr.backend.server.ProcessInstanceHelper;
import org.jbpm.console.ng.pr.backend.server.VariableHelper;
import org.jbpm.console.ng.pr.model.NodeInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.model.VariableSummary;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.commons.java.nio.file.Path;
import org.kie.runtime.KieSession;
import org.kie.runtime.process.ProcessInstance;
import org.uberfire.backend.vfs.ActiveFileSystems;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.PathFactory;

@Service
@ApplicationScoped
@Transactional
public class KnowledgeDomainServiceEntryPointImpl
implements KnowledgeDomainServiceEntryPoint {
    @Inject
    KnowledgeDomainService domainService;
    @Inject
    RulesNotificationService rulesNotificationService;
    @Inject
    KnowledgeDataService dataService;
    @Inject
    BPMN2DataService bpmn2Service;
    @Inject
    FileService fs;
    @Inject
    ActiveFileSystems fileSystems;

    public Collection<String> getSessionsNames() {
        return this.domainService.getSessionsNames();
    }

    public int getAmountOfSessions() {
        return this.domainService.getAmountOfSessions();
    }

    public Collection<ProcessInstanceSummary> getProcessInstances() {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstances());
    }

    public Collection<ProcessInstanceSummary> getProcessInstancesBySessionId(String sessionId) {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstancesBySessionId(sessionId));
    }

    public Collection<ProcessSummary> getProcessesByFilter(String filter) {
        return ProcessHelper.adaptCollection((Collection)this.dataService.getProcessesByFilter(filter));
    }

    public ProcessInstanceSummary getProcessInstanceById(long processInstanceId) {
        return ProcessInstanceHelper.adapt((ProcessInstanceDesc)this.dataService.getProcessInstanceById(processInstanceId));
    }

    public Collection<ProcessSummary> getProcesses() {
        return ProcessHelper.adaptCollection((Collection)this.dataService.getProcesses());
    }

    public Collection<ProcessInstanceSummary> getProcessInstancesByProcessDefinition(String processDefId) {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstancesByProcessDefinition(processDefId));
    }

    public List<String> getAssociatedDomainObjects(String processId) {
        return this.bpmn2Service.getAssociatedDomainObjects(processId);
    }

    public Map<String, String> getRequiredInputData(String processId) {
        return this.bpmn2Service.getProcessData(processId);
    }

    public List<String> getAssociatedForms(String processId) {
        return this.bpmn2Service.getAssociatedForms(processId);
    }

    public Collection<TaskDefSummary> getAllTasksDef(String processId) {
        return TaskDefHelper.adaptCollection((Collection)this.bpmn2Service.getAllTasksDef(processId));
    }

    public Map<String, String> getAvailableProcesses() {
        return this.domainService.getAvailableProcesses();
    }

    public Map<String, String> getAvailableProcessesPath() {
        return this.domainService.getAvailableProcessesPaths();
    }

    public Map<String, String> getAssociatedEntities(String processId) {
        return this.bpmn2Service.getAssociatedEntities(processId);
    }

    public Collection<NodeInstanceSummary> getProcessInstanceHistory(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceHistory(piDesc.getSessionId(), processInstanceId));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceHistory(long processInstanceId, boolean completed) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceHistory(piDesc.getSessionId(), processInstanceId, completed));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceFullHistory(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceFullHistory(piDesc.getSessionId(), processInstanceId));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceActiveNodes(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceActiveNodes(piDesc.getSessionId(), processInstanceId));
    }

    public ProcessSummary getProcessDesc(String processId) {
        return ProcessHelper.adapt((ProcessDesc)this.bpmn2Service.getProcessDesc(processId));
    }

    public Collection<VariableSummary> getVariablesCurrentState(long processInstanceId, String processId) {
        HashMap properties = new HashMap(this.bpmn2Service.getProcessData(processId));
        return VariableHelper.adaptCollection((Collection)this.dataService.getVariablesCurrentState(processInstanceId), properties, (long)processInstanceId);
    }

    public Map<String, String> getTaskInputMappings(String processId, String taskName) {
        return this.bpmn2Service.getTaskInputMappings(processId, taskName);
    }

    public Map<String, String> getTaskOutputMappings(String processId, String taskName) {
        return this.bpmn2Service.getTaskOutputMappings(processId, taskName);
    }

    public int newKieSession(String groupId, String artifactId, String version, String kbaseName, String sessionName) {
        return this.domainService.newKieSession(groupId, artifactId, version, kbaseName, sessionName);
    }

    public Collection<ProcessInstanceSummary> getProcessInstances(List<Integer> states, String filterText, int filterType, String initiator) {
        Collection result = null;
        result = filterType == 0 ? this.dataService.getProcessInstancesByProcessId(states, filterText, initiator) : (filterType == 1 ? this.dataService.getProcessInstancesByProcessName(states, filterText, initiator) : this.dataService.getProcessInstances(states, initiator));
        return ProcessInstanceHelper.adaptCollection((Collection)result);
    }

    public Collection<String> getAvailableSignals(String businessKey, long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        KieSession ksession = this.domainService.getSessionById(piDesc.getSessionId());
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        ArrayList<String> activeSignals = new ArrayList<String>();
        if (processInstance != null) {
            ((ProcessInstanceImpl)processInstance).setProcess(ksession.getKieBase().getProcess(processInstance.getProcessId()));
            Collection activeNodes = ((WorkflowProcessInstance)processInstance).getNodeInstances();
            activeSignals.addAll(ProcessInstanceHelper.collectActiveSignals((Collection)activeNodes));
        }
        return activeSignals;
    }

    public void setProcessVariable(long processInstanceId, String variableId, Object value) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        KieSession ksession = this.domainService.getSessionById(piDesc.getSessionId());
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        ((WorkflowProcessInstance)processInstance).setVariable(variableId, value);
    }

    public Collection<VariableSummary> getVariableHistory(long processInstanceId, String variableId) {
        return VariableHelper.adaptCollection((Collection)this.dataService.getVariableHistory(processInstanceId, variableId));
    }

    public ProcessSummary getProcessesById(long processInstanceId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getReusableSubProcesses(String processId) {
        return this.bpmn2Service.getReusableSubProcesses(processId);
    }

    public void checkFileSystem() {
        this.fs.fetchChanges();
    }

    public String createProcessDefinitionFile(String name) {
        return this.fs.createFile(name).toString();
    }

    public void fetchChanges() {
        this.fs.fetchChanges();
    }

    public byte[] loadFile(Path file) {
        try {
            return this.fs.loadFile(file);
        }
        catch (FileException ex) {
            Logger.getLogger(KnowledgeDomainServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Iterable<Path> loadFilesByType(String path, String fileType) {
        try {
            return this.fs.loadFilesByType(path, fileType);
        }
        catch (FileException ex) {
            Logger.getLogger(KnowledgeDomainServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void createDomain() {
        this.domainService.createDomain();
    }

    public KieSessionSummary getSessionSummaryByName(int sessionId) {
        return KieSessionHelper.adapt(this.domainService.getSessionById(sessionId));
    }

    public void insertNotification(int sessionId, String notification) {
        this.rulesNotificationService.insertNotification(sessionId, notification);
    }

    public Collection<RuleNotificationSummary> getAllNotificationInstance() {
        return RuleNotificationHelper.adaptCollection(this.rulesNotificationService.getAllNotificationInstance());
    }

    public Collection<RuleNotificationSummary> getAllNotificationInstanceBySessionId(int sessionId) {
        return RuleNotificationHelper.adaptCollection(this.rulesNotificationService.getAllNotificationInstanceBySessionId(sessionId));
    }

    public org.uberfire.backend.vfs.Path getProcessAssetPath(String processId) {
        String reporoot = this.fs.getRepositoryRoot();
        if (reporoot.endsWith("/")) {
            reporoot = reporoot.substring(0, reporoot.length() - 1);
        }
        String uri = reporoot + this.domainService.getProcessAssetPath(processId);
        String name = uri.substring(uri.lastIndexOf("/") + 1);
        return PathFactory.newPath((FileSystem)this.fileSystems.getBootstrapFileSystem(), (String)name, (String)uri);
    }

    public Collection<NodeInstanceSummary> getProcessInstanceCompletedNodes(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceCompletedNodes(piDesc.getSessionId(), processInstanceId));
    }
}

