/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.service;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Alternative;
import org.jbpm.console.ng.bd.api.FileException;
import org.jbpm.console.ng.bd.api.FileService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceNio2WrapperImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@Alternative
public class TestVFSFileServiceImpl
implements FileService {
    private static final String TEST_RESOURCES = "src/test/resources/repo/";
    private String repositoryRoot;
    private final IOService ioService = new IOServiceNio2WrapperImpl();

    @PostConstruct
    public void init() throws FileException {
        this.repositoryRoot = new File(TEST_RESOURCES).toURI().toString();
        this.ioService.getFileSystem(URI.create(this.repositoryRoot));
    }

    public void fetchChanges() {
    }

    public byte[] loadFile(Path file) throws FileException {
        PortablePreconditions.checkNotNull((String)"file", (Object)file);
        try {
            return this.ioService.readAllBytes(file);
        }
        catch (IOException ex) {
            throw new FileException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Iterable<Path> loadFilesByType(Path path, final String fileType) throws FileException {
        return this.ioService.newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && (entry.getFileName().toString().endsWith(fileType) || entry.getFileName().toString().matches(fileType));
            }
        });
    }

    public boolean exists(Path file) {
        return this.ioService.exists(file);
    }

    public void move(Path source, Path dest) {
        this.copy(source, dest);
        this.ioService.delete(source, new DeleteOption[0]);
    }

    public void copy(Path source, Path dest) {
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"dest", (Object)dest);
        this.ioService.copy(source, dest, new CopyOption[0]);
    }

    public Path createDirectory(Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.createDirectory(path, new FileAttribute[0]);
    }

    public boolean deleteIfExists(Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.deleteIfExists(path, new DeleteOption[0]);
    }

    public OutputStream openFile(Path path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.newOutputStream(path, new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING});
    }

    public Path createFile(Path path) {
        return this.ioService.createFile(path, new FileAttribute[0]);
    }

    public Iterable<Path> listDirectories(Path path) {
        return this.ioService.newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]);
            }
        });
    }

    public Path getPath(String path) {
        return this.ioService.get(this.repositoryRoot + path, new String[0]);
    }
}

