/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.PostBuildHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.exception.DeploymentException;
import org.jbpm.console.ng.bd.model.DeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.bd.service.DeploymentManagerEntryPoint;
import org.jbpm.console.ng.bd.service.Initializable;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.event.Deploy;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.kie.internal.deployment.DeployedUnit;
import org.kie.internal.deployment.DeploymentService;
import org.kie.internal.deployment.DeploymentUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.deployment.DeploymentConfigService;
import org.uberfire.backend.server.config.Added;
import org.uberfire.backend.server.config.Removed;
import org.uberfire.backend.server.deployment.DeploymentConfigChangedEvent;

@Service
@ApplicationScoped
public class DeploymentManagerEntryPointImpl
implements DeploymentManagerEntryPoint,
Initializable<DeploymentUnit>,
PostBuildHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentManagerEntryPointImpl.class);
    @Inject
    private DeploymentService deploymentService;
    @Inject
    @RequestScoped
    @Named(value="DeployList")
    private Set<DeploymentUnit> deploymentUnits;
    @Inject
    private DeploymentConfigService deploymentConfigService;
    @Inject
    private GuvnorM2Repository guvnorM2Repository;
    @Inject
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    @Inject
    private Event<BuildResults> buildResultsEvent;

    @PostConstruct
    public void configure() {
        this.guvnorM2Repository.getRepositoryURL();
    }

    public void initDeployments(Set<DeploymentUnit> deploymentUnits) {
        for (DeploymentUnit unit : deploymentUnits) {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) continue;
            try {
                if ("true".equals(System.getProperty("org.kie.clean.onstartup"))) {
                    this.cleanup(unit.getIdentifier());
                }
                this.deploymentService.deploy(unit);
            }
            catch (Exception e) {
                logger.warn("Error when deploying unit {} error message {}", (Object)unit, (Object)e.getMessage());
                logger.debug("Stacktrace:", (Throwable)e);
            }
        }
    }

    public void deploy(DeploymentUnitSummary unitSummary) {
        KModuleDeploymentUnit unit = null;
        if (unitSummary.getType().equals("kjar")) {
            unit = new KModuleDeploymentUnit(((KModuleDeploymentUnitSummary)unitSummary).getGroupId(), ((KModuleDeploymentUnitSummary)unitSummary).getArtifactId(), ((KModuleDeploymentUnitSummary)unitSummary).getVersion(), ((KModuleDeploymentUnitSummary)unitSummary).getKbaseName(), ((KModuleDeploymentUnitSummary)unitSummary).getKsessionName(), ((KModuleDeploymentUnitSummary)unitSummary).getStrategy());
        }
        this.deploy((DeploymentUnit)unit);
    }

    protected void deploy(DeploymentUnit unit) {
        if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) == null) {
            String[] gavElemes = unit.getIdentifier().split(":");
            GAV gav = new GAV(gavElemes[0], gavElemes[1], gavElemes[2]);
            BuildResults buildResults = new BuildResults(gav);
            try {
                this.deploymentService.deploy(unit);
            }
            catch (Exception e) {
                BuildMessage message = new BuildMessage();
                message.setLevel(BuildMessage.Level.ERROR);
                message.setText("Deployment of unit " + gav + " failed: " + e.getMessage());
                buildResults.addBuildMessage(message);
                throw new DeploymentException(e.getMessage(), (Throwable)e);
            }
            finally {
                this.buildResultsEvent.fire((Object)buildResults);
            }
        }
    }

    public void undeploy(DeploymentUnitSummary unitSummary) {
        KModuleDeploymentUnit unit = null;
        if (unitSummary.getType().equals("kjar")) {
            unit = new KModuleDeploymentUnit(((KModuleDeploymentUnitSummary)unitSummary).getGroupId(), ((KModuleDeploymentUnitSummary)unitSummary).getArtifactId(), ((KModuleDeploymentUnitSummary)unitSummary).getVersion(), ((KModuleDeploymentUnitSummary)unitSummary).getKbaseName(), ((KModuleDeploymentUnitSummary)unitSummary).getKsessionName());
        }
        this.undeploy((DeploymentUnit)unit);
    }

    protected void undeploy(DeploymentUnit unit) {
        String[] gavElemes = unit.getIdentifier().split(":");
        GAV gav = new GAV(gavElemes[0], gavElemes[1], gavElemes[2]);
        BuildResults buildResults = new BuildResults(gav);
        try {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) {
                this.deploymentService.undeploy(unit);
                this.cleanup(unit.getIdentifier());
            }
        }
        catch (Exception e) {
            BuildMessage message = new BuildMessage();
            message.setLevel(BuildMessage.Level.ERROR);
            message.setText("Undeployment of unit " + gav + " failed: " + e.getMessage());
            buildResults.addBuildMessage(message);
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.buildResultsEvent.fire((Object)buildResults);
        }
    }

    public void redeploy() {
        for (DeploymentUnit unit : this.deploymentUnits) {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) {
                this.deploymentService.undeploy(unit);
            }
            this.deploymentService.deploy(unit);
        }
    }

    protected void cleanup(final String identifier) {
        File dataDir;
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        if ((dataDir = new File(location)).exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = dataDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(identifier + "-jbpmSessionId.ser");
                }
            })) {
                new File(dataDir, file).delete();
            }
        }
    }

    public List<KModuleDeploymentUnitSummary> getDeploymentUnits() {
        Collection deployedUnits = this.deploymentService.getDeployedUnits();
        ArrayList<KModuleDeploymentUnitSummary> unitsIds = new ArrayList<KModuleDeploymentUnitSummary>(deployedUnits.size());
        for (DeployedUnit du : deployedUnits) {
            KModuleDeploymentUnit kdu = (KModuleDeploymentUnit)du.getDeploymentUnit();
            KModuleDeploymentUnitSummary duSummary = new KModuleDeploymentUnitSummary(kdu.getIdentifier(), kdu.getGroupId(), kdu.getArtifactId(), kdu.getVersion(), kdu.getKbaseName(), kdu.getKsessionName(), kdu.getStrategy().toString());
            unitsIds.add(duSummary);
        }
        return unitsIds;
    }

    public void saveDeployment(@Observes @Deploy DeploymentEvent event) {
        if (this.deploymentConfigService.getDeployment(event.getDeploymentId()) == null) {
            this.deploymentConfigService.addDeployment(event.getDeploymentId(), (Object)event.getDeployedUnit().getDeploymentUnit());
        }
    }

    public void removeDeployment(@Observes @Undeploy DeploymentEvent event) {
        this.deploymentConfigService.removeDeployment(event.getDeploymentId());
    }

    public void process(BuildResults buildResults) {
        if (!buildResults.getMessages().isEmpty()) {
            return;
        }
        try {
            KModuleDeploymentUnitSummary unit = new KModuleDeploymentUnitSummary("", buildResults.getGAV().getGroupId(), buildResults.getGAV().getArtifactId(), buildResults.getGAV().getVersion(), "", "", DeploymentUnit.RuntimeStrategy.SINGLETON.toString());
            this.undeploy((DeploymentUnitSummary)unit);
            this.deploy((DeploymentUnitSummary)unit);
        }
        catch (Exception e) {
            BuildMessage message = new BuildMessage();
            message.setLevel(BuildMessage.Level.ERROR);
            message.setText("Deployment of unit " + buildResults.getGAV() + " failed: " + e.getMessage());
            buildResults.addBuildMessage(message);
            logger.error("Deployment of unit {} failed: {}", new Object[]{buildResults.getGAV(), e.getMessage(), e});
        }
    }

    public void undeployOnEvent(@Observes @Removed DeploymentConfigChangedEvent event) {
        String deploymentId = ((DeploymentUnit)event.getDeploymentUnit()).getIdentifier();
        try {
            this.undeploy((DeploymentUnit)event.getDeploymentUnit());
        }
        catch (RuntimeException e) {
            if (this.deploymentConfigService.getDeployment(deploymentId) == null) {
                this.deploymentConfigService.addDeployment(deploymentId, event.getDeploymentUnit());
            }
            throw e;
        }
    }

    public void deployOnEvent(@Observes @Added DeploymentConfigChangedEvent event) {
        this.deploy((DeploymentUnit)event.getDeploymentUnit());
    }
}

