/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.services.api.AdHocProcessService;
import org.jbpm.services.api.ProcessService;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;

@Service
@ApplicationScoped
public class KieSessionEntryPointImpl
implements KieSessionEntryPoint {
    @Inject
    private ProcessService processService;
    @Inject
    private AdHocProcessService adHocProcessService;
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();

    public long startProcess(String deploymentId, String processId) {
        try {
            Long processInstanceId = this.processService.startProcess(deploymentId, processId);
            return processInstanceId;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public long startProcess(String deploymentUnitId, String processId, Map<String, Object> params) {
        try {
            Long processInstanceId = this.processService.startProcess(deploymentUnitId, processId, params);
            return processInstanceId;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public long startProcess(String deploymentUnitId, String processId, String correlationKey, Map<String, Object> params) {
        try {
            CorrelationKey correlationKeyValue = null;
            if (correlationKey != null && !correlationKey.isEmpty()) {
                String[] correlations = correlationKey.split(",");
                correlationKeyValue = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlations));
            }
            Long processInstanceId = this.processService.startProcess(deploymentUnitId, processId, correlationKeyValue, params);
            return processInstanceId;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public long startProcess(String deploymentUnitId, String processId, String correlationKey, Map<String, Object> params, Long parentProcessInstanceId) {
        try {
            CorrelationKey correlationKeyValue = null;
            if (correlationKey != null && !correlationKey.isEmpty()) {
                String[] correlations = correlationKey.split(",");
                correlationKeyValue = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlations));
            }
            Long processInstanceId = this.adHocProcessService.startProcess(deploymentUnitId, processId, correlationKeyValue, params, parentProcessInstanceId);
            return processInstanceId;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void abortProcessInstance(long processInstanceId) {
        try {
            this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void abortProcessInstances(List<Long> processInstanceIds) {
        try {
            this.processService.abortProcessInstances(processInstanceIds);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void suspendProcessInstance(long processInstanceId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public void signalProcessInstance(long processInstanceId, String signalName, Object event) {
        try {
            this.processService.signalProcessInstance(Long.valueOf(processInstanceId), signalName, event);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void signalProcessInstances(List<Long> processInstanceIds, String signalName, Object event) {
        try {
            this.processService.signalProcessInstances(processInstanceIds, signalName, event);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Collection<String> getAvailableSignals(long processInstanceId) {
        try {
            Collection signals = this.processService.getAvailableSignals(Long.valueOf(processInstanceId));
            return signals;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void setProcessVariable(long processInstanceId, String variableId, Object value) {
        try {
            this.processService.setProcessVariable(Long.valueOf(processInstanceId), variableId, value);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

