/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.PostBuildHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.structure.backend.config.Added;
import org.guvnor.structure.backend.config.Removed;
import org.guvnor.structure.backend.deployment.DeploymentConfigChangedEvent;
import org.guvnor.structure.deployment.DeploymentConfigService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.exception.DeploymentException;
import org.jbpm.console.ng.bd.model.DeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleKey;
import org.jbpm.console.ng.bd.service.DeploymentManagerEntryPoint;
import org.jbpm.console.ng.bd.service.Initializable;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.cdi.Deploy;
import org.jbpm.services.cdi.Undeploy;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class DeploymentManagerEntryPointImpl
implements DeploymentManagerEntryPoint,
Initializable<DeploymentUnit>,
PostBuildHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentManagerEntryPointImpl.class);
    private static final MergeMode defaultMergeMode = MergeMode.valueOf((String)System.getProperty("org.kie.dd.mergemode", MergeMode.MERGE_COLLECTIONS.toString()));
    private boolean gitDeploymentsEnabled = Boolean.parseBoolean(System.getProperty("org.kie.git.deployments.enabled", "false"));
    private boolean autoDeployEnabled = Boolean.parseBoolean(System.getProperty("org.kie.auto.deploy.enabled", "true"));
    private boolean overrideDeploymentsEnabled = Boolean.parseBoolean(System.getProperty("org.kie.override.deploy.enabled", "false"));
    @Inject
    private DeploymentService deploymentService;
    @Inject
    @Named(value="DeployList")
    private Set<DeploymentUnit> deploymentUnits;
    @Inject
    private DeploymentConfigService deploymentConfigService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private GuvnorM2Repository guvnorM2Repository;
    @Inject
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    @Inject
    private Event<BuildResults> buildResultsEvent;

    @PostConstruct
    public void configure() {
        this.guvnorM2Repository.getRepositoryURL();
        String supportRuntimeDeployment = "true";
        List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        for (ConfigGroup globalConfigGroup : globalConfigGroups) {
            if (!"settings".equals(globalConfigGroup.getName())) continue;
            supportRuntimeDeployment = globalConfigGroup.getConfigItemValue("support.runtime.deploy");
            break;
        }
        if (this.autoDeployEnabled) {
            this.autoDeployEnabled = Boolean.parseBoolean(supportRuntimeDeployment);
        }
    }

    public void initDeployments(Set<DeploymentUnit> deploymentUnits) {
        for (DeploymentUnit unit : deploymentUnits) {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) continue;
            try {
                if ("true".equals(System.getProperty("org.kie.clean.onstartup"))) {
                    this.cleanup(unit.getIdentifier());
                }
                this.deploymentService.deploy(unit);
            }
            catch (Exception e) {
                logger.warn("Error when deploying unit {} error message {}", (Object)unit, (Object)e.getMessage());
                logger.debug("Stacktrace:", (Throwable)e);
            }
        }
    }

    public void deploy(DeploymentUnitSummary unitSummary) {
        KModuleDeploymentUnit unit = null;
        if (!this.deploymentService.isDeployed(unitSummary.getId()) || this.deploymentService.isDeployed(unitSummary.getId()) && this.overrideDeploymentsEnabled || unitSummary.getId().contains("SNAPSHOT")) {
            if (unitSummary.getType().equals("kjar")) {
                unit = new KModuleDeploymentUnit(((KModuleDeploymentUnitSummary)unitSummary).getGroupId(), ((KModuleDeploymentUnitSummary)unitSummary).getArtifactId(), ((KModuleDeploymentUnitSummary)unitSummary).getVersion(), ((KModuleDeploymentUnitSummary)unitSummary).getKbaseName(), ((KModuleDeploymentUnitSummary)unitSummary).getKsessionName());
                if (((KModuleDeploymentUnitSummary)unitSummary).getStrategy() != null) {
                    unit.setStrategy(RuntimeStrategy.valueOf((String)((KModuleDeploymentUnitSummary)unitSummary).getStrategy()));
                }
                if (((KModuleDeploymentUnitSummary)unitSummary).getMergeMode() != null) {
                    unit.setMergeMode(MergeMode.valueOf((String)((KModuleDeploymentUnitSummary)unitSummary).getMergeMode()));
                }
            }
            logger.info("Deploying unit " + unitSummary.getId());
            boolean deployed = this.deploy((DeploymentUnit)unit);
            if (!deployed) {
                BuildResults error = this.prepareBuildResults(unitSummary, "Deployment of unit " + unitSummary.getId() + " failed due to it is already deployed!", Level.ERROR);
                this.buildResultsEvent.fire((Object)error);
                throw new DeploymentException("unit already deployed!", null);
            }
        } else {
            BuildResults error = this.prepareBuildResults(unitSummary, "Deployment of unit " + unitSummary.getId() + " failed: unit already deployed! (override deployment: " + this.overrideDeploymentsEnabled + ")", Level.ERROR);
            this.buildResultsEvent.fire((Object)error);
            throw new DeploymentException("unit already deployed!", null);
        }
    }

    private BuildResults prepareBuildResults(DeploymentUnitSummary unitSummary, String messageText, Level level) {
        String[] gavElemes = unitSummary.getId().split(":");
        GAV gav = new GAV(gavElemes[0], gavElemes[1], gavElemes[2]);
        BuildResults buildResults = new BuildResults(gav);
        BuildMessage message = new BuildMessage();
        message.setLevel(level);
        message.setText(messageText);
        buildResults.addBuildMessage(message);
        return buildResults;
    }

    protected boolean deploy(DeploymentUnit unit) {
        if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) == null) {
            String[] gavElemes = unit.getIdentifier().split(":");
            GAV gav = new GAV(gavElemes[0], gavElemes[1], gavElemes[2]);
            BuildResults buildResults = new BuildResults(gav);
            try {
                this.deploymentService.deploy(unit);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                BuildMessage message = new BuildMessage();
                message.setLevel(Level.ERROR);
                message.setText("Deployment of unit " + gav + " failed: " + e.getMessage());
                logger.warn("Deployment of unit " + gav + " failed: " + e.getMessage(), (Throwable)e);
                buildResults.addBuildMessage(message);
                throw new DeploymentException(e.getMessage(), (Throwable)e);
            }
            finally {
                this.buildResultsEvent.fire((Object)buildResults);
            }
        }
        return false;
    }

    public void undeploy(DeploymentUnitSummary unitSummary) {
        KModuleDeploymentUnit unit = null;
        if (unitSummary.getType().equals("kjar")) {
            unit = new KModuleDeploymentUnit(((KModuleDeploymentUnitSummary)unitSummary).getGroupId(), ((KModuleDeploymentUnitSummary)unitSummary).getArtifactId(), ((KModuleDeploymentUnitSummary)unitSummary).getVersion(), ((KModuleDeploymentUnitSummary)unitSummary).getKbaseName(), ((KModuleDeploymentUnitSummary)unitSummary).getKsessionName());
        }
        this.undeploy((DeploymentUnit)unit);
    }

    public void activate(DeploymentUnitSummary unitSummary) {
        this.deploymentService.activate(unitSummary.getId());
    }

    public void deactivate(DeploymentUnitSummary unitSummary) {
        this.deploymentService.deactivate(unitSummary.getId());
    }

    protected void undeploy(DeploymentUnit unit) {
        String[] gavElemes = unit.getIdentifier().split(":");
        GAV gav = new GAV(gavElemes[0], gavElemes[1], gavElemes[2]);
        BuildResults buildResults = new BuildResults(gav);
        try {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) {
                this.deploymentService.undeploy(unit);
                this.cleanup(unit.getIdentifier());
            }
        }
        catch (Exception e) {
            BuildMessage message = new BuildMessage();
            message.setLevel(Level.ERROR);
            message.setText("Undeployment of unit " + gav + " failed: " + e.getMessage());
            logger.warn("Undeployment of unit " + gav + " failed: " + e.getMessage(), (Throwable)e);
            buildResults.addBuildMessage(message);
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.buildResultsEvent.fire((Object)buildResults);
        }
    }

    public void redeploy() {
        for (DeploymentUnit unit : this.deploymentUnits) {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) {
                this.deploymentService.undeploy(unit);
            }
            this.deploymentService.deploy(unit);
        }
    }

    protected void cleanup(final String identifier) {
        File dataDir;
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        if ((dataDir = new File(location)).exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = dataDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(identifier + "-jbpmSessionId.ser");
                }
            })) {
                new File(dataDir, file).delete();
            }
        }
    }

    public PageResponse<KModuleDeploymentUnitSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List<KModuleDeploymentUnitSummary> unitsIds = this.getDeployedUnits(filter);
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(unitsIds.size());
        response.setTotalRowSizeExact(true);
        if (!unitsIds.isEmpty() && unitsIds.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList<KModuleDeploymentUnitSummary>(unitsIds.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList<KModuleDeploymentUnitSummary>(unitsIds.subList(filter.getOffset(), unitsIds.size())));
            response.setLastPage(true);
        }
        return response;
    }

    private List<KModuleDeploymentUnitSummary> getDeployedUnits(QueryFilter filter) {
        Collection deployedUnits = this.deploymentService.getDeployedUnits();
        ArrayList<KModuleDeploymentUnitSummary> unitsIds = new ArrayList<KModuleDeploymentUnitSummary>(deployedUnits.size());
        for (DeployedUnit du : deployedUnits) {
            KModuleDeploymentUnit kdu = (KModuleDeploymentUnit)du.getDeploymentUnit();
            KModuleDeploymentUnitSummary duSummary = new KModuleDeploymentUnitSummary(kdu.getIdentifier(), kdu.getGroupId(), kdu.getArtifactId(), kdu.getVersion(), kdu.getKbaseName(), kdu.getKsessionName(), kdu.getStrategy().toString(), kdu.getMergeMode().toString());
            if (filter.getParams() == null || filter.getParams().get("textSearch") == null || ((String)filter.getParams().get("textSearch")).isEmpty()) {
                unitsIds.add(duSummary);
            } else if (kdu.getIdentifier().toLowerCase().contains((String)filter.getParams().get("textSearch"))) {
                unitsIds.add(duSummary);
            }
            duSummary.setActive(du.isActive());
        }
        this.sort(unitsIds, filter);
        return unitsIds;
    }

    private void sort(List<KModuleDeploymentUnitSummary> unitsIds, final QueryFilter filter) {
        if (filter.getOrderBy().equals("Deployment")) {
            Collections.sort(unitsIds, new Comparator<KModuleDeploymentUnitSummary>(){

                @Override
                public int compare(KModuleDeploymentUnitSummary o1, KModuleDeploymentUnitSummary o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = -1;
                    if (o1 != null) {
                        diff = o2 != null ? o1.getId().compareTo(o2.getId()) : 1;
                    }
                    return filter.isAscending() != false ? diff : -diff;
                }
            });
        } else if (filter.getOrderBy().equals("ArtifactId")) {
            Collections.sort(unitsIds, new Comparator<KModuleDeploymentUnitSummary>(){

                @Override
                public int compare(KModuleDeploymentUnitSummary o1, KModuleDeploymentUnitSummary o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = -1;
                    if (o1 != null) {
                        diff = o2 != null ? o1.getArtifactId().compareTo(o2.getArtifactId()) : 1;
                    }
                    return filter.isAscending() != false ? diff : -diff;
                }
            });
        } else if (filter.getOrderBy().equals("GroupId")) {
            Collections.sort(unitsIds, new Comparator<KModuleDeploymentUnitSummary>(){

                @Override
                public int compare(KModuleDeploymentUnitSummary o1, KModuleDeploymentUnitSummary o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = -1;
                    if (o1 != null) {
                        diff = o2 != null ? o1.getGroupId().compareTo(o2.getGroupId()) : 1;
                    }
                    return filter.isAscending() != false ? diff : -diff;
                }
            });
        } else if (filter.getOrderBy().equals("Version")) {
            Collections.sort(unitsIds, new Comparator<KModuleDeploymentUnitSummary>(){

                @Override
                public int compare(KModuleDeploymentUnitSummary o1, KModuleDeploymentUnitSummary o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = -1;
                    if (o1 != null) {
                        diff = o2 != null ? o1.getVersion().compareTo(o2.getVersion()) : 1;
                    }
                    return filter.isAscending() != false ? diff : -diff;
                }
            });
        } else if (filter.getOrderBy().equals("KieBaseName")) {
            Collections.sort(unitsIds, new Comparator<KModuleDeploymentUnitSummary>(){

                @Override
                public int compare(KModuleDeploymentUnitSummary o1, KModuleDeploymentUnitSummary o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = -1;
                    if (o1 != null) {
                        diff = o2 != null ? o1.getKbaseName().compareTo(o2.getKbaseName()) : 1;
                    }
                    return filter.isAscending() != false ? diff : -diff;
                }
            });
        } else if (filter.getOrderBy().equals("KieSessionName")) {
            Collections.sort(unitsIds, new Comparator<KModuleDeploymentUnitSummary>(){

                @Override
                public int compare(KModuleDeploymentUnitSummary o1, KModuleDeploymentUnitSummary o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = -1;
                    if (o1 != null) {
                        diff = o2 != null ? o1.getKsessionName().compareTo(o2.getKsessionName()) : 1;
                    }
                    return filter.isAscending() != false ? diff : -diff;
                }
            });
        } else if (filter.getOrderBy().equals("Strategy")) {
            Collections.sort(unitsIds, new Comparator<KModuleDeploymentUnitSummary>(){

                @Override
                public int compare(KModuleDeploymentUnitSummary o1, KModuleDeploymentUnitSummary o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = -1;
                    if (o1 != null) {
                        diff = o2 != null ? o1.getStrategy().compareTo(o2.getStrategy()) : 1;
                    }
                    return filter.isAscending() != false ? diff : -diff;
                }
            });
        }
    }

    public void saveDeployment(@Observes @Deploy DeploymentEvent event) {
        if (!this.gitDeploymentsEnabled) {
            return;
        }
        if (this.deploymentConfigService.getDeployment(event.getDeploymentId()) == null) {
            this.deploymentConfigService.addDeployment(event.getDeploymentId(), (Object)event.getDeployedUnit().getDeploymentUnit());
        }
    }

    public void removeDeployment(@Observes @Undeploy DeploymentEvent event) {
        if (!this.gitDeploymentsEnabled) {
            return;
        }
        this.deploymentConfigService.removeDeployment(event.getDeploymentId());
    }

    public void process(BuildResults buildResults) {
        if (!buildResults.getErrorMessages().isEmpty() || !this.autoDeployEnabled) {
            return;
        }
        try {
            String id = buildResults.getGAV().getGroupId() + ":" + buildResults.getGAV().getArtifactId() + ":" + buildResults.getGAV().getVersion();
            KModuleDeploymentUnitSummary unit = new KModuleDeploymentUnitSummary(id, buildResults.getGAV().getGroupId(), buildResults.getGAV().getArtifactId(), buildResults.getGAV().getVersion(), "", "", null, null);
            if (!(!this.deploymentService.isDeployed(id) || this.deploymentService.isDeployed(id) && this.overrideDeploymentsEnabled || id.contains("SNAPSHOT"))) {
                String[] gavElemes = unit.getId().split(":");
                GAV gav = new GAV(gavElemes[0], gavElemes[1], gavElemes[2]);
                BuildMessage message = new BuildMessage();
                message.setLevel(Level.ERROR);
                message.setText("Deployment of unit " + gav + " failed: unit already deployed! (override deployment: " + this.overrideDeploymentsEnabled + ")");
                buildResults.addBuildMessage(message);
                this.buildResultsEvent.fire((Object)buildResults);
                throw new DeploymentException("unit already deployed! (override deployment: " + this.overrideDeploymentsEnabled + ")", null);
            }
            this.undeploy((DeploymentUnitSummary)unit);
            this.deploy((DeploymentUnitSummary)unit);
        }
        catch (Exception e) {
            BuildMessage message = new BuildMessage();
            message.setLevel(Level.ERROR);
            message.setText("Deployment of unit " + buildResults.getGAV() + " failed: " + e.getMessage());
            buildResults.addBuildMessage(message);
            logger.error("Deployment of unit {} failed: {}", new Object[]{buildResults.getGAV(), e.getMessage(), e});
        }
    }

    public void undeployOnEvent(@Observes @Removed DeploymentConfigChangedEvent event) {
        String deploymentId = ((DeploymentUnit)event.getDeploymentUnit()).getIdentifier();
        try {
            this.undeploy((DeploymentUnit)event.getDeploymentUnit());
        }
        catch (RuntimeException e) {
            if (this.deploymentConfigService.getDeployment(deploymentId) == null) {
                this.deploymentConfigService.addDeployment(deploymentId, event.getDeploymentUnit());
            }
            throw e;
        }
    }

    public void deployOnEvent(@Observes @Added DeploymentConfigChangedEvent event) {
        this.deploy((DeploymentUnit)event.getDeploymentUnit());
    }

    public KModuleDeploymentUnitSummary getItem(KModuleKey key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<KModuleDeploymentUnitSummary> getAll(QueryFilter filter) {
        return this.getDeployedUnits(filter);
    }
}

