/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import javax.enterprise.event.Event;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jbpm.console.ng.bd.backend.server.DeploymentManagerEntryPointImpl;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DeploymentManagerEntryPointImplTest {
    @Mock
    private DeploymentService deploymentService;
    @Mock
    private GuvnorM2Repository guvnorM2Repository;
    @Mock
    private ConfigurationService configurationService;
    @Mock
    private Event<BuildResults> buildResultsEvent;
    @InjectMocks
    private DeploymentManagerEntryPointImpl deploymentManager;

    @Before
    public void setUp() {
        this.deploymentManager.configure();
    }

    @Test
    public void testDuplicateDeployment() {
        Mockito.when((Object)this.deploymentService.isDeployed(Mockito.anyString())).thenReturn((Object)true);
        GAV gav = new GAV("g:a:1");
        BuildResults result = new BuildResults(gav);
        this.deploymentManager.process(result);
        ((DeploymentService)Mockito.verify((Object)this.deploymentService, (VerificationMode)Mockito.atLeast((int)1))).isDeployed("g:a:1");
        ((DeploymentService)Mockito.verify((Object)this.deploymentService, (VerificationMode)Mockito.never())).undeploy((DeploymentUnit)Mockito.any(DeploymentUnit.class));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService, (VerificationMode)Mockito.never())).deploy((DeploymentUnit)Mockito.any(DeploymentUnit.class));
        Assert.assertNotEquals((long)0L, (long)result.getErrorMessages().size());
        for (BuildMessage msg : result.getErrorMessages()) {
            Assert.assertTrue((String)msg.getText(), (boolean)msg.getText().contains("already deployed"));
        }
    }
}

