/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.documents.backend.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.jbpm.console.ng.dm.model.DocumentSummary;
import org.jbpm.console.ng.documents.backend.server.DocumentService;

public class DocumentViewServlet
extends HttpServlet {
    private static final long serialVersionUID = -3950781302033089580L;
    @Inject
    private DocumentService documentService;

    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        int length;
        ServletOutputStream out = response.getOutputStream();
        InputStream in = this.documentService.getDocumentContent(req.getParameter("documentId"));
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) > 0) {
            out.write(buffer, 0, length);
        }
        String documentName = req.getParameter("documentId");
        response.setHeader("Content-disposition", "attachment; filename=" + documentName);
        in.close();
        out.flush();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            FileItem file = null;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setHeaderEncoding("UTF-8");
            List items = upload.parseRequest(request);
            Iterator it = items.iterator();
            String folder = "/";
            while (it.hasNext()) {
                FileItem item = (FileItem)it.next();
                if (!item.isFormField()) {
                    file = item;
                    continue;
                }
                if (!"documentFolder".equals(item.getFieldName())) continue;
                folder = item.getString();
            }
            response.getWriter().write(this.processUpload(file, folder));
            response.setContentType("text/html");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String processUpload(FileItem uploadItem, String folder) throws IOException {
        if ("".equals(uploadItem.getName())) {
            throw new IOException("No file selected.");
        }
        this.uploadFile(uploadItem, folder);
        uploadItem.getInputStream().close();
        return "OK";
    }

    private void uploadFile(FileItem uploadItem, String folder) throws IOException {
        InputStream fileData = uploadItem.getInputStream();
        try {
            if (!fileData.markSupported()) {
                fileData = new BufferedInputStream(fileData);
            }
            fileData.mark(fileData.available());
            byte[] bytes = IOUtils.toByteArray((InputStream)fileData);
            DocumentSummary documenSummary = new DocumentSummary(uploadItem.getName(), "", folder);
            documenSummary.setContent(bytes);
            this.documentService.createDocument(documenSummary);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

