/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.documents.backend.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.CXFPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.SunRIPortProvider;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.dm.model.CMSContentSummary;
import org.jbpm.console.ng.dm.model.DocumentSummary;
import org.jbpm.console.ng.dm.model.FolderSummary;
import org.jbpm.console.ng.documents.backend.server.DocumentService;

@Service
@ApplicationScoped
public class DocumentServiceCMISImpl
implements DocumentService {
    private Map<String, String> parameters;
    private Session session;

    @Override
    @PostConstruct
    public void init() {
        this.parameters = new HashMap<String, String>();
        String webServicesACLServices = "http://localhost:8080/magnoliaAuthor/.magnolia/cmisws/ACLService?wsdl";
        String webServicesDiscoveryServices = "http://localhost:8080/cmis/services/DiscoveryService?wsdl";
        String webServicesMultifilingServices = "http://localhost:8080/magnoliaAuthor/.magnolia/cmisws/MultiFilingService?wsdl";
        String webServicesNavigationServices = "http://localhost:8080/magnoliaAuthor/.magnolia/cmisws/NavigationService?wsdl";
        String webServicesObjectServices = "http://localhost:8080/magnoliaAuthor/.magnolia/cmisws/ObjectService?wsdl";
        String webServicesPolicyServices = "http://localhost:8080/magnoliaAuthor/.magnolia/cmisws/PolicyService?wsdl";
        String webServicesRelationshipServices = "http://localhost:8080/magnoliaAuthor/.magnolia/cmisws/RelationshipService?wsdl";
        String webServicesRepositoryServices = "http://localhost:8080/magnoliaAuthor/.magnolia/cmisws/RepositoryService?wsdl";
        String webServicesVersioningServices = "http://localhost:8080/magnoliaAuthor/.magnolia/cmisws/VersioningService?wsdl";
        String repositoryID = "dms";
        this.parameters.put("org.apache.chemistry.opencmis.user", "superuser");
        this.parameters.put("org.apache.chemistry.opencmis.password", "superuser");
        this.parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", webServicesACLServices);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", webServicesDiscoveryServices);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", webServicesMultifilingServices);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", webServicesNavigationServices);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", webServicesObjectServices);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", webServicesPolicyServices);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", webServicesRelationshipServices);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", webServicesRepositoryServices);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", webServicesVersioningServices);
        this.parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryID);
        this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.portprovider.classname", SunRIPortProvider.class.getName());
    }

    @Override
    public Map<String, String> getConfigurationParameters() {
        return this.parameters;
    }

    @Override
    public void setConfigurationParameters(Map<String, String> parameters) {
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.portprovider.classname", SunRIPortProvider.class.getName());
        this.parameters = parameters;
        this.createSession();
        if (this.session == null) {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.portprovider.classname", CXFPortProvider.class.getName());
            this.parameters = parameters;
            this.createSession();
        }
    }

    private Session getSession() {
        if (this.session == null) {
            this.setConfigurationParameters(this.parameters);
            this.session = this.createSession();
        }
        return this.session;
    }

    private Session createSession() {
        try {
            SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
            this.session = factory.createSession(this.parameters);
        }
        catch (Exception e) {
            this.session = null;
        }
        return this.session;
    }

    @Override
    public List<CMSContentSummary> getChildren(String id) {
        Session session = this.getSession();
        if (session != null) {
            Folder folder = null;
            folder = id == null || id.isEmpty() ? session.getRootFolder() : (Folder)session.getObject(id);
            ItemIterable children = folder.getChildren();
            Iterator childrenItems = children.iterator();
            ArrayList<CmisObject> documents = new ArrayList<CmisObject>();
            while (childrenItems.hasNext()) {
                CmisObject item = (CmisObject)childrenItems.next();
                documents.add(item);
            }
            return this.transform(documents, folder);
        }
        return new ArrayList<CMSContentSummary>();
    }

    @Override
    public InputStream getDocumentContent(String id) {
        Session session = this.getSession();
        if (session != null) {
            if (id == null || id.isEmpty()) {
                throw new IllegalArgumentException("No id provided");
            }
            Document document = (Document)session.getObject(id);
            if (document == null) {
                throw new IllegalArgumentException("Document with this id does not exist");
            }
            return document.getContentStream().getStream();
        }
        return null;
    }

    @Override
    public void removeDocument(final String id) {
        Session session = this.getSession();
        if (session != null) {
            session.delete(new ObjectId(){

                public String getId() {
                    return id;
                }
            });
        }
    }

    public List<CMSContentSummary> transform(List<CmisObject> children, Folder folder) {
        ArrayList<CMSContentSummary> documents = new ArrayList<CMSContentSummary>();
        for (CmisObject item : children) {
            documents.add(this.transform(item, folder));
        }
        return documents;
    }

    public CMSContentSummary transform(CmisObject object, Folder parentFolder) {
        DocumentSummary doc = null;
        if (object.getType().getId().equals("cmis:folder")) {
            Folder folder = (Folder)object;
            doc = new FolderSummary(object.getName(), object.getId(), folder.getPath());
            Folder parent = (Folder)((Folder)object).getParents().get(0);
            FolderSummary parentFolderSummary = new FolderSummary(parent.getName(), parent.getId(), parent.getPath());
            if (parentFolder != null && parentFolder.getParents().size() > 0) {
                Folder grandParent = (Folder)parentFolder.getParents().get(0);
                parentFolderSummary.setParent((CMSContentSummary)new FolderSummary(grandParent.getName(), grandParent.getId(), grandParent.getPath()));
            }
            doc.setParent((CMSContentSummary)parentFolderSummary);
        } else {
            doc = new DocumentSummary(object.getName(), object.getId(), null);
            Folder parent = (Folder)((Document)object).getParents().get(0);
            FolderSummary parentFolderSummary = new FolderSummary(parent.getName(), parent.getId(), parent.getPath());
            if (parentFolder != null && parentFolder.getParents().size() > 0) {
                Folder grandParent = (Folder)parentFolder.getParents().get(0);
                parentFolderSummary.setParent((CMSContentSummary)new FolderSummary(grandParent.getName(), grandParent.getId(), grandParent.getPath()));
            }
            doc.setParent((CMSContentSummary)parentFolderSummary);
        }
        return doc;
    }

    @Override
    public CMSContentSummary getDocument(String id) {
        Session session = this.getSession();
        if (session != null) {
            Document document = null;
            if (id != null && !id.isEmpty()) {
                document = (Document)session.getObject(id);
            }
            if (document.getParents() != null && document.getParents().size() > 0) {
                return this.transform((CmisObject)document, (Folder)document.getParents().get(0));
            }
            return this.transform((CmisObject)document, null);
        }
        return new DocumentSummary();
    }

    @Override
    public void createDocument(DocumentSummary doc) {
        Session session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("Could not get CMIS session");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:document");
        properties.put("cmis:name", doc.getName());
        ByteArrayInputStream stream = new ByteArrayInputStream(doc.getContent());
        ContentStreamImpl contentStream = new ContentStreamImpl(doc.getName(), BigInteger.valueOf(doc.getContent().length), MimeTypes.getMIMEType((String)doc.getName()), (InputStream)stream);
        Document createdDoc = ((Folder)session.getObjectByPath(doc.getPath())).createDocument(properties, (ContentStream)contentStream, VersioningState.NONE);
        doc.setId(createdDoc.getId());
    }

    @Override
    public Boolean testConnection() {
        Session session = this.getSession();
        if (session != null && session.getRootFolder() != null) {
            return true;
        }
        return false;
    }
}

