/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.dm.client.document.details;

import com.github.gwtbootstrap.client.ui.Button;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.dm.client.i18n.Constants;
import org.jbpm.console.ng.dm.model.CMSContentSummary;
import org.jbpm.console.ng.dm.model.events.DocumentDefSelectionEvent;
import org.jbpm.console.ng.dm.service.DocumentServiceEntryPoint;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.split.WorkbenchSplitLayoutPanel;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Document Details")
public class DocumentDetailsPresenter {
    private PlaceRequest place;
    private Menus menus;
    private static String linkURL = "http://127.0.0.1:8888/documentview";
    @Inject
    private PlaceManager placeManager;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private DocumentDetailsView view;
    @Inject
    private Caller<DocumentServiceEntryPoint> dataServices;
    private CMSContentSummary document;

    public DocumentDetailsPresenter() {
        this.makeMenuBar();
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Document Details";
    }

    @WorkbenchPartView
    public UberView<DocumentDetailsPresenter> getView() {
        return this.view;
    }

    private void changeStyleRow(String processDefName, String processDefVersion) {
    }

    public void refreshProcessDef(String documentId) {
        ((DocumentServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<CMSContentSummary>(){

            public void callback(CMSContentSummary content) {
                DocumentDetailsPresenter.this.document = content;
                DocumentDetailsPresenter.this.view.getDocumentIdText().setText(content.getId());
                DocumentDetailsPresenter.this.view.getDocumentNameText().setText(content.getName());
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getDocument(documentId);
    }

    @OnOpen
    public void onOpen() {
        WorkbenchSplitLayoutPanel splitPanel = (WorkbenchSplitLayoutPanel)this.view.asWidget().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent();
        splitPanel.setWidgetMinSize(splitPanel.getWidget(0), 500);
    }

    public void onDocumentDefSelectionEvent(@Observes DocumentDefSelectionEvent event) {
        this.refreshProcessDef(event.getDocumentId());
    }

    public void downloadDocument() {
        if (this.document != null) {
            Window.open((String)(linkURL + "?documentId=" + this.document.getId() + "&documentName=" + this.document.getName()), (String)"_blank", (String)"");
        }
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    private void makeMenuBar() {
    }

    private List<MenuItem> getOptions() {
        return null;
    }

    public static interface DocumentDetailsView
    extends UberView<DocumentDetailsPresenter> {
        public void displayNotification(String var1);

        public HTML getDocumentNameText();

        public HTML getDocumentIdText();

        public Button getOpenDocumentButton();
    }
}

