/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.TransactionInterceptor;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.ht.backend.server.CommentSummaryHelper;
import org.jbpm.console.ng.ht.backend.server.TaskEventSummaryHelper;
import org.jbpm.console.ng.ht.backend.server.TaskI18NHelper;
import org.jbpm.console.ng.ht.backend.server.TaskSummaryHelper;
import org.jbpm.console.ng.ht.model.CommentSummary;
import org.jbpm.console.ng.ht.model.Day;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskServiceEntryPoint;
import org.jbpm.services.task.audit.TaskAuditService;
import org.jbpm.services.task.impl.factories.TaskFactory;
import org.jbpm.services.task.impl.model.CommentImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.SubTasksStrategy;

@Service
@ApplicationScoped
@Transactional
@Interceptors(value={TransactionInterceptor.class})
public class TaskServiceEntryPointImpl
implements TaskServiceEntryPoint {
    @Inject
    private InternalTaskService taskService;
    @Inject
    private TaskAuditService taskAudit;

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<String> status, Date from, String language) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : status) {
            statuses.add(Status.valueOf((String)s));
        }
        List<TaskSummary> taskSummaries = null;
        taskSummaries = from != null ? TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsPotentialOwnerByExpirationDateOptional(userId, statuses, from)) : TaskSummaryHelper.adaptCollection(this.taskService.getTasksAssignedAsPotentialOwnerByStatus(userId, statuses, "en-UK"));
        this.setPotentionalOwners(taskSummaries);
        return taskSummaries;
    }

    private void setPotentionalOwners(List<TaskSummary> taskSummaries) {
        ArrayList<Long> taskIds = new ArrayList<Long>(taskSummaries.size());
        for (TaskSummary ts : taskSummaries) {
            taskIds.add(ts.getId());
        }
        if (taskIds.size() > 0) {
            Map<Long, List<String>> potentialOwnersForTaskIds = this.getPotentialOwnersForTaskIds(taskIds);
            for (TaskSummary ts : taskSummaries) {
                ts.setPotentialOwners(potentialOwnersForTaskIds.get(ts.getId()));
            }
        }
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<String> status, Date from, String language) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : status) {
            statuses.add(Status.valueOf((String)s));
        }
        List<TaskSummary> taskSummaries = TaskSummaryHelper.adaptCollection(this.taskService.getTasksOwnedByStatus(userId, statuses, "en-UK"));
        this.setPotentionalOwners(taskSummaries);
        return taskSummaries;
    }

    public Map<Long, List<String>> getPotentialOwnersForTaskIds(List<Long> taskIds) {
        Map potentialOwnersForTaskIds = this.taskService.getPotentialOwnersForTaskIds(taskIds);
        HashMap<Long, List<String>> potentialOwnersForTaskIdsSimple = new HashMap<Long, List<String>>();
        for (Long taskId : potentialOwnersForTaskIds.keySet()) {
            List orgEntities = (List)potentialOwnersForTaskIds.get(taskId);
            ArrayList<String> orgEntitiesSimple = new ArrayList<String>(orgEntities.size());
            for (OrganizationalEntity entity : orgEntities) {
                if (entity instanceof Group) {
                    orgEntitiesSimple.add("Group:" + entity.getId());
                    continue;
                }
                if (!(entity instanceof User)) continue;
                orgEntitiesSimple.add("User:" + entity.getId());
            }
            potentialOwnersForTaskIdsSimple.put(taskId, orgEntitiesSimple);
        }
        return potentialOwnersForTaskIdsSimple;
    }

    public Map<Day, List<TaskSummary>> getTasksOwnedFromDateToDateByDays(String userId, List<String> strStatuses, Date dateFrom, Date dateTo, String language) {
        LocalDate dayFrom = new LocalDate((Object)dateFrom);
        LocalDate dayTo = new LocalDate((Object)dateTo);
        LocalDate today = new LocalDate();
        int nrOfDaysTotal = this.getNumberOfDaysWithinDateRange(dayFrom, dayTo);
        Map<LocalDate, List<TaskSummary>> tasksByDay = this.createDaysMapAndInitWithEmptyListForEachDay(dayFrom, nrOfDaysTotal);
        List<TaskSummary> taskSummaries = this.adaptTaskSummaryCollection(this.taskService.getTasksOwnedByStatus(userId, this.convertStatuses(strStatuses), language));
        this.setPotentionalOwners(taskSummaries);
        this.fillDaysMapWithTasksBasedOnExpirationDate(tasksByDay, taskSummaries, today);
        return this.transformLocalDatesToDays(tasksByDay);
    }

    private void fillDaysMapWithTasksBasedOnExpirationDate(Map<LocalDate, List<TaskSummary>> tasksByDay, List<TaskSummary> taskSummaries, LocalDate today) {
        for (TaskSummary taskSummary : taskSummaries) {
            LocalDate expDate = taskSummary.getExpirationTime() == null ? today : new LocalDate((Object)taskSummary.getExpirationTime());
            if (tasksByDay.get(expDate) == null) continue;
            tasksByDay.get(expDate).add(taskSummary);
        }
    }

    private Map<LocalDate, List<TaskSummary>> createDaysMapAndInitWithEmptyListForEachDay(LocalDate dayFrom, int nrOfDaysTotal) {
        LinkedHashMap<LocalDate, List<TaskSummary>> tasksByDay = new LinkedHashMap<LocalDate, List<TaskSummary>>();
        for (int i = 0; i < nrOfDaysTotal; ++i) {
            tasksByDay.put(dayFrom.plusDays(i), new ArrayList());
        }
        return tasksByDay;
    }

    private int getNumberOfDaysWithinDateRange(LocalDate dayFrom, LocalDate dayTo) {
        Days daysBetween = Days.daysBetween((ReadablePartial)dayFrom, (ReadablePartial)dayTo);
        return daysBetween.getDays() + 1;
    }

    private List<Status> convertStatuses(List<String> strStatuses) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : strStatuses) {
            statuses.add(Status.valueOf((String)s));
        }
        return statuses;
    }

    List<TaskSummary> adaptTaskSummaryCollection(List<org.kie.api.task.model.TaskSummary> taskSummaries) {
        return TaskSummaryHelper.adaptCollection(taskSummaries);
    }

    private Map<Day, List<TaskSummary>> transformLocalDatesToDays(Map<LocalDate, List<TaskSummary>> tasksByLocalDate) {
        LinkedHashMap<Day, List<TaskSummary>> tasksByDay = new LinkedHashMap<Day, List<TaskSummary>>();
        SimpleDateFormat dayFormat = new SimpleDateFormat("EEEE dd");
        for (Map.Entry<LocalDate, List<TaskSummary>> entry : tasksByLocalDate.entrySet()) {
            Date dayDate = entry.getKey().toDateMidnight().toDate();
            tasksByDay.put(new Day(dayDate, dayFormat.format(dayDate)), entry.getValue());
        }
        return tasksByDay;
    }

    public Map<Day, List<TaskSummary>> getTasksAssignedAsPotentialOwnerFromDateToDateByDays(String userId, List<String> strStatuses, Date from, int nrOfDaysTotal, String language) {
        Date toDate = this.getEndDateBasedOnStartDateAndNumberOfDaysBetweenThem(from, nrOfDaysTotal);
        return this.getTasksAssignedAsPotentialOwnerFromDateToDateByDays(userId, strStatuses, from, toDate, language);
    }

    public Map<Day, List<TaskSummary>> getTasksAssignedAsPotentialOwnerFromDateToDateByDays(String userId, List<String> strStatuses, Date dateFrom, Date dateTo, String language) {
        LocalDate dayFrom = new LocalDate((Object)dateFrom);
        LocalDate dayTo = new LocalDate((Object)dateTo);
        LocalDate today = new LocalDate();
        int nrOfDaysTotal = this.getNumberOfDaysWithinDateRange(dayFrom, dayTo);
        Map<LocalDate, List<TaskSummary>> tasksByDay = this.createDaysMapAndInitWithEmptyListForEachDay(dayFrom, nrOfDaysTotal);
        List<TaskSummary> taskSummaries = this.adaptTaskSummaryCollection(this.taskService.getTasksAssignedAsPotentialOwnerByStatus(userId, this.convertStatuses(strStatuses), language));
        this.setPotentionalOwners(taskSummaries);
        this.fillDaysMapWithTasksBasedOnExpirationDate(tasksByDay, taskSummaries, today);
        return this.transformLocalDatesToDays(tasksByDay);
    }

    public Map<Day, List<TaskSummary>> getTasksOwnedFromDateToDateByDays(String userId, List<String> strStatuses, Date from, int nrOfDaysTotal, String language) {
        Date toDate = this.getEndDateBasedOnStartDateAndNumberOfDaysBetweenThem(from, nrOfDaysTotal);
        return this.getTasksOwnedFromDateToDateByDays(userId, strStatuses, from, toDate, language);
    }

    private Date getEndDateBasedOnStartDateAndNumberOfDaysBetweenThem(Date from, int nrOfDaysTotal) {
        return new LocalDate(from.getTime()).plusDays(nrOfDaysTotal - 1).toDateMidnight().toDate();
    }

    public Map<Day, List<TaskSummary>> getTasksOwnedFromDateToDateByDays(String userId, Date from, Date to, String language) {
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add("InProgress");
        statuses.add("Reserved");
        statuses.add("Created");
        return this.getTasksOwnedFromDateToDateByDays(userId, statuses, from, to, language);
    }

    public List<TaskSummary> getTasksAssignedByGroup(String userId, String groupId, String language) {
        List tasksAssignedAsPotentialOwner = this.taskService.getTasksAssignedAsPotentialOwner(userId, language);
        ArrayList<org.kie.api.task.model.TaskSummary> taskForGroup = new ArrayList<org.kie.api.task.model.TaskSummary>();
        for (org.kie.api.task.model.TaskSummary ts : tasksAssignedAsPotentialOwner) {
            if (!ts.getPotentialOwners().contains(groupId)) continue;
            taskForGroup.add(ts);
        }
        return TaskSummaryHelper.adaptCollection(taskForGroup);
    }

    public long addTask(String taskString, Map<String, Object> inputs, Map<String, Object> templateVars) {
        TaskImpl task = TaskFactory.evalTask((String)taskString, templateVars);
        return this.taskService.addTask((Task)task, inputs);
    }

    public long addTaskAndStart(String taskString, Map<String, Object> inputs, String userId, Map<String, Object> templateVars) {
        long taskId = this.addTask(taskString, inputs, templateVars);
        this.taskService.start(taskId, userId);
        return taskId;
    }

    public long addTaskAndClaimAndStart(String taskString, Map<String, Object> inputs, String userId, Map<String, Object> templateVars) {
        long taskId = this.addTask(taskString, inputs, templateVars);
        this.taskService.claim(taskId, userId);
        this.taskService.start(taskId, userId);
        return taskId;
    }

    public void start(long taskId, String user) {
        this.taskService.start(taskId, user);
    }

    public void startBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.start(taskId.longValue(), user);
        }
    }

    public void forward(long taskId, String userId, String targetEntityId) {
        this.taskService.forward(taskId, userId, targetEntityId);
    }

    public void delegate(long taskId, String userId, String targetEntityId) {
        this.taskService.delegate(taskId, userId, targetEntityId);
    }

    public void complete(long taskId, String user, Map<String, Object> params) {
        this.taskService.complete(taskId, user, params);
    }

    public void claim(long taskId, String user) {
        this.taskService.claim(taskId, user);
    }

    public void release(long taskId, String user) {
        this.taskService.release(taskId, user);
    }

    public void setPriority(long taskId, int priority) {
        this.taskService.setPriority(taskId, priority);
    }

    public void setTaskNames(long taskId, List<String> taskNames) {
        this.taskService.setTaskNames(taskId, TaskI18NHelper.adaptI18NList(taskNames));
    }

    public void setExpirationDate(long taskId, Date date) {
        this.taskService.setExpirationDate(taskId, date);
    }

    public void setDescriptions(long taskId, List<String> descriptions) {
        this.taskService.setDescriptions(taskId, TaskI18NHelper.adaptI18NList(descriptions));
    }

    public void setSkipable(long taskId, boolean skipable) {
        this.taskService.setSkipable(taskId, skipable);
    }

    public void setSubTaskStrategy(long taskId, String strategy) {
        this.taskService.setSubTaskStrategy(taskId, SubTasksStrategy.valueOf((String)strategy));
    }

    public int getPriority(long taskId) {
        return this.taskService.getPriority(taskId);
    }

    public Date getExpirationDate(long taskId) {
        return this.taskService.getExpirationDate(taskId);
    }

    public List<String> getDescriptions(long taskId) {
        return TaskI18NHelper.adaptStringList(this.taskService.getDescriptions(taskId));
    }

    public boolean isSkipable(long taskId) {
        return this.taskService.isSkipable(taskId);
    }

    public String getSubTaskStrategy(long taskId) {
        return this.taskService.getSubTaskStrategy(taskId).name();
    }

    public TaskSummary getTaskDetails(long taskId) {
        Task task = this.taskService.getTaskById(taskId);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> potOwnersString = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity e : potentialOwners) {
            potOwnersString.add(e.getId());
        }
        return new TaskSummary(task.getId().longValue(), task.getTaskData().getProcessInstanceId(), task.getNames() != null && task.getNames().size() > 0 ? ((I18NText)task.getNames().get(0)).getText() : "", task.getSubjects() != null && task.getSubjects().size() > 0 ? ((I18NText)task.getSubjects().get(0)).getText() : "", task.getDescriptions() != null && task.getDescriptions().size() > 0 ? ((I18NText)task.getDescriptions().get(0)).getText() : "", task.getTaskData().getStatus().name(), task.getPriority(), task.getTaskData().isSkipable(), task.getTaskData().getActualOwner() != null ? task.getTaskData().getActualOwner().getId() : "", task.getTaskData().getCreatedBy() != null ? task.getTaskData().getCreatedBy().getId() : "", task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), ((InternalTask)task).getSubTaskStrategy().name(), (int)task.getTaskData().getParentId(), potOwnersString);
    }

    public long saveContent(long taskId, Map<String, String> values) {
        return this.addContent(taskId, values);
    }

    public long addContent(long taskId, Content content) {
        return this.taskService.addContent(taskId, content);
    }

    public long addContent(long taskId, Map<String, Object> values) {
        return this.taskService.addContent(taskId, values);
    }

    public void deleteContent(long taskId, long contentId) {
        this.taskService.deleteContent(taskId, contentId);
    }

    public List<Content> getAllContentByTaskId(long taskId) {
        return this.taskService.getAllContentByTaskId(taskId);
    }

    public Content getContentById(long contentId) {
        return this.taskService.getContentById(contentId);
    }

    public Map<String, String> getContentListById(long contentId) {
        Content contentById = this.getContentById(contentId);
        Object unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
        return (Map)unmarshall;
    }

    public Map<String, String> getContentListByTaskId(long taskId) {
        Task taskInstanceById = this.taskService.getTaskById(taskId);
        long documentContentId = taskInstanceById.getTaskData().getDocumentContentId();
        Content contentById = this.getContentById(documentContentId);
        if (contentById == null) {
            return new HashMap<String, String>();
        }
        Object unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
        if (unmarshall instanceof String && ((String)unmarshall).equals("")) {
            return new HashMap<String, String>();
        }
        return (Map)unmarshall;
    }

    public Map<String, String> getTaskOutputContentByTaskId(long taskId) {
        Task taskInstanceById = this.taskService.getTaskById(taskId);
        long documentContentId = taskInstanceById.getTaskData().getOutputContentId();
        if (documentContentId > 0L) {
            Content contentById = this.getContentById(documentContentId);
            if (contentById == null) {
                return new HashMap<String, String>();
            }
            Object unmarshall = ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
            return (Map)unmarshall;
        }
        return new HashMap<String, String>();
    }

    public long addComment(long taskId, String text, String addedBy, Date addedOn) {
        CommentImpl comment = new CommentImpl();
        comment.setText(text);
        comment.setAddedAt(addedOn);
        comment.setAddedBy((User)new UserImpl(addedBy));
        return this.taskService.addComment(taskId, (Comment)comment);
    }

    public void deleteComment(long taskId, long commentId) {
        this.taskService.deleteComment(taskId, commentId);
    }

    public List<CommentSummary> getAllCommentsByTaskId(long taskId) {
        return CommentSummaryHelper.adaptCollection(this.taskService.getAllCommentsByTaskId(taskId));
    }

    public CommentSummary getCommentById(long commentId) {
        return CommentSummaryHelper.adapt(this.taskService.getCommentById(commentId));
    }

    public void updateSimpleTaskDetails(long taskId, List<String> taskNames, int priority, List<String> taskDescription, Date dueDate) {
        this.setPriority(taskId, priority);
        this.setTaskNames(taskId, taskNames);
        this.setDescriptions(taskId, taskDescription);
        this.setExpirationDate(taskId, dueDate);
    }

    public void claimBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.claim(taskId.longValue(), user);
            this.taskService.start(taskId.longValue(), user);
        }
    }

    public void completeBatch(List<Long> taskIds, String user, Map<String, Object> params) {
        for (Long taskId : taskIds) {
            this.taskService.complete(taskId.longValue(), user, params);
        }
    }

    public void releaseBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.release(taskId.longValue(), user);
        }
    }

    public List<TaskEventSummary> getAllTaskEvents(long taskId) {
        return TaskEventSummaryHelper.adaptCollection(this.taskAudit.getAllTaskEvents(taskId));
    }
}

