/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.integration.AbstractKieServerService;
import org.jbpm.console.ng.ht.model.CommentSummary;
import org.jbpm.console.ng.ht.model.TaskAssignmentSummary;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.service.TaskService;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.instance.TaskComment;
import org.kie.server.api.model.instance.TaskEventInstance;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.UserTaskServicesClient;

@Service
@ApplicationScoped
public class RemoteTaskServiceImpl
extends AbstractKieServerService
implements TaskService {
    @Inject
    private IdentityProvider identityProvider;

    public List<org.jbpm.console.ng.ht.model.TaskSummary> getActiveTasks(String serverTemplateId, Integer page, Integer pageSize) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        List tasks = client.findTasksAssignedAsPotentialOwner(this.identityProvider.getName(), page, pageSize);
        return tasks.stream().map(t -> this.build((TaskSummary)t)).collect(Collectors.toList());
    }

    public org.jbpm.console.ng.ht.model.TaskSummary getTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        try {
            TaskInstance task = client.getTaskInstance(containerId, taskId);
            return this.build(task);
        }
        catch (KieServicesException e) {
            return null;
        }
    }

    public void updateTask(String serverTemplateId, String containerId, Long taskId, Integer priority, String description, Date dueDate) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.setTaskDescription(containerId, taskId, description);
        client.setTaskPriority(containerId, taskId, priority.intValue());
        client.setTaskExpirationDate(containerId, taskId, dueDate);
    }

    public void claimTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.claimTask(containerId, taskId, this.identityProvider.getName());
    }

    public void releaseTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.releaseTask(containerId, taskId, this.identityProvider.getName());
    }

    public void startTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.startTask(containerId, taskId, this.identityProvider.getName());
    }

    public void completeTask(String serverTemplateId, String containerId, Long taskId, Map<String, Object> output) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.completeTask(containerId, taskId, this.identityProvider.getName(), output);
    }

    public void saveTaskContent(String serverTemplateId, String containerId, Long taskId, Map<String, Object> output) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.saveTaskContent(containerId, taskId, output);
    }

    public void addTaskComment(String serverTemplateId, String containerId, Long taskId, String text, Date addedOn) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.addTaskComment(containerId, taskId, text, this.identityProvider.getName(), addedOn);
    }

    public void deleteTaskComment(String serverTemplateId, String containerId, Long taskId, Long commentId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.deleteTaskComment(containerId, taskId, commentId);
    }

    public List<CommentSummary> getTaskComments(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        List comments = client.getTaskCommentsByTaskId(containerId, taskId);
        return comments.stream().map(c -> this.build((TaskComment)c)).collect(Collectors.toList());
    }

    public List<TaskEventSummary> getTaskEvents(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        List events = client.findTaskEvents(taskId, Integer.valueOf(0), Integer.valueOf(1000));
        return events.stream().map(e -> this.build((TaskEventInstance)e)).collect(Collectors.toList());
    }

    public void delegate(String serverTemplateId, String containerId, Long taskId, String entity) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.delegateTask(containerId, taskId, this.identityProvider.getName(), entity);
    }

    public TaskAssignmentSummary getTaskAssignmentDetails(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        try {
            TaskInstance task = client.getTaskInstance(containerId, taskId, false, false, true);
            TaskAssignmentSummary summary = new TaskAssignmentSummary();
            summary.setTaskId(task.getId());
            summary.setActualOwner(task.getActualOwner());
            summary.setTaskName(task.getName());
            summary.setPotOwnersString(task.getPotentialOwners());
            summary.setCreatedBy(task.getCreatedBy());
            summary.setBusinessAdmins(task.getBusinessAdmins());
            summary.setStatus(task.getStatus());
            summary.setDelegationAllowed(this.isDelegationAllowed(task).booleanValue());
            return summary;
        }
        catch (KieServicesException e) {
            return null;
        }
    }

    protected Boolean isDelegationAllowed(TaskInstance task) {
        if (task == null) {
            return false;
        }
        if ("Completed".equals(task.getStatus())) {
            return false;
        }
        String actualOwner = task.getActualOwner();
        if (actualOwner != null && actualOwner.equals(this.identityProvider.getName())) {
            return true;
        }
        String initiator = task.getCreatedBy();
        if (initiator != null && initiator.equals(this.identityProvider.getName())) {
            return true;
        }
        List roles = this.identityProvider.getRoles();
        List potentialOwners = task.getPotentialOwners();
        if (potentialOwners != null && !Collections.disjoint(potentialOwners, roles)) {
            return true;
        }
        List businessAdministrators = task.getBusinessAdmins();
        if (businessAdministrators != null && !Collections.disjoint(businessAdministrators, roles)) {
            return true;
        }
        return false;
    }

    public void executeReminderForTask(String serverTemplateId, String containerId, Long taskId, String fromUser) {
    }

    protected org.jbpm.console.ng.ht.model.TaskSummary build(TaskSummary task) {
        org.jbpm.console.ng.ht.model.TaskSummary taskSummary = new org.jbpm.console.ng.ht.model.TaskSummary(task.getId().longValue(), task.getName(), task.getDescription(), task.getStatus(), task.getPriority().intValue(), task.getActualOwner(), task.getCreatedBy(), task.getCreatedOn(), task.getActivationTime(), task.getExpirationTime(), task.getProcessId(), -1L, task.getProcessInstanceId().longValue(), task.getContainerId(), task.getParentId().longValue(), false);
        return taskSummary;
    }

    protected org.jbpm.console.ng.ht.model.TaskSummary build(TaskInstance task) {
        if (task == null) {
            return null;
        }
        org.jbpm.console.ng.ht.model.TaskSummary taskSummary = new org.jbpm.console.ng.ht.model.TaskSummary(task.getId().longValue(), task.getName(), task.getDescription(), task.getStatus(), task.getPriority().intValue(), task.getActualOwner(), task.getCreatedBy(), task.getCreatedOn(), task.getActivationTime(), task.getExpirationDate(), task.getProcessId(), -1L, task.getProcessInstanceId().longValue(), task.getContainerId(), task.getParentId().longValue(), false);
        return taskSummary;
    }

    protected CommentSummary build(TaskComment comment) {
        CommentSummary summary = new CommentSummary(comment.getId().longValue(), comment.getText(), comment.getAddedBy(), comment.getAddedAt());
        return summary;
    }

    protected TaskEventSummary build(TaskEventInstance event) {
        TaskEventSummary summary = new TaskEventSummary(event.getId(), event.getTaskId(), event.getType(), event.getUserId(), event.getWorkItemId(), event.getLogTime(), event.getMessage());
        return summary;
    }
}

