/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.quicknewtask;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.ControlLabel;
import com.github.gwtbootstrap.client.ui.HelpBlock;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBox;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.events.NewTaskEvent;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.service.TaskFormManagementService;
import org.jbpm.console.ng.ht.service.TaskOperationsService;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class QuickNewTaskPopup
extends BaseModal {
    @UiField
    public TabPanel tabPanel;
    @UiField
    public Tab basicTab;
    @UiField
    public Tab advancedTab;
    @UiField
    public Button addUserButton;
    @UiField
    public Button addGroupButton;
    @UiField
    public TextBox taskNameText;
    @UiField
    public ControlGroup taskNameControlGroup;
    @UiField
    public UTCDateBox dueDate;
    @UiField
    public UTCTimeBox dueDateTime;
    @UiField
    public HelpBlock taskNameHelpLabel;
    @UiField
    public ListBox taskPriorityListBox;
    @UiField
    public FlowPanel usersGroupsControlsPanel;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public ControlGroup errorMessagesGroup;
    @UiField
    public ListBox taskFormDeploymentId;
    @UiField
    public ControlGroup taskFormDeploymentIdControlGroup;
    @UiField
    public HelpBlock taskFormDeploymentIdHelpLabel;
    @UiField
    public ListBox taskFormName;
    @UiField
    public ControlGroup taskFormNameControlGroup;
    @UiField
    public HelpBlock taskFormNameHelpLabel;
    @Inject
    User identity;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Event<TaskRefreshedEvent> taskRefreshed;
    @Inject
    private Event<NewTaskEvent> newTaskEvent;
    @Inject
    private Caller<TaskOperationsService> taskOperationsService;
    @Inject
    private Caller<TaskFormManagementService> taskFormManagementService;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private HandlerRegistration textKeyPressHandler;
    private final List<ControlGroup> userControlGroups = new ArrayList<ControlGroup>();
    private final List<ControlGroup> groupControlGroups = new ArrayList<ControlGroup>();
    private String[] priorities = new String[]{"0 - " + Constants.INSTANCE.High(), "1", "2", "3", "4", "5 - " + Constants.INSTANCE.Medium(), "6", "7", "8", "9", "10 - " + Constants.INSTANCE.Low()};
    private Long processInstanceId = -1L;

    public QuickNewTaskPopup() {
        this.setTitle(Constants.INSTANCE.New_Task());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Create(), new Command(){

            public void execute() {
                QuickNewTaskPopup.this.okButton();
            }
        }, IconType.PLUS_SIGN, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show(Long processInstanceId) {
        this.show();
        this.processInstanceId = processInstanceId;
    }

    public void show() {
        this.cleanForm();
        this.loadFormValues();
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.addTask();
        }
    }

    public void init() {
        long day = new Long(86400000L);
        long now = System.currentTimeMillis();
        this.dueDate.setEnabled(true);
        this.dueDate.setValue(Long.valueOf(day + now));
        this.dueDateTime.setValue(UTCTimeBox.getValueForNextHour());
        this.refreshUserGroupControls();
        KeyPressHandler keyPressHandlerText = new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                QuickNewTaskPopup.this.clearErrorMessages();
                if (event.getNativeEvent().getKeyCode() == 13) {
                    QuickNewTaskPopup.this.addTask();
                }
            }
        };
        this.textKeyPressHandler = this.taskNameText.addKeyPressHandler(keyPressHandlerText);
        this.taskNameText.setFocus(true);
        for (String priority : this.priorities) {
            this.taskPriorityListBox.addItem(priority);
        }
        this.addUserButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QuickNewTaskPopup.this.addUserControl(false);
                QuickNewTaskPopup.this.refreshUserGroupControls();
            }
        });
        this.addGroupButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QuickNewTaskPopup.this.addGroupControl();
                QuickNewTaskPopup.this.refreshUserGroupControls();
            }
        });
    }

    protected void loadFormValues() {
        ((TaskFormManagementService)this.taskFormManagementService.call((RemoteCallback)new RemoteCallback<List<String>>(){

            public void callback(List<String> deployments) {
                QuickNewTaskPopup.this.taskFormDeploymentId.addItem("");
                if (deployments != null) {
                    for (String deployment : deployments) {
                        QuickNewTaskPopup.this.taskFormDeploymentId.addItem(deployment);
                    }
                }
            }
        })).getAvailableDeployments();
        this.taskFormDeploymentId.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((TaskFormManagementService)QuickNewTaskPopup.this.taskFormManagementService.call((RemoteCallback)new RemoteCallback<List<String>>(){

                    public void callback(List<String> forms) {
                        QuickNewTaskPopup.this.taskFormName.clear();
                        QuickNewTaskPopup.this.taskFormName.addItem("");
                        if (forms != null) {
                            for (String form : forms) {
                                QuickNewTaskPopup.this.taskFormName.addItem(form);
                            }
                        }
                    }
                })).getFormsByDeployment(QuickNewTaskPopup.this.taskFormDeploymentId.getValue());
            }
        });
    }

    public void cleanForm() {
        this.tabPanel.selectTab(0);
        this.basicTab.setActive(true);
        this.advancedTab.setActive(false);
        this.userControlGroups.clear();
        this.groupControlGroups.clear();
        this.clearErrorMessages();
        this.taskNameText.setValue((Object)"");
        long day = new Long(86400000L);
        long now = System.currentTimeMillis();
        this.dueDate.setEnabled(true);
        this.dueDate.setValue(Long.valueOf(day + now));
        this.dueDateTime.setValue(UTCTimeBox.getValueForNextHour());
        this.taskPriorityListBox.setSelectedValue("0");
        this.addUserControl(true);
        this.refreshUserGroupControls();
        this.taskNameText.setFocus(true);
        this.taskFormDeploymentId.clear();
        this.taskFormDeploymentId.setSelectedValue("");
        this.taskFormName.clear();
        this.taskFormName.setSelectedValue("");
        this.processInstanceId = -1L;
    }

    public void closePopup() {
        this.cleanForm();
        this.hide();
        super.hide();
    }

    private boolean validateForm() {
        boolean valid = true;
        this.clearErrorMessages();
        if (this.taskNameText.getText() != null && this.taskNameText.getText().trim().length() == 0) {
            this.tabPanel.selectTab(0);
            this.taskNameText.setFocus(true);
            this.taskNameText.setErrorLabel((Widget)this.taskNameHelpLabel);
            this.errorMessages.setText(Constants.INSTANCE.Task_Must_Have_A_Name());
            this.errorMessagesGroup.setType(ControlGroupType.ERROR);
            this.taskNameHelpLabel.setText(Constants.INSTANCE.Task_Must_Have_A_Name());
            this.taskNameControlGroup.setType(ControlGroupType.ERROR);
            valid = false;
        } else {
            this.taskNameControlGroup.setType(ControlGroupType.SUCCESS);
        }
        return valid;
    }

    private void refreshUserGroupControls() {
        this.usersGroupsControlsPanel.clear();
        for (ControlGroup userGroupControl : this.userControlGroups) {
            this.usersGroupsControlsPanel.add((Widget)userGroupControl);
        }
        for (ControlGroup groupGroupControl : this.groupControlGroups) {
            this.usersGroupsControlsPanel.add((Widget)groupGroupControl);
        }
    }

    private void addUserControl(Boolean addCurrentUser) {
        final ControlGroup userControlGroup = new ControlGroup();
        ControlLabel userControlLabel = new ControlLabel(Constants.INSTANCE.User());
        userControlLabel.setFor("userTextBox");
        TextBox userTextBox = new TextBox();
        userTextBox.setName("userTextBox");
        if (addCurrentUser.booleanValue()) {
            userTextBox.setText(this.identity.getIdentifier());
        }
        Button removeUserButton = new Button();
        removeUserButton.setIcon(IconType.MINUS_SIGN);
        removeUserButton.setTitle(Constants.INSTANCE.Remove_User());
        removeUserButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QuickNewTaskPopup.this.userControlGroups.remove(userControlGroup);
                QuickNewTaskPopup.this.refreshUserGroupControls();
            }
        });
        userControlGroup.add((Widget)this.createHorizontalPanelForUserAndGroups(userControlLabel, userTextBox, removeUserButton));
        this.userControlGroups.add(userControlGroup);
    }

    private void addGroupControl() {
        final ControlGroup groupControlGroup = new ControlGroup();
        ControlLabel groupControlLabel = new ControlLabel(Constants.INSTANCE.Group());
        groupControlLabel.setFor("groupTextBox");
        TextBox groupTextBox = new TextBox();
        groupTextBox.setName("groupTextBox");
        Button removeGroupButton = new Button();
        removeGroupButton.setIcon(IconType.MINUS_SIGN);
        removeGroupButton.setTitle(Constants.INSTANCE.Remove_Group());
        removeGroupButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QuickNewTaskPopup.this.groupControlGroups.remove(groupControlGroup);
                QuickNewTaskPopup.this.refreshUserGroupControls();
            }
        });
        groupControlGroup.add((Widget)this.createHorizontalPanelForUserAndGroups(groupControlLabel, groupTextBox, removeGroupButton));
        this.groupControlGroups.add(groupControlGroup);
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    private void addTask() {
        this.textKeyPressHandler.removeHandler();
        List<String> users = this.getTextBoxValues(this.userControlGroups);
        List<String> groups = this.getTextBoxValues(this.groupControlGroups);
        if (users.size() == 0 && groups.size() == 0) {
            this.userControlGroups.clear();
            this.groupControlGroups.clear();
            this.addUserControl(true);
            this.refreshUserGroupControls();
            this.errorMessages.setText(Constants.INSTANCE.Provide_User_Or_Group());
            this.errorMessagesGroup.setType(ControlGroupType.ERROR);
            this.tabPanel.selectTab(1);
        } else {
            this.addTask(users, groups, this.taskNameText.getText(), this.taskPriorityListBox.getSelectedIndex(), this.dueDate.getValue(), this.dueDateTime.getValue(), this.taskFormName.getValue(), this.taskFormDeploymentId.getValue(), this.processInstanceId);
        }
    }

    public void addTask(List<String> users, List<String> groups, final String taskName, int priority, long dueDate, long dueDateTime, String taskFormName, String deploymentId, Long processInstanceId) {
        Date due = UTCDateBox.utc2date((Long)(dueDate + dueDateTime));
        boolean start = false;
        boolean claim = false;
        if (users != null && !users.isEmpty() && users.contains(this.identity.getIdentifier())) {
            start = true;
        }
        ((TaskOperationsService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
                QuickNewTaskPopup.this.cleanForm();
                QuickNewTaskPopup.this.refreshNewTask(taskId, taskName, Constants.INSTANCE.TaskCreatedWithId(String.valueOf(taskId)));
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                QuickNewTaskPopup.this.errorMessages.setText(throwable.getMessage());
                QuickNewTaskPopup.this.errorMessagesGroup.setType(ControlGroupType.ERROR);
                return true;
            }
        })).addQuickTask(taskName, priority, due, users, groups, this.identity.getIdentifier(), start, claim, taskFormName, deploymentId, processInstanceId);
    }

    private void refreshNewTask(Long taskId, String taskName, String msj) {
        this.displayNotification(msj);
        this.newTaskEvent.fire((Object)new NewTaskEvent(taskId, taskName));
        this.closePopup();
    }

    public List<String> getTextBoxValues(List<ControlGroup> controlGroups) {
        ArrayList<String> filledValues = new ArrayList<String>();
        String textBoxValue = "";
        for (ControlGroup userGroupControl : controlGroups) {
            int widgetCount = userGroupControl.getWidgetCount();
            for (int i = 0; i < widgetCount; ++i) {
                Widget widget = userGroupControl.getWidget(i);
                textBoxValue = ((TextBox)((HorizontalPanel)widget).getWidget(1)).getValue();
                if (textBoxValue == null || textBoxValue.trim().length() <= 0) continue;
                filledValues.add(textBoxValue);
            }
        }
        return filledValues;
    }

    public HorizontalPanel createHorizontalPanelForUserAndGroups(ControlLabel controlLabel, TextBox textBox, Button removeButton) {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setWidth("90%");
        horizontalPanel.add((Widget)controlLabel);
        horizontalPanel.setCellWidth((Widget)controlLabel, "10%");
        horizontalPanel.setCellHorizontalAlignment((Widget)controlLabel, HasHorizontalAlignment.ALIGN_RIGHT);
        horizontalPanel.add((Widget)textBox);
        horizontalPanel.setCellWidth((Widget)textBox, "70%");
        horizontalPanel.setCellHorizontalAlignment((Widget)textBox, HasHorizontalAlignment.ALIGN_CENTER);
        horizontalPanel.add((Widget)removeButton);
        horizontalPanel.setCellWidth((Widget)removeButton, "20%");
        horizontalPanel.setCellHorizontalAlignment((Widget)removeButton, HasHorizontalAlignment.ALIGN_CENTER);
        return horizontalPanel;
    }

    private void clearErrorMessages() {
        this.errorMessages.setText("");
        this.taskNameHelpLabel.setText("");
        this.taskNameControlGroup.setType(ControlGroupType.NONE);
    }

    static interface Binder
    extends UiBinder<Widget, QuickNewTaskPopup> {
    }
}

