/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskassignments;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.HelpBlock;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskAssignmentSummary;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.jbpm.console.ng.ht.service.TaskOperationsService;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class TaskAssignmentsPresenter {
    @Inject
    private TaskAssignmentsView view;
    @Inject
    private User identity;
    @Inject
    Caller<TaskLifeCycleService> taskServices;
    @Inject
    Caller<TaskOperationsService> taskOperationsServices;
    private long currentTaskId = 0L;
    @Inject
    private Event<TaskRefreshedEvent> taskRefreshed;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void delegateTask(String entity) {
        ((TaskLifeCycleService)this.taskServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                TaskAssignmentsPresenter.this.view.displayNotification("Task was successfully delegated");
                TaskAssignmentsPresenter.this.view.getDelegateButton().setActive(false);
                TaskAssignmentsPresenter.this.view.getUserOrGroupHelpBlock().setText(Constants.INSTANCE.DelegationSuccessfully());
                TaskAssignmentsPresenter.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(TaskAssignmentsPresenter.this.currentTaskId));
                TaskAssignmentsPresenter.this.refreshTaskPotentialOwners();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                TaskAssignmentsPresenter.this.view.getDelegateButton().setActive(true);
                TaskAssignmentsPresenter.this.view.getUserOrGroupHelpBlock().setText(Constants.INSTANCE.DelegationUnable());
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).delegate(this.currentTaskId, this.identity.getIdentifier(), entity);
    }

    public void refreshTaskPotentialOwners() {
        if (this.currentTaskId != 0L) {
            ((TaskOperationsService)this.taskOperationsServices.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

                public void callback(TaskSummary response) {
                    if (response == null) {
                        TaskAssignmentsPresenter.this.view.getDelegateButton().setEnabled(false);
                        TaskAssignmentsPresenter.this.view.getUserOrGroupText().setEnabled(false);
                        return;
                    }
                    if (response.getStatus().equals("Completed") || response.getActualOwner().equals("") || !response.getActualOwner().equals(TaskAssignmentsPresenter.this.identity.getIdentifier())) {
                        TaskAssignmentsPresenter.this.view.getDelegateButton().setEnabled(false);
                        TaskAssignmentsPresenter.this.view.getUserOrGroupText().setEnabled(false);
                    } else {
                        TaskAssignmentsPresenter.this.view.getDelegateButton().setEnabled(true);
                        TaskAssignmentsPresenter.this.view.getUserOrGroupText().setEnabled(true);
                    }
                }
            })).getTaskDetails(this.currentTaskId);
            ((TaskOperationsService)this.taskOperationsServices.call((RemoteCallback)new RemoteCallback<TaskAssignmentSummary>(){

                public void callback(TaskAssignmentSummary ts) {
                    if (ts == null) {
                        return;
                    }
                    if (ts.getPotOwnersString() != null && ts.getPotOwnersString().size() == 0) {
                        TaskAssignmentsPresenter.this.view.getUsersGroupsControlsPanel().setText(Constants.INSTANCE.No_Potential_Owners());
                    } else {
                        TaskAssignmentsPresenter.this.view.getUsersGroupsControlsPanel().setText("" + ts.getPotOwnersString().toString());
                    }
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                    return true;
                }
            })).getTaskAssignmentDetails(this.currentTaskId);
        }
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.view.getUserOrGroupHelpBlock().setText("");
        this.view.getUserOrGroupText().setText("");
        this.refreshTaskPotentialOwners();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshTaskPotentialOwners();
        }
    }

    public static interface TaskAssignmentsView
    extends IsWidget {
        public void init(TaskAssignmentsPresenter var1);

        public void displayNotification(String var1);

        public Label getUsersGroupsControlsPanel();

        public Button getDelegateButton();

        public TextBox getUserOrGroupText();

        public HelpBlock getUserOrGroupHelpBlock();
    }
}

