/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTasksListGridPresenter;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTasksListGridViewImpl;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetTaskListGridPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final String USR_ID = "admin";
    private CallerMock<TaskLifeCycleService> callerMockTaskOperationsService;
    @Mock
    private TaskLifeCycleService taskLifeCycleServiceMock;
    @Mock
    private DataSetTasksListGridViewImpl viewMock;
    @Mock
    private DataSet dataSetMock;
    @Mock
    private DataSetLookup dataSetLookupMock;
    @Mock
    DataSetQueryHelper dataSetQueryHelper;
    @Mock
    public User identity;
    @Mock
    private ExtendedPagedTable<TaskSummary> extendedPagedTable;
    @Mock
    private FilterSettings filterSettingsMock;
    private FilterSettings filterSettings;
    private DataSetTasksListGridPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMockTaskOperationsService = new CallerMock((Object)this.taskLifeCycleServiceMock);
        this.filterSettings = this.createTableSettingsPrototype();
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn(null);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        this.presenter = new DataSetTasksListGridPresenter((DataSetTasksListGridPresenter.DataSetTaskListView)this.viewMock, this.callerMockTaskOperationsService, this.dataSetQueryHelper, this.identity);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
    }

    @Test
    public void releaseTaskTest() {
        this.presenter.releaseTask(TASK_ID, USR_ID);
        ((TaskLifeCycleService)Mockito.verify((Object)this.taskLifeCycleServiceMock)).release(TASK_ID.longValue(), USR_ID);
    }

    @Test
    public void claimTaskTest() {
        this.presenter.claimTask(TASK_ID, USR_ID, "deploymentId");
        ((TaskLifeCycleService)Mockito.verify((Object)this.taskLifeCycleServiceMock)).claim(TASK_ID.longValue(), USR_ID, "deploymentId");
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset(DataSetTasksListGridViewImpl.HUMAN_TASKS_WITH_USERS_DATASET);
        builder.group("taskId");
        builder.setColumn("activationTime", "Activation Time", "MMM dd E, yyyy");
        builder.setColumn("actualOwner", "actual owner");
        builder.setColumn("createdBy", "CreatedBy");
        builder.setColumn("createdOn", "Created on", "MMM dd E, yyyy");
        builder.setColumn("deploymentId", "DeploymentId");
        builder.setColumn("description", "description");
        builder.setColumn("dueDate", "Due Date", "MMM dd E, yyyy");
        builder.setColumn("name", "tasks");
        builder.setColumn("parentId", "ParentId");
        builder.setColumn("priority", "Priority");
        builder.setColumn("processId", "ProcessId");
        builder.setColumn("processInstanceId", "ProcessInstanceId");
        builder.setColumn("processSessionId", "ProcessSesionId");
        builder.setColumn("status", "status");
        builder.setColumn("taskId", "id");
        builder.setColumn("workItemId", "WorkItemId");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("createdOn", SortOrder.DESCENDING);
        builder.tableWidth(1000);
        return builder.buildSettings();
    }

    @Test
    public void testTaskSummaryAdmin() {
        List<String> dataSets = Arrays.asList(DataSetTasksListGridViewImpl.HUMAN_TASKS_WITH_ADMINS_DATASET, DataSetTasksListGridViewImpl.HUMAN_TASKS_WITH_USERS_DATASET, DataSetTasksListGridViewImpl.HUMAN_TASKS_DATASET);
        for (String dataSet : dataSets) {
            Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettingsMock);
            Mockito.when((Object)this.filterSettingsMock.getDataSetLookup()).thenReturn((Object)this.dataSetLookupMock);
            Mockito.when((Object)this.dataSetLookupMock.getDataSetUUID()).thenReturn((Object)dataSet);
            TaskSummary summary = this.presenter.createTaskSummaryFromDataSet(this.dataSetMock, 0);
            Assert.assertNotNull((Object)summary);
            Assert.assertEquals((Object)DataSetTasksListGridViewImpl.HUMAN_TASKS_WITH_ADMINS_DATASET.equals(dataSet), (Object)summary.isForAdmin());
        }
    }

    @Test
    public void testGetUserGroupFilters() {
        Group group1 = new Group(){

            public String getName() {
                return "group1";
            }
        };
        Group group2 = new Group(){

            public String getName() {
                return "group2";
            }
        };
        HashSet<Object> groups = new HashSet<Object>();
        groups.add(group1);
        groups.add(group2);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(groups);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userId");
        ColumnFilter userTaskFilter = this.presenter.getUserGroupFilters(false);
        List columnFilters = ((LogicalExprFilter)userTaskFilter).getLogicalTerms();
        Assert.assertEquals((long)columnFilters.size(), (long)2L);
        Assert.assertEquals((Object)((LogicalExprFilter)userTaskFilter).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((Object)((LogicalExprFilter)columnFilters.get(0)).getLogicalOperator(), (Object)LogicalExprType.AND);
        List userGroupFilter = ((LogicalExprFilter)columnFilters.get(0)).getLogicalTerms();
        Assert.assertEquals((long)userGroupFilter.size(), (long)2L);
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(0)).getLogicalOperator(), (Object)LogicalExprType.OR);
        List groupFilter = ((LogicalExprFilter)userGroupFilter.get(0)).getLogicalTerms();
        List withoutActualOwnerFilter = ((LogicalExprFilter)userGroupFilter.get(1)).getLogicalTerms();
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(1)).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((long)withoutActualOwnerFilter.size(), (long)2L);
        Assert.assertEquals((Object)"actualOwner", (Object)((ColumnFilter)withoutActualOwnerFilter.get(0)).getColumnId());
        Assert.assertEquals((Object)"actualOwner", (Object)((ColumnFilter)withoutActualOwnerFilter.get(1)).getColumnId());
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(0)).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((long)groupFilter.size(), (long)3L);
        Assert.assertEquals((Object)"oeid", (Object)((ColumnFilter)groupFilter.get(0)).getColumnId());
        Assert.assertEquals((Object)"oeid", (Object)((ColumnFilter)groupFilter.get(1)).getColumnId());
        Assert.assertEquals((Object)"oeid", (Object)((ColumnFilter)groupFilter.get(2)).getColumnId());
        ColumnFilter userOwnerFilter = (ColumnFilter)columnFilters.get(1);
        Assert.assertEquals((Object)userOwnerFilter.getColumnId(), (Object)"actualOwner");
    }

    @Test
    public void addDynamicUserRolesTest() {
        Group group1 = new Group(){

            public String getName() {
                return "group1";
            }
        };
        HashSet<3> groups = new HashSet<3>();
        groups.add(group1);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(groups);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userId");
        this.presenter.setAddingDefaultFilters(false);
        this.filterSettings.getDataSetLookup().setDataSetUUID(DataSetTasksListGridViewImpl.HUMAN_TASKS_WITH_USERS_DATASET);
        this.presenter.getData(new Range(0, 5));
        ColumnFilter userTaskFilter = this.presenter.getUserGroupFilters(false);
        Assert.assertEquals((Object)((ColumnFilter)this.filterSettings.getDataSetLookup().getFirstFilterOp().getColumnFilterList().get(0)).toString(), (Object)userTaskFilter.toString());
    }

    @Test
    public void addDynamicAdminRolesTest() {
        Group group1 = new Group(){

            public String getName() {
                return "group1";
            }
        };
        HashSet<4> groups = new HashSet<4>();
        groups.add(group1);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(groups);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userId");
        this.presenter.setAddingDefaultFilters(false);
        this.filterSettings.getDataSetLookup().setDataSetUUID(DataSetTasksListGridViewImpl.HUMAN_TASKS_WITH_ADMINS_DATASET);
        this.presenter.getData(new Range(0, 5));
        ColumnFilter userTaskFilter = this.presenter.getUserGroupFilters(true);
        Assert.assertEquals((Object)((ColumnFilter)this.filterSettings.getDataSetLookup().getFirstFilterOp().getColumnFilterList().get(0)).toString(), (Object)userTaskFilter.toString());
    }
}

