/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskprocesscontext;

import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.ga.service.ItemKey;
import org.jbpm.console.ng.ht.client.editors.taskprocesscontext.TaskProcessContextPresenter;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesWithDetailsRequestEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskProcessContextPresenterTest {
    @Mock
    private TaskProcessContextPresenter.TaskProcessContextView viewMock;
    @Mock
    private PlaceManager placeManager;
    @Mock
    Event<ProcessInstancesWithDetailsRequestEvent> procNavigationMock;
    private TaskProcessContextPresenter presenter;
    private static final Long TASK_ID_NO_PROCESS = 1L;
    private static final Long TASK_ID_WITH_PROC = 2L;
    private static final Long TASK_ID_NULL_DETAILS = 3L;
    TaskSummary taskNoProcess = new TaskSummary(TASK_ID_NO_PROCESS.longValue(), "task without process", null, null, 0, null, null, null, null, null, null, -1L, -1L, null, -1L);
    TaskSummary taskWithProcess = new TaskSummary(TASK_ID_WITH_PROC.longValue(), "task with process", null, null, 0, null, null, null, null, null, "TEST_PROCESS_ID", -1L, 123L, null, -1L);

    @Before
    public void before() {
        TaskQueryService tqs = (TaskQueryService)Mockito.mock(TaskQueryService.class);
        Mockito.when((Object)tqs.getItem((ItemKey)new TaskKey(TASK_ID_NO_PROCESS))).thenReturn((Object)this.taskNoProcess);
        Mockito.when((Object)tqs.getItem((ItemKey)new TaskKey(TASK_ID_WITH_PROC))).thenReturn((Object)this.taskWithProcess);
        Mockito.when((Object)tqs.getItem((ItemKey)new TaskKey(TASK_ID_NULL_DETAILS))).thenReturn(null);
        CallerMock taskQueryServiceMock = new CallerMock((Object)tqs);
        CallerMock dataServiceCallerMock = new CallerMock(Mockito.mock(DataServiceEntryPoint.class));
        this.presenter = new TaskProcessContextPresenter(this.viewMock, this.placeManager, (Caller)taskQueryServiceMock, (Caller)dataServiceCallerMock, this.procNavigationMock);
    }

    @Test
    public void processContextEmpty_whenTaskDetailsNull() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID_NULL_DETAILS));
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }

    @Test
    public void processContextEmtpy_whenTaskNotAssociatedWithProcess() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID_NO_PROCESS));
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }

    @Test
    public void processContextShowsProcessInfo_whenTaskDetailsHasProcess() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID_WITH_PROC));
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId("TEST_PROCESS_ID");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId("123");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(true);
    }
}

