/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTasksListGridPresenter;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTasksListGridViewImpl;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetTaskListGridPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final String USR_ID = "admin";
    private CallerMock<TaskLifeCycleService> callerMockTaskOperationsService;
    @Mock
    private TaskLifeCycleService taskLifeCycleServiceMock;
    @Mock
    private DataSetTasksListGridViewImpl viewMock;
    @Mock
    DataSetQueryHelper dataSetQueryHelperMock;
    @Mock
    DataSetQueryHelper dataSetDomainDataQueryHelperMock;
    @Mock
    private ExtendedPagedTable<TaskSummary> extendedPagedTable;
    @Mock
    private DataSet dataSetMock;
    @Mock
    private DataSet dataSetTaskVarMock;
    @Mock
    private FilterSettings filterSettings;
    private DataSetTasksListGridPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMockTaskOperationsService = new CallerMock((Object)this.taskLifeCycleServiceMock);
        Mockito.when((Object)this.filterSettings.getDataSetLookup()).thenReturn((Object)new DataSetLookup());
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.viewMock.getVariablesTableSettings(Mockito.anyString())).thenReturn((Object)new DataSetTasksListGridViewImpl().getVariablesTableSettings("taskName"));
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.dataSetQueryHelperMock.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(DataSetTaskListGridPresenterTest.this.dataSetMock);
                return null;
            }
        }).when((Object)this.dataSetQueryHelperMock)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(DataSetTaskListGridPresenterTest.this.dataSetTaskVarMock);
                return null;
            }
        }).when((Object)this.dataSetDomainDataQueryHelperMock)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.presenter = new DataSetTasksListGridPresenter((DataSetTasksListGridPresenter.DataSetTaskListView)this.viewMock, this.callerMockTaskOperationsService, this.dataSetQueryHelperMock, this.dataSetDomainDataQueryHelperMock);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock)).setLastSortOrder(SortOrder.ASCENDING);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock)).setLastOrderedColumn("createdOn");
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetDomainDataQueryHelperMock, (VerificationMode)Mockito.never())).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
    }

    @Test
    public void releaseTaskTest() {
        this.presenter.releaseTask(TASK_ID, USR_ID);
        ((TaskLifeCycleService)Mockito.verify((Object)this.taskLifeCycleServiceMock)).release(TASK_ID.longValue(), USR_ID);
    }

    @Test
    public void claimTaskTest() {
        this.presenter.claimTask(TASK_ID, USR_ID, "deploymentId");
        ((TaskLifeCycleService)Mockito.verify((Object)this.taskLifeCycleServiceMock)).claim(TASK_ID.longValue(), USR_ID, "deploymentId");
    }

    public void isFilteredByTaskNameTest() {
        String taskName = "taskName";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        String filterTaskName = this.presenter.isFilteredByTaskName(Collections.singletonList(filter));
        Assert.assertEquals((Object)"taskName", (Object)filterTaskName);
    }

    public void isFilteredByTaskNameInvalidTest() {
        String taskName = "taskName";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.likeTo((String)"description", (String)"taskName")});
        String filterTaskName = this.presenter.isFilteredByTaskName(Collections.singletonList(filter));
        Assert.assertNull((Object)filterTaskName);
    }

    @Test
    public void getDomainSpecificDataForTasksTest() {
        this.presenter.setAddingDefaultFilters(false);
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        Mockito.when((Object)this.dataSetMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetQueryHelperMock.getColumnLongValue(this.dataSetMock, "taskId", 0)).thenReturn((Object)1L);
        Mockito.when((Object)this.dataSetTaskVarMock.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnLongValue(this.dataSetTaskVarMock, "taskId", 0)).thenReturn((Object)1L);
        String taskVariable1 = "var1";
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "varname", 0)).thenReturn((Object)taskVariable1);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "varvalue", 0)).thenReturn((Object)"value1");
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnLongValue(this.dataSetTaskVarMock, "taskId", 1)).thenReturn((Object)1L);
        String taskVariable2 = "var2";
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "varname", 1)).thenReturn((Object)taskVariable2);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "varvalue", 1)).thenReturn((Object)"value2");
        Set<String> expectedColumns = new HashSet<String>();
        expectedColumns.add(taskVariable1);
        expectedColumns.add(taskVariable2);
        this.presenter.getData(new Range(0, 5));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Set.class);
        ((DataSetTasksListGridViewImpl)Mockito.verify((Object)this.viewMock)).addDomainSpecifColumns((ExtendedPagedTable)Mockito.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals(expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetDomainDataQueryHelperMock)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        Mockito.when((Object)this.dataSetTaskVarMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnLongValue(this.dataSetTaskVarMock, "taskId", 0)).thenReturn((Object)1L);
        taskVariable1 = "varTest1";
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "varname", 0)).thenReturn((Object)taskVariable1);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "varvalue", 0)).thenReturn((Object)"value1");
        expectedColumns = Collections.singleton(taskVariable1);
        this.presenter.getData(new Range(0, 5));
        argument = ArgumentCaptor.forClass(Set.class);
        ((DataSetTasksListGridViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).addDomainSpecifColumns((ExtendedPagedTable)Mockito.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals(expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetDomainDataQueryHelperMock, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
    }

    @Test
    public void testTaskSummaryAdmin() {
        List<String> dataSets = Arrays.asList("jbpmHumanTasksWithAdmin", "jbpmHumanTasksWithUser", "jbpmHumanTasks", "jbpmHumanTasksWithVariables");
        for (String dataSet : dataSets) {
            Mockito.when((Object)this.dataSetMock.getUUID()).thenReturn((Object)dataSet);
            TaskSummary summary = this.presenter.createTaskSummaryFromDataSet(this.dataSetMock, 0);
            Assert.assertNotNull((Object)summary);
            Assert.assertEquals((Object)"jbpmHumanTasksWithAdmin".equals(dataSet), (Object)summary.isForAdmin());
        }
    }
}

